/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.provider.matchtable;

import docking.widgets.checkbox.GCheckBox;
import ghidra.feature.vt.api.main.VTAssociation;
import ghidra.feature.vt.api.main.VTMatch;
import ghidra.feature.vt.api.main.VTSession;
import ghidra.feature.vt.gui.filters.CheckBoxBasedAncillaryFilter;
import ghidra.feature.vt.gui.filters.CheckBoxInfo;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;

public class SymbolTypeFilter
extends CheckBoxBasedAncillaryFilter<VTMatch> {
    public SymbolTypeFilter() {
        super("Symbol Type");
    }

    @Override
    protected void createCheckBoxInfos() {
        SourceType[] values;
        ItemListener listener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SymbolTypeFilter.this.fireStatusChanged(SymbolTypeFilter.this.getFilterStatus());
            }
        };
        for (SourceType type : values = SourceType.values()) {
            GCheckBox checkBox = new GCheckBox(type.getDisplayString(), true);
            checkBox.addItemListener(listener);
            SymbolTypeCheckBoxInfo info = new SymbolTypeCheckBoxInfo(this, (JCheckBox)checkBox, type);
            this.checkBoxInfos.add(info);
        }
        GCheckBox nullSymbolCheckbox = new GCheckBox("<No Symbol>", true);
        nullSymbolCheckbox.addItemListener(listener);
        this.checkBoxInfos.add(new NullSymbolCheckBoxInfo(this, (JCheckBox)nullSymbolCheckbox));
    }

    private class SymbolTypeCheckBoxInfo
    extends CheckBoxInfo<VTMatch> {
        private SourceType sourceType;

        public SymbolTypeCheckBoxInfo(SymbolTypeFilter symbolTypeFilter, JCheckBox checkBox, SourceType sourceType) {
            super(checkBox);
            this.sourceType = sourceType;
        }

        @Override
        public boolean matchesStatus(VTMatch match) {
            SourceType sourceSymbolSourceType;
            if (!this.isSelected()) {
                return false;
            }
            VTAssociation association = match.getAssociation();
            VTSession session = association.getSession();
            Address sourceAddress = association.getSourceAddress();
            Program sourceProgram = session.getSourceProgram();
            SymbolTable sourceSymbolTable = sourceProgram.getSymbolTable();
            Symbol sourceSymbol = sourceSymbolTable.getPrimarySymbol(sourceAddress);
            if (sourceSymbol != null && (sourceSymbolSourceType = sourceSymbol.getSource()).equals((Object)this.sourceType)) {
                return true;
            }
            Address destinationAddress = association.getDestinationAddress();
            Program destinationProgram = session.getDestinationProgram();
            SymbolTable destinationSymbolTable = destinationProgram.getSymbolTable();
            Symbol destinationSymbol = destinationSymbolTable.getPrimarySymbol(destinationAddress);
            if (destinationSymbol != null) {
                SourceType destinationSymbolSourceType = destinationSymbol.getSource();
                return destinationSymbolSourceType.equals((Object)this.sourceType);
            }
            return false;
        }
    }

    private class NullSymbolCheckBoxInfo
    extends CheckBoxInfo<VTMatch> {
        NullSymbolCheckBoxInfo(SymbolTypeFilter symbolTypeFilter, JCheckBox checkBox) {
            super(checkBox);
        }

        @Override
        public boolean matchesStatus(VTMatch match) {
            if (!this.isSelected()) {
                return false;
            }
            VTAssociation association = match.getAssociation();
            VTSession session = association.getSession();
            Address sourceAddress = association.getSourceAddress();
            Program sourceProgram = session.getSourceProgram();
            SymbolTable sourceSymbolTable = sourceProgram.getSymbolTable();
            Symbol sourceSymbol = sourceSymbolTable.getPrimarySymbol(sourceAddress);
            if (sourceSymbol == null) {
                return true;
            }
            Address destinationAddress = association.getDestinationAddress();
            Program destinationProgram = session.getDestinationProgram();
            SymbolTable destinationSymbolTable = destinationProgram.getSymbolTable();
            Symbol destinationSymbol = destinationSymbolTable.getPrimarySymbol(destinationAddress);
            return destinationSymbol == null;
        }
    }
}

