/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.wizard.session;

import docking.wizard.WizardModel;
import docking.wizard.WizardStep;
import ghidra.feature.vt.gui.wizard.session.NewSessionData;
import ghidra.feature.vt.gui.wizard.session.SummaryPanel;
import ghidra.framework.model.DomainFile;
import ghidra.util.HTMLUtilities;
import ghidra.util.HelpLocation;
import javax.swing.JComponent;

public class SummaryStep
extends WizardStep<NewSessionData> {
    private SummaryPanel summaryPanel = new SummaryPanel();

    protected SummaryStep(WizardModel<NewSessionData> model) {
        super(model, "Summary", new HelpLocation("VersionTrackingPlugin", "New_Session_Summary_Panel"));
    }

    public void initialize(NewSessionData data) {
        StringBuilder label = new StringBuilder();
        StringBuilder summary = new StringBuilder();
        label.append("<html>");
        summary.append("<html>");
        label.append("Operation:");
        String opDescription = "New Version Tracking Session";
        summary.append(opDescription);
        label.append("<br>");
        summary.append("<br>");
        String sessionName = data.getSessionName();
        label.append("Session Name:");
        summary.append(sessionName);
        label.append("<br>");
        summary.append("<br>");
        String sourceProgramName = null;
        String destinationProgramName = null;
        DomainFile sourceProgram = data.getSourceFile();
        sourceProgramName = sourceProgram.getName();
        DomainFile destinationProgram = data.getDestinationFile();
        destinationProgramName = destinationProgram.getName();
        label.append("Source Program:");
        summary.append(HTMLUtilities.escapeHTML((String)sourceProgramName));
        label.append("<br>");
        summary.append("<br>");
        label.append("Destination Program:");
        summary.append(HTMLUtilities.escapeHTML((String)destinationProgramName));
        label.append("<br>");
        summary.append("<br>");
        label.append("</html>");
        summary.append("</html>");
        this.summaryPanel.initialize(label.toString(), summary.toString());
    }

    public boolean isValid() {
        return true;
    }

    public boolean apply(NewSessionData data) {
        return true;
    }

    public JComponent getComponent() {
        return this.summaryPanel;
    }

    public boolean canFinish(NewSessionData data) {
        return true;
    }

    public void populateData(NewSessionData data) {
    }
}

