/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.wrapper;

import java.nio.CharBuffer;
import java.text.Collator;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;

public class AlphaNumericComparator
implements Comparator<CharSequence> {
    private final Collator collator;

    public AlphaNumericComparator() {
        this.collator = null;
    }

    public AlphaNumericComparator(Locale locale) {
        this(Collator.getInstance(AlphaNumericComparator.requireNonNull(locale)));
    }

    public AlphaNumericComparator(Collator collator) {
        this.collator = AlphaNumericComparator.requireNonNull(collator);
    }

    @Override
    public int compare(CharSequence s1, CharSequence s2) {
        CharBuffer b1 = CharBuffer.wrap(s1);
        CharBuffer b2 = CharBuffer.wrap(s2);
        while (b1.hasRemaining() && b2.hasRemaining()) {
            this.moveWindow(b1);
            this.moveWindow(b2);
            int result = this.compare(b1, b2);
            if (result != 0) {
                return result;
            }
            this.prepareForNextIteration(b1);
            this.prepareForNextIteration(b2);
        }
        return s1.length() - s2.length();
    }

    private void moveWindow(CharBuffer buffer) {
        int start = buffer.position();
        int end = buffer.position();
        boolean isNumerical = this.isDigit(buffer.get(start));
        while (end < buffer.limit() && isNumerical == this.isDigit(buffer.get(end))) {
            if (!isNumerical || start + 1 >= buffer.limit() || !this.isZero(buffer.get(start)) || !this.isDigit(buffer.get(++end))) continue;
            ++start;
        }
        buffer.position(start).limit(end);
    }

    @Override
    private int compare(CharBuffer b1, CharBuffer b2) {
        if (this.isNumerical(b1) && this.isNumerical(b2)) {
            return this.compareNumerically(b1, b2);
        }
        return this.compareAsStrings(b1, b2);
    }

    private boolean isNumerical(CharBuffer buffer) {
        return this.isDigit(buffer.charAt(0));
    }

    private boolean isDigit(char c) {
        if (this.collator == null) {
            char intValue = c;
            return intValue >= '0' && intValue <= '9';
        }
        return this.isDigit(c);
    }

    private int compareNumerically(CharBuffer b1, CharBuffer b2) {
        int diff = b1.length() - b2.length();
        if (diff != 0) {
            return diff;
        }
        for (int i = 0; i < b1.remaining() && i < b2.remaining(); ++i) {
            int result = AlphaNumericComparator.compare(b1.charAt(i), b2.charAt(i));
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    private void prepareForNextIteration(CharBuffer buffer) {
        buffer.position(buffer.limit()).limit(buffer.capacity());
    }

    private int compareAsStrings(CharBuffer b1, CharBuffer b2) {
        if (this.collator != null) {
            return this.collator.compare(b1.toString(), b2.toString());
        }
        return b1.toString().compareTo(b2.toString());
    }

    private boolean isZero(char c) {
        return c == '0';
    }

    public static void main(String[] args) {
        List<String> x = Arrays.asList("a.20", "a.1", "a.10", "a.2", "a.03");
        Collections.sort(x, new AlphaNumericComparator());
        System.out.println(x);
    }

    public static <T> T requireNonNull(T obj) {
        if (obj == null) {
            throw new NullPointerException();
        }
        return obj;
    }

    public static int compare(char x, char y) {
        return x - y;
    }
}

