/*
 * Decompiled with CFR 0.152.
 */
package db.buffers;

import db.buffers.BufferFileManager;
import db.buffers.DataBuffer;
import db.buffers.VersionFile;
import ghidra.util.datastruct.IntIntHashtable;
import ghidra.util.exception.NoValueException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;

public class VersionFileHandler {
    private VersionFile[] versionFiles;
    private int openFileIx;
    private IntIntHashtable bufferMap = new IntIntHashtable();
    private int originalBufCount;
    private int maxBufCount;
    private long originalFileId;
    private int[] freeIndexes;
    private Hashtable<String, Integer> origParms = new Hashtable();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    VersionFileHandler(BufferFileManager bfMgr, long targetFileId, int targetVer, int origVer) throws IOException {
        this.versionFiles = new VersionFile[targetVer - origVer];
        long lastTargetFileId = 0L;
        boolean success = false;
        try {
            this.openFileIx = -1;
            for (int v = origVer; v < targetVer; ++v) {
                int i;
                if (this.openFileIx != -1) {
                    this.versionFiles[this.openFileIx].close();
                }
                VersionFile vf = new VersionFile(bfMgr.getVersionFile(v));
                this.versionFiles[++this.openFileIx] = vf;
                if (this.openFileIx == 0) {
                    this.originalBufCount = vf.getOriginalBufferCount();
                    this.freeIndexes = vf.getFreeIndexList();
                    String[] names = vf.getOldParameterNames();
                    for (i = 0; i < names.length; ++i) {
                        this.origParms.put(names[i], vf.getOldParameter(names[i]));
                    }
                    this.originalFileId = vf.getOriginalFileID();
                } else if (lastTargetFileId != vf.getOriginalFileID()) {
                    throw new IOException("Incorrect version file - wrong file ID");
                }
                lastTargetFileId = vf.getTargetFileID();
                if (this.maxBufCount < vf.getOriginalBufferCount()) {
                    this.maxBufCount = vf.getOriginalBufferCount();
                }
                int[] bufferIndexes = vf.getOldBufferIndexes();
                for (i = 0; i < bufferIndexes.length; ++i) {
                    if (this.bufferMap.contains(bufferIndexes[i])) continue;
                    this.bufferMap.put(bufferIndexes[i], this.openFileIx);
                }
            }
            if (lastTargetFileId != targetFileId) {
                throw new IOException("Incorrect version file - wrong file ID");
            }
            success = true;
        }
        finally {
            if (!success) {
                this.close();
            }
        }
    }

    void close() {
        try {
            if (this.openFileIx != -1 && this.versionFiles[this.openFileIx] != null) {
                this.versionFiles[this.openFileIx].close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    long getOriginalFileID() {
        return this.originalFileId;
    }

    int[] getFreeIndexList() {
        return this.freeIndexes;
    }

    private VersionFile getVersionFile(int vfIndex) throws IOException {
        if (this.openFileIx != vfIndex) {
            this.versionFiles[this.openFileIx].close();
            this.openFileIx = vfIndex;
            this.versionFiles[this.openFileIx].open();
        }
        return this.versionFiles[this.openFileIx];
    }

    DataBuffer getOldBuffer(DataBuffer buf, int index) throws IOException {
        try {
            int vfIndex = this.bufferMap.get(index);
            return this.getVersionFile(vfIndex).getOldBuffer(buf, index);
        }
        catch (NoValueException noValueException) {
            if (Arrays.binarySearch(this.freeIndexes, index) >= 0) {
                buf.setId(-1);
                buf.setEmpty(true);
                buf.setDirty(false);
                return buf;
            }
            return null;
        }
    }

    byte[] getReverseModMapData() {
        int bitMapSize = (this.maxBufCount + 7) / 8;
        byte[] data = new byte[bitMapSize];
        Arrays.fill(data, (byte)0);
        int excess = this.maxBufCount % 8;
        if (excess != 0) {
            int n = bitMapSize - 1;
            data[n] = (byte)(data[n] | (byte)(255 << excess));
        }
        for (int index : this.bufferMap.getKeys()) {
            if (index >= this.maxBufCount) {
                System.err.println("VersionFileHandler: unexpected buffer index");
                continue;
            }
            this.setMapDataBit(data, index);
        }
        return data;
    }

    byte[] getForwardModMapData() {
        int bitMapSize = (this.originalBufCount + 7) / 8;
        byte[] data = new byte[bitMapSize];
        Arrays.fill(data, (byte)0);
        int excess = this.originalBufCount % 8;
        if (excess != 0) {
            int n = bitMapSize - 1;
            data[n] = (byte)(data[n] | (byte)(255 << excess));
        }
        for (int index : this.bufferMap.getKeys()) {
            if (index >= this.originalBufCount) continue;
            this.setMapDataBit(data, index);
        }
        return data;
    }

    private void setMapDataBit(byte[] data, int index) {
        int byteOffset = index / 8;
        int bitMask = 1 << index % 8;
        data[byteOffset] = (byte)(data[byteOffset] | bitMask);
    }

    public int getOriginalBufferCount() {
        return this.originalBufCount;
    }

    String[] getOldParameterNames() {
        ArrayList<String> list = new ArrayList<String>();
        Enumeration<String> it = this.origParms.keys();
        while (it.hasMoreElements()) {
            String name = it.nextElement();
            list.add(name);
        }
        String[] names = new String[list.size()];
        list.toArray(names);
        return names;
    }

    int getOldParameter(String name) {
        Integer obj = this.origParms.get(name);
        if (obj == null) {
            throw new NoSuchElementException();
        }
        return obj;
    }
}

