/*
 * Decompiled with CFR 0.152.
 */
package sarif.export.ref;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import ghidra.program.model.address.Address;
import ghidra.program.model.symbol.ExternalLocation;
import ghidra.program.model.symbol.ExternalReference;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.ShiftedReference;
import ghidra.program.model.symbol.StackReference;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import sarif.export.AbstractExtWriter;
import sarif.export.SarifObject;
import sarif.export.extlib.ExtLibraryLocation;
import sarif.export.ref.ExtExternalReference;
import sarif.export.ref.ExtMemoryReference;
import sarif.export.ref.ExtReference;
import sarif.export.ref.ExtRegisterReference;
import sarif.export.ref.ExtShiftedReference;
import sarif.export.ref.ExtStackReference;
import sarif.managers.ExternalLibSarifMgr;
import sarif.managers.MarkupSarifMgr;

public class SarifReferenceWriter
extends AbstractExtWriter {
    private List<Address> references = new ArrayList<Address>();
    private ReferenceManager referenceManager;

    public SarifReferenceWriter(ReferenceManager referenceManager, List<Address> request, Writer baseWriter) throws IOException {
        super(baseWriter);
        this.referenceManager = referenceManager;
        this.references = request;
    }

    public void requestFunction(Address next) {
        this.references.add(next);
    }

    @Override
    protected void genRoot(TaskMonitor monitor) throws CancelledException, IOException {
        this.genReferences(monitor);
        this.root.add("references", (JsonElement)this.objects);
    }

    private void genReferences(TaskMonitor monitor) throws CancelledException, IOException {
        monitor.initialize((long)this.references.size());
        for (Address addr : this.references) {
            Reference[] refs = this.referenceManager.getReferencesFrom(addr);
            for (int i = 0; i < refs.length; ++i) {
                ExtReference sref;
                SarifObject sarif;
                ExtReference mref;
                if (monitor.isCancelled()) {
                    throw new CancelledException();
                }
                Reference ref = refs[i];
                if (ref.isRegisterReference()) {
                    mref = new ExtRegisterReference(ref);
                    sarif = new SarifObject("Ref.Register", MarkupSarifMgr.KEY, this.getTree(mref), ref.getFromAddress(), ref.getFromAddress());
                    this.objects.add(this.getTree(sarif));
                }
                if (ref.isMemoryReference()) {
                    mref = new ExtMemoryReference(ref);
                    sarif = new SarifObject("Ref.Memory", MarkupSarifMgr.KEY, this.getTree(mref), ref.getFromAddress(), ref.getFromAddress());
                    this.objects.add(this.getTree(sarif));
                }
                if (ref.isStackReference()) {
                    sref = new ExtStackReference((StackReference)ref);
                    sarif = new SarifObject("Ref.Stack", MarkupSarifMgr.KEY, this.getTree(sref), ref.getFromAddress(), ref.getFromAddress());
                    this.objects.add(this.getTree(sarif));
                }
                if (ref.isShiftedReference()) {
                    sref = new ExtShiftedReference((ShiftedReference)ref);
                    sarif = new SarifObject("Ref.Shifted", MarkupSarifMgr.KEY, this.getTree(sref), ref.getFromAddress(), ref.getFromAddress());
                    this.objects.add(this.getTree(sarif));
                }
                if (!ref.isExternalReference()) continue;
                ExternalReference extRef = (ExternalReference)ref;
                ExternalLocation extLoc = extRef.getExternalLocation();
                ExtLibraryLocation obj = new ExtLibraryLocation(extLoc);
                SarifObject sarif0 = new SarifObject(ExternalLibSarifMgr.SUBKEY1, ExternalLibSarifMgr.KEY, this.getTree(obj), extLoc.getAddress(), extLoc.getAddress());
                this.objects.add(this.getTree(sarif0));
                ExtExternalReference xref = new ExtExternalReference(extRef);
                SarifObject sarif2 = new SarifObject("Ref.External", MarkupSarifMgr.KEY, this.getTree(xref), ref.getFromAddress(), ref.getFromAddress());
                this.objects.add(this.getTree(sarif2));
            }
            monitor.increment();
        }
    }

    public JsonArray getResults() {
        return this.objects;
    }
}

