/*
 * Decompiled with CFR 0.152.
 */
package sarif.handlers.result;

import com.contrastsecurity.sarif.PropertyBag;
import com.contrastsecurity.sarif.Result;
import com.contrastsecurity.sarif.Run;
import ghidra.program.util.ProgramTask;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sarif.handlers.SarifResultHandler;
import sarif.managers.ProgramSarifMgr;
import sarif.model.SarifDataFrame;
import sarif.view.SarifResultsTableProvider;

public class SarifProgramResultHandler
extends SarifResultHandler {
    @Override
    public String getKey() {
        return "Message";
    }

    @Override
    public void handle(SarifDataFrame df, Run run, Result result, Map<String, Object> map) {
        Map additionalProperties;
        PropertyBag properties;
        this.df = df;
        this.controller = df.getController();
        this.run = run;
        this.result = result;
        map.put(this.getKey(), result.getMessage().getText());
        List locs = result.getLocations();
        if (locs != null) {
            map.put("Locations", locs);
        }
        if ((properties = result.getProperties()) != null && (additionalProperties = properties.getAdditionalProperties()) != null) {
            for (Map.Entry entry : additionalProperties.entrySet()) {
                map.put((String)entry.getKey(), entry.getValue());
            }
        }
    }

    @Override
    protected Object parse() {
        return null;
    }

    @Override
    public String getActionName() {
        return "Add To Program";
    }

    @Override
    public ProgramTask getTask(SarifResultsTableProvider provider) {
        return new CommitToProgramTask(this, provider);
    }

    private class CommitToProgramTask
    extends ProgramTask {
        private SarifResultsTableProvider provider;
        private ProgramSarifMgr programMgr;

        protected CommitToProgramTask(SarifProgramResultHandler sarifProgramResultHandler, SarifResultsTableProvider provider) {
            super(provider.getController().getProgram(), "CommitToProgramTask", true, true, true);
            this.provider = provider;
            this.programMgr = provider.getController().getProgramSarifMgr();
            this.programMgr.addManagers();
        }

        protected void doRun(TaskMonitor monitor) {
            int[] selected = this.provider.filterTable.getTable().getSelectedRows();
            HashMap<String, List<Map<String, Object>>> results = new HashMap<String, List<Map<String, Object>>>();
            for (int row : selected) {
                Map<String, Object> result = this.provider.getRow(row);
                String key = (String)result.get("RuleId");
                ArrayList<Map<String, Object>> list = (ArrayList<Map<String, Object>>)results.get(key);
                if (list == null) {
                    list = new ArrayList<Map<String, Object>>();
                }
                list.add(result);
                results.put(key, list);
            }
            try {
                this.programMgr.readResults(monitor, null, results);
            }
            catch (IOException e) {
                throw new RuntimeException("Read failed");
            }
        }
    }
}

