/*
 * Decompiled with CFR 0.152.
 */
package sarif.handlers.result;

import com.contrastsecurity.sarif.PropertyBag;
import com.contrastsecurity.sarif.Result;
import com.contrastsecurity.sarif.Run;
import db.Transaction;
import ghidra.program.model.address.Address;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import sarif.handlers.SarifResultHandler;
import sarif.model.SarifColumnKey;
import sarif.model.SarifDataFrame;

public class SarifPropertyResultHandler
extends SarifResultHandler {
    @Override
    public String getKey() {
        return "Property";
    }

    @Override
    public List<Address> parse() {
        return this.controller.getListingAddresses(this.run, this.result);
    }

    @Override
    public void handle(SarifDataFrame dframe, Run run, Result result, Map<String, Object> map) {
        this.controller = dframe.getController();
        List<SarifColumnKey> columns = dframe.getColumns();
        ArrayList<String> columnNames = new ArrayList<String>();
        for (SarifColumnKey c : columns) {
            columnNames.add(c.getName());
        }
        PropertyBag properties = result.getProperties();
        if (properties == null) {
            return;
        }
        Map additional = properties.getAdditionalProperties();
        if (additional == null) {
            return;
        }
        try (Transaction t = this.controller.getProgram().openTransaction("SARIF custom properties.");){
            for (String key : additional.keySet()) {
                String[] splits = key.split("/");
                switch (splits[0]) {
                    case "viewer": {
                        switch (splits[1]) {
                            case "table": {
                                if (!columnNames.contains(splits[2])) {
                                    columns.add(new SarifColumnKey(splits[2], false));
                                }
                                map.put(splits[2], additional.get(key));
                            }
                        }
                        break;
                    }
                    case "listing": {
                        this.controller.handleListingAction(run, result, splits[1], additional.get(key));
                    }
                }
            }
            t.commit();
        }
    }
}

