/*
 * Decompiled with CFR 0.152.
 */
package ghidra.generic.util.datastruct;

import ghidra.generic.util.datastruct.TreeValueSortedMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.Spliterators;

public class DynamicSortedTreeSet<E>
extends AbstractSet<E> {
    private final transient TreeValueSortedMap.ValueSortedTreeMapKeySet keys;
    private final transient TreeValueSortedMap<E, E> map;

    public DynamicSortedTreeSet() {
        this.map = new TreeValueSortedMap();
        this.keys = this.map.keySet();
    }

    public DynamicSortedTreeSet(Comparator<E> comparator) {
        this.map = new TreeValueSortedMap(comparator);
        this.keys = this.map.keySet();
    }

    @Override
    public boolean add(E e) {
        return this.map.put(e, e) == null;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    public E get(int index) {
        return (E)this.keys.get(index);
    }

    public int indexOf(Object o) {
        return this.keys.indexOf(o);
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return this.keys.iterator();
    }

    @Override
    public boolean remove(Object o) {
        return this.keys.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.keys.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.keys.retainAll(c);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Spliterator<E> spliterator() {
        return Spliterators.spliterator(this, 17);
    }

    public boolean update(E e) {
        return this.map.update(e);
    }
}

