/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util;

import generic.util.PeekableIterator;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSpace;
import ghidra.util.AbstractPeekableIterator;
import ghidra.util.MathUtilities;
import ghidra.util.PeekableIterators;
import java.util.Iterator;
import java.util.Map;

public class TwoWayBreakdownAddressRangeIterator
extends AbstractPeekableIterator<Map.Entry<AddressRange, Which>> {
    private final PeekableIterator<AddressRange> lit;
    private final PeekableIterator<AddressRange> rit;
    private final boolean forward;
    private AddressSpace curSpace = null;
    private Address cur = null;
    private final MyEntry entry = new MyEntry();

    public TwoWayBreakdownAddressRangeIterator(Iterator<AddressRange> lit, Iterator<AddressRange> rit, boolean forward) {
        this.lit = PeekableIterators.castOrWrap(lit);
        this.rit = PeekableIterators.castOrWrap(rit);
        this.forward = forward;
        this.initCur();
    }

    private void initCur() {
        if (this.lit.hasNext()) {
            this.cur = this.getStart((AddressRange)this.lit.peek());
        }
        if (this.rit.hasNext()) {
            Address a = this.getStart((AddressRange)this.rit.peek());
            this.cur = this.cur == null ? a : this.first(this.cur, a);
        }
        this.curSpace = this.cur == null ? null : this.cur.getAddressSpace();
    }

    private Address getBefore(AddressRange r, AddressSpace beforeSpace) {
        if (this.forward) {
            Address prev = r.getMinAddress().previous();
            if (prev != null) {
                return prev;
            }
            return beforeSpace.getMaxAddress();
        }
        Address next = r.getMaxAddress().next();
        if (next != null) {
            return next;
        }
        return beforeSpace.getMinAddress();
    }

    private Address getStart(AddressRange r) {
        return this.forward ? r.getMinAddress() : r.getMaxAddress();
    }

    private Address getEnd(AddressRange r) {
        return this.forward ? r.getMaxAddress() : r.getMinAddress();
    }

    private Address getAfter(AddressRange r) {
        return this.forward ? r.getMaxAddress().next() : r.getMinAddress().previous();
    }

    private Address first(Address a, Address b) {
        return this.forward ? (Address)MathUtilities.cmin((Comparable)a, (Comparable)b) : (Address)MathUtilities.cmax((Comparable)a, (Comparable)b);
    }

    private Address last(Address a, Address b) {
        return this.forward ? (Address)MathUtilities.cmax((Comparable)a, (Comparable)b) : (Address)MathUtilities.cmin((Comparable)a, (Comparable)b);
    }

    private int cmp(Address a, Address b) {
        return this.forward ? a.compareTo((Object)b) : b.compareTo((Object)a);
    }

    private AddressRange truncateRange(Address beg, Address end) {
        return this.forward ? new AddressRangeImpl((Address)MathUtilities.cmax((Comparable)this.cur, (Comparable)beg), end) : new AddressRangeImpl(end, (Address)MathUtilities.cmin((Comparable)this.cur, (Comparable)beg));
    }

    private AddressRange truncateRange(AddressRange rng) {
        if (!rng.contains(this.cur)) {
            return rng;
        }
        return this.forward ? this.truncateRange(rng.getMinAddress(), rng.getMaxAddress()) : this.truncateRange(rng.getMaxAddress(), rng.getMinAddress());
    }

    private void findSuitable(PeekableIterator<AddressRange> it) {
        while (it.hasNext() && this.cmp(this.getEnd((AddressRange)it.peek()), this.cur) < 0) {
            it.next();
        }
    }

    private void advanceSpace(PeekableIterator<AddressRange> it) {
        while (it.hasNext() && ((AddressRange)it.peek()).getAddressSpace() == this.curSpace) {
            it.next();
        }
    }

    private void advanceSpace() {
        this.advanceSpace(this.lit);
        this.advanceSpace(this.rit);
    }

    private void advance() {
        this.cur = this.getAfter(this.entry.key);
        if (this.cur == null) {
            this.advanceSpace();
            this.initCur();
        }
    }

    @Override
    protected Map.Entry<AddressRange, Which> seekNext() {
        boolean rc;
        if (this.cur == null) {
            return null;
        }
        this.findSuitable(this.lit);
        this.findSuitable(this.rit);
        boolean ln = this.lit.hasNext();
        boolean rn = this.rit.hasNext();
        if (!ln && !rn) {
            return null;
        }
        if (ln && !rn) {
            this.entry.key = this.truncateRange((AddressRange)this.lit.next());
            this.entry.val = Which.LEFT;
            this.advance();
            return this.entry;
        }
        if (!ln && rn) {
            this.entry.key = this.truncateRange((AddressRange)this.rit.next());
            this.entry.val = Which.RIGHT;
            this.advance();
            return this.entry;
        }
        Address adv = this.first(this.getStart((AddressRange)this.lit.peek()), this.getStart((AddressRange)this.rit.peek()));
        this.cur = this.cur == null ? adv : this.last(this.cur, adv);
        boolean lc = this.cmp(this.getStart((AddressRange)this.lit.peek()), this.cur) <= 0;
        boolean bl = rc = this.cmp(this.getStart((AddressRange)this.rit.peek()), this.cur) <= 0;
        if (lc && rc) {
            Address beg = this.last(this.getStart((AddressRange)this.lit.peek()), this.getStart((AddressRange)this.rit.peek()));
            Address end = this.first(this.getEnd((AddressRange)this.lit.peek()), this.getEnd((AddressRange)this.rit.peek()));
            this.entry.key = this.truncateRange(beg, end);
            this.entry.val = Which.BOTH;
            this.advance();
            return this.entry;
        }
        if (lc && !rc) {
            Address beg = this.getStart((AddressRange)this.lit.peek());
            Address end = this.first(this.getEnd((AddressRange)this.lit.peek()), this.getBefore((AddressRange)this.rit.peek(), beg.getAddressSpace()));
            this.entry.key = this.truncateRange(beg, end);
            this.entry.val = Which.LEFT;
            this.advance();
            return this.entry;
        }
        if (!lc && rc) {
            Address beg = this.getStart((AddressRange)this.rit.peek());
            Address end = this.first(this.getEnd((AddressRange)this.rit.peek()), this.getBefore((AddressRange)this.lit.peek(), beg.getAddressSpace()));
            this.entry.key = this.truncateRange(beg, end);
            this.entry.val = Which.RIGHT;
            this.advance();
            return this.entry;
        }
        throw new AssertionError();
    }

    public static class MyEntry
    implements Map.Entry<AddressRange, Which> {
        private AddressRange key;
        private Which val;

        @Override
        public AddressRange getKey() {
            return this.key;
        }

        @Override
        public Which getValue() {
            return this.val;
        }

        @Override
        public Which setValue(Which value) {
            throw new UnsupportedOperationException();
        }
    }

    public static enum Which {
        LEFT(true, false),
        RIGHT(false, true),
        BOTH(true, true);

        public final boolean includesLeft;
        public final boolean includesRight;

        private Which(boolean includesLeft, boolean includesRight) {
            this.includesLeft = includesLeft;
            this.includesRight = includesRight;
        }

        public boolean inSubtract() {
            return this == LEFT;
        }

        public boolean inXor() {
            return this == LEFT || this == RIGHT;
        }

        public boolean inIntersect() {
            return this == BOTH;
        }
    }
}

