/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.database;

import db.DBBuffer;
import java.io.IOException;
import java.io.InputStream;

public class DBBufferInputStream
extends InputStream {
    protected final DBBuffer buffer;
    protected int offset;
    protected int mark = -1;

    public DBBufferInputStream(DBBuffer buffer) {
        this.buffer = buffer;
        this.offset = 0;
    }

    @Override
    public int available() throws IOException {
        return this.buffer.length() - this.offset;
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.mark = this.offset;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public int read(byte[] b) throws IndexOutOfBoundsException, IOException {
        if (this.offset == this.buffer.length()) {
            return -1;
        }
        int len = Math.min(this.available(), b.length);
        this.buffer.get(this.offset, b, 0, len);
        this.offset += len;
        return len;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IndexOutOfBoundsException, IOException {
        if (this.offset == this.buffer.length()) {
            return -1;
        }
        len = Math.min(this.available(), len);
        this.buffer.get(this.offset, b, off, len);
        this.offset += len;
        return len;
    }

    @Override
    public int read() throws IOException {
        if (this.offset == this.buffer.length()) {
            return -1;
        }
        return 0xFF & this.buffer.getByte(this.offset++);
    }

    @Override
    public byte[] readAllBytes() throws IOException {
        byte[] result = new byte[this.available()];
        this.buffer.get(this.offset, result);
        this.offset += result.length;
        return result;
    }

    @Override
    public int readNBytes(byte[] b, int off, int len) throws IOException {
        return this.read(b, off, len);
    }

    @Override
    public byte[] readNBytes(int len) throws IOException {
        len = Math.min(this.available(), len);
        byte[] result = new byte[len];
        this.buffer.get(this.offset, result);
        this.offset += len;
        return result;
    }

    @Override
    public synchronized void reset() throws IOException {
        if (this.mark == -1) {
            throw new IOException("No mark");
        }
        this.offset = this.mark;
    }

    @Override
    public long skip(long n) throws IOException {
        if (n < 0L) {
            return 0L;
        }
        n = Math.min((long)this.available(), n);
        this.offset = (int)((long)this.offset + n);
        return n;
    }
}

