/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.apk;

import docking.action.DockingAction;
import docking.action.builder.ActionBuilder;
import docking.widgets.filechooser.GhidraFileChooser;
import docking.widgets.filechooser.GhidraFileChooserMode;
import ghidra.file.eclipse.AndroidProjectCreator;
import ghidra.file.jad.JadProcessWrapper;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FSUtilities;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.formats.gfilesystem.RefdFile;
import ghidra.plugins.fsbrowser.FSBActionContext;
import ghidra.plugins.fsbrowser.FSBFileHandler;
import ghidra.plugins.fsbrowser.FSBFileHandlerContext;
import ghidra.plugins.fsbrowser.FSBIcons;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.io.FilenameUtils;

public class ApkFSBFileHandler
implements FSBFileHandler {
    private FSBFileHandlerContext context;
    private File lastDirectory;

    public void init(FSBFileHandlerContext context) {
        this.context = context;
    }

    private static boolean isAPK(FSRL fsrl) {
        return fsrl != null && fsrl.getName() != null && "apk".equalsIgnoreCase(FilenameUtils.getExtension((String)fsrl.getName()));
    }

    public List<DockingAction> createActions() {
        return List.of((DockingAction)new ActionBuilder("FSB Export Eclipse Project", this.context.plugin().getName()).withContext(FSBActionContext.class).enabledWhen(ac -> ac.notBusy() && JadProcessWrapper.isJadPresent() && ApkFSBFileHandler.isAPK(ac.getFileFSRL())).popupMenuPath(new String[]{"Export Eclipse Project"}).popupMenuIcon(FSBIcons.ECLIPSE).popupMenuGroup("H").onAction(ac -> {
            FSRL fsrl = ac.getFileFSRL();
            if (fsrl == null) {
                Msg.info((Object)this, (Object)"Unable to export eclipse project");
                return;
            }
            this.lastDirectory = this.lastDirectory == null ? new File(System.getProperty("user.home")) : this.lastDirectory;
            GhidraFileChooser chooser = new GhidraFileChooser((Component)ac.getSourceComponent());
            chooser.setFileSelectionMode(GhidraFileChooserMode.DIRECTORIES_ONLY);
            chooser.setTitle("Select Eclipse Project Directory");
            chooser.setApproveButtonText("SELECT");
            chooser.setCurrentDirectory(this.context.plugin().getLastExportDirectory());
            File selectedFile = chooser.getSelectedFile();
            chooser.dispose();
            if (selectedFile == null) {
                return;
            }
            this.lastDirectory = selectedFile;
            ac.getComponentProvider().runTask(monitor -> this.doExportToEclipse(fsrl, this.lastDirectory, monitor));
        }).build());
    }

    private void doExportToEclipse(FSRL fsrl, File outputDirectory, TaskMonitor monitor) {
        try (RefdFile refdFile = FileSystemService.getInstance().getRefdFile(fsrl, monitor);){
            AndroidProjectCreator creator = new AndroidProjectCreator(refdFile.file.getFSRL(), outputDirectory);
            creator.create(monitor);
            if (creator.getLog().hasMessages()) {
                Msg.showInfo((Object)this, null, (String)"Export to Eclipse Project", (Object)creator.getLog().toString());
            }
        }
        catch (CancelledException | IOException e) {
            FSUtilities.displayException((Object)this, null, (String)"Error Exporting to Eclipse", (String)e.getMessage(), (Throwable)e);
        }
    }
}

