/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.art;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.file.formats.android.art.ArtMethod;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ArtMethodGroup
implements StructConverter {
    private int pointerSize;
    private long methodCount;
    private List<ArtMethod> methodList = new ArrayList<ArtMethod>();

    public ArtMethodGroup(BinaryReader reader, int pointerSize, String artVersion) throws IOException {
        this.pointerSize = pointerSize;
        if (pointerSize == 8) {
            this.methodCount = reader.readNextLong();
        } else if (pointerSize == 4) {
            this.methodCount = Integer.toUnsignedLong(reader.readNextInt());
        }
        if (this.methodCount > 65535L) {
            throw new IOException("Too many ART methods: " + this.methodCount);
        }
        int i = 0;
        while ((long)i < this.methodCount) {
            this.methodList.add(new ArtMethod(reader, pointerSize, artVersion));
            ++i;
        }
    }

    public long getMethodCount() {
        return this.methodCount;
    }

    public List<ArtMethod> getMethodList() {
        return this.methodList;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType structure = new StructureDataType(ArtMethodGroup.class.getSimpleName() + "_" + this.methodCount, 0);
        structure.setCategoryPath(new CategoryPath("/art"));
        if (this.pointerSize == 8) {
            structure.add(QWORD, "methodCount", null);
        } else if (this.pointerSize == 4) {
            structure.add(DWORD, "methodCount", null);
        }
        int i = 0;
        while ((long)i < this.methodCount) {
            structure.add(this.methodList.get(i).toDataType(), "method_" + i, null);
            ++i;
        }
        return structure;
    }
}

