/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.bootldr;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.file.formats.android.bootldr.AndroidBootLoaderConstants;
import ghidra.file.formats.android.bootldr.AndroidBootLoaderImageInfo;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class AndroidBootLoaderHeader
implements StructConverter {
    private String magic;
    private int numberOfImages;
    private int startOffset;
    private int bootLoaderSize;
    private List<AndroidBootLoaderImageInfo> imageInfoList = new ArrayList<AndroidBootLoaderImageInfo>();

    public AndroidBootLoaderHeader(BinaryReader reader) throws IOException {
        this.magic = reader.readNextAsciiString(AndroidBootLoaderConstants.BOOTLDR_MAGIC_SIZE);
        this.numberOfImages = reader.readNextInt();
        this.startOffset = reader.readNextInt();
        this.bootLoaderSize = reader.readNextInt();
        for (int i = 0; i < this.numberOfImages; ++i) {
            this.imageInfoList.add(new AndroidBootLoaderImageInfo(reader));
        }
    }

    public String getMagic() {
        return this.magic;
    }

    public int getNumberOfImages() {
        return this.numberOfImages;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public int getBootLoaderSize() {
        return this.bootLoaderSize;
    }

    public List<AndroidBootLoaderImageInfo> getImageInfoList() {
        return new ArrayList<AndroidBootLoaderImageInfo>(this.imageInfoList);
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("bootloader_images_header_" + this.numberOfImages, 0);
        struct.add(STRING, AndroidBootLoaderConstants.BOOTLDR_MAGIC_SIZE, "magic", null);
        struct.add(DWORD, "num_images", null);
        struct.add(DWORD, "start_offset", null);
        struct.add(DWORD, "bootldr_size", null);
        for (int i = 0; i < this.numberOfImages; ++i) {
            struct.add(this.imageInfoList.get(i).toDataType(), "img_info[" + i + "]", null);
        }
        return struct;
    }
}

