/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.bplist;

import ghidra.app.util.bin.BinaryReader;
import ghidra.file.formats.bplist.BinaryPropertyListTrailer;
import ghidra.file.formats.bplist.NSArray;
import ghidra.file.formats.bplist.NSData;
import ghidra.file.formats.bplist.NSDate;
import ghidra.file.formats.bplist.NSDictionary;
import ghidra.file.formats.bplist.NSNumber;
import ghidra.file.formats.bplist.NSObject;
import ghidra.file.formats.bplist.NSSet;
import ghidra.file.formats.bplist.NSString;
import ghidra.file.formats.bplist.NSStringTypes;
import ghidra.file.formats.bplist.UID;
import java.io.IOException;

public final class NSObjectParser {
    public static NSObject parseObject(BinaryReader reader, int objectOffset, BinaryPropertyListTrailer trailer) throws IOException {
        reader.setPointerIndex(objectOffset);
        byte objectDescriptor = reader.readNextByte();
        int objectType = (objectDescriptor & 0xF0) >> 4;
        int objectInfo = objectDescriptor & 0xF;
        switch (objectType) {
            case 0: {
                switch (objectInfo) {
                    case 0: {
                        return null;
                    }
                    case 8: {
                        return new NSNumber(false);
                    }
                    case 9: {
                        return new NSNumber(true);
                    }
                    case 12: {
                        return null;
                    }
                    case 13: {
                        return null;
                    }
                    case 14: {
                        return null;
                    }
                    case 15: {
                        return null;
                    }
                }
                throw new IOException("WARNING: The binary PLIST contains unknown SIMPLE object type: " + objectInfo);
            }
            case 1: {
                int length = (int)Math.pow(2.0, objectInfo);
                switch (length) {
                    case 1: {
                        byte value = reader.readByte((long)(objectOffset + 1));
                        return new NSNumber(value);
                    }
                    case 2: {
                        short value = reader.readShort((long)(objectOffset + 1));
                        return new NSNumber(value);
                    }
                    case 4: {
                        int value = reader.readInt((long)(objectOffset + 1));
                        return new NSNumber(value);
                    }
                    case 8: {
                        long value = reader.readLong((long)(objectOffset + 1));
                        return new NSNumber(value);
                    }
                }
                throw new IOException("WARNING: Invalid integer length specified in the binary PList.");
            }
            case 2: {
                int length = (int)Math.pow(2.0, objectInfo);
                if (length == 4) {
                    int intValue = reader.readInt((long)(objectOffset + 1));
                    float floatValue = Float.intBitsToFloat(intValue);
                    return new NSNumber(floatValue);
                }
                if (length == 8) {
                    long longValue = reader.readLong((long)(objectOffset + 1));
                    double doubleValue = Double.longBitsToDouble(longValue);
                    return new NSNumber(doubleValue);
                }
                throw new IOException("WARNING: Invalid real number length specified in the binary PList.");
            }
            case 3: {
                if (objectInfo != 3) {
                    throw new IOException("WARNING: Binary PLIST contains unknown date type:" + objectInfo);
                }
                long longValue = reader.readLong((long)(objectOffset + 1));
                double doubleValue = Double.longBitsToDouble(longValue);
                return new NSDate(doubleValue);
            }
            case 4: {
                int length = NSObjectParser.parseLength(reader, objectInfo);
                return new NSData(reader.readNextByteArray(length));
            }
            case 5: {
                int length = NSObjectParser.parseLength(reader, objectInfo);
                return new NSString(reader.readNextAsciiString(length), NSStringTypes.TYPE_ASCII);
            }
            case 6: {
                int length = NSObjectParser.parseLength(reader, objectInfo);
                return new NSString(reader.readNextUnicodeString(length), NSStringTypes.TYPE_UTF16BE);
            }
            case 8: {
                int length = reader.readNextByte() & 0xFF;
                return new UID(reader.readNextByteArray(length));
            }
            case 10: {
                int length = NSObjectParser.parseLength(reader, objectInfo);
                NSArray array = new NSArray(trailer.getObjectRefSize());
                for (int i = 0; i < length; ++i) {
                    int value;
                    if (trailer.getObjectRefSize() == 1) {
                        value = reader.readNextByte() & 0xFF;
                        array.add(value);
                        continue;
                    }
                    if (trailer.getObjectRefSize() == 2) {
                        value = reader.readNextShort() & 0xFFFF;
                        array.add(value);
                        continue;
                    }
                    if (trailer.getObjectRefSize() == 4) {
                        value = reader.readNextInt();
                        array.add(value);
                        continue;
                    }
                    throw new RuntimeException("Invalid offset size in binary PList");
                }
                return array;
            }
            case 11: {
                int length = NSObjectParser.parseLength(reader, objectInfo);
                NSSet set = new NSSet(true, trailer.getObjectRefSize());
                for (int i = 0; i < length; ++i) {
                    int value;
                    if (trailer.getObjectRefSize() == 1) {
                        value = reader.readNextByte() & 0xFF;
                        set.add(value);
                        continue;
                    }
                    if (trailer.getObjectRefSize() == 2) {
                        value = reader.readNextShort() & 0xFFFF;
                        set.add(value);
                        continue;
                    }
                    if (trailer.getObjectRefSize() == 4) {
                        value = reader.readNextInt();
                        set.add(value);
                        continue;
                    }
                    throw new RuntimeException("Invalid offset size in binary PList");
                }
                return set;
            }
            case 12: {
                int length = NSObjectParser.parseLength(reader, objectInfo);
                NSSet set = new NSSet(false, trailer.getObjectRefSize());
                for (int i = 0; i < length; ++i) {
                    int value;
                    if (trailer.getObjectRefSize() == 1) {
                        value = reader.readNextByte() & 0xFF;
                        set.add(value);
                        continue;
                    }
                    if (trailer.getObjectRefSize() == 2) {
                        value = reader.readNextShort() & 0xFFFF;
                        set.add(value);
                        continue;
                    }
                    if (trailer.getObjectRefSize() == 4) {
                        value = reader.readNextInt();
                        set.add(value);
                        continue;
                    }
                    throw new RuntimeException("Invalid offset size in binary PList");
                }
                return set;
            }
            case 13: {
                int length = NSObjectParser.parseLength(reader, objectInfo);
                NSDictionary dictionary = new NSDictionary(trailer.getObjectRefSize());
                for (int i = 0; i < length; ++i) {
                    int value;
                    int key;
                    if (trailer.getObjectRefSize() == 1) {
                        key = reader.readNextByte() & 0xFF;
                        value = reader.readNextByte() & 0xFF;
                        dictionary.put(key, value);
                        continue;
                    }
                    if (trailer.getObjectRefSize() == 2) {
                        key = reader.readNextShort() & 0xFFFF;
                        value = reader.readNextShort() & 0xFFFF;
                        dictionary.put(key, value);
                        continue;
                    }
                    if (trailer.getObjectRefSize() == 4) {
                        key = reader.readNextInt();
                        value = reader.readNextInt();
                        dictionary.put(key, value);
                        continue;
                    }
                    throw new RuntimeException("Invalid offset size in binary PList");
                }
                return dictionary;
            }
        }
        throw new IOException("WARNING: The binary PLIST contains unknown object type: " + objectType);
    }

    private static int parseLength(BinaryReader reader, int objectInfo) throws IOException {
        int length = objectInfo;
        if (objectInfo == 15) {
            int offset = reader.readNextByte() & 0xFF;
            if (offset == 16) {
                length = reader.readNextByte() & 0xFF;
            } else if (offset == 17) {
                length = reader.readNextShort() & 0xFFFF;
            } else {
                throw new RuntimeException();
            }
        }
        return length;
    }
}

