/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.dump;

import ghidra.app.util.MemoryBlockUtils;
import ghidra.app.util.Option;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.opinion.AbstractProgramWrapperLoader;
import ghidra.app.util.opinion.LoadSpec;
import ghidra.app.util.opinion.Loader;
import ghidra.app.util.opinion.QueryOpinionService;
import ghidra.app.util.opinion.QueryResult;
import ghidra.file.formats.dump.DumpAddressObject;
import ghidra.file.formats.dump.DumpData;
import ghidra.file.formats.dump.DumpFile;
import ghidra.file.formats.dump.DumpFileReader;
import ghidra.file.formats.dump.apport.Apport;
import ghidra.file.formats.dump.mdmp.Minidump;
import ghidra.file.formats.dump.pagedump.Pagedump;
import ghidra.file.formats.dump.userdump.Userdump;
import ghidra.framework.model.DomainObject;
import ghidra.framework.store.LockException;
import ghidra.program.database.mem.FileBytes;
import ghidra.program.database.mem.MemoryMapDB;
import ghidra.program.database.register.AddressRangeObjectMap;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.data.ProgramBasedDataTypeManager;
import ghidra.program.model.lang.Language;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.mem.MemoryBlockException;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.exception.NotFoundException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class DumpFileLoader
extends AbstractProgramWrapperLoader {
    public static final String DF_NAME = "Dump File Loader";
    public static final String MEMORY = "Memory";
    private AddressRangeObjectMap<String> rangeMap = new AddressRangeObjectMap();
    private MessageLog log;

    public String getName() {
        return DF_NAME;
    }

    public Collection<LoadSpec> findSupportedLoadSpecs(ByteProvider provider) throws IOException {
        ArrayList<LoadSpec> loadSpecs = new ArrayList<LoadSpec>();
        String machineType = this.getMachineType(provider);
        if (machineType != null) {
            List results = QueryOpinionService.query((String)this.getName(), (String)machineType, null);
            for (QueryResult result : results) {
                loadSpecs.add(new LoadSpec((Loader)this, 0L, result));
            }
            if (loadSpecs.isEmpty()) {
                loadSpecs.add(new LoadSpec((Loader)this, 0L, true));
            }
        }
        return loadSpecs;
    }

    private String getMachineType(ByteProvider provider) {
        DumpFileReader reader = new DumpFileReader(provider, true, 64);
        try {
            int signature = reader.readInt(0L);
            switch (signature) {
                case 1162297680: {
                    return Pagedump.getMachineType(reader);
                }
                case 1380275029: {
                    return Userdump.getMachineType(reader);
                }
                case 1347241037: {
                    return Minidump.getMachineType(reader);
                }
                case 1651470928: {
                    return Apport.getMachineType(reader);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    protected void load(ByteProvider provider, LoadSpec loadSpec, List<Option> options, Program program, TaskMonitor monitor, MessageLog log) throws CancelledException, IOException {
        this.log = log;
        this.parseDumpFile(provider, program, options, loadSpec, monitor);
    }

    private void parseDumpFile(ByteProvider provider, Program program, List<Option> options, LoadSpec loadSpec, TaskMonitor monitor) throws IOException, CancelledException {
        Language language = program.getLanguage();
        int size = language.getDefaultSpace().getSize();
        DumpFileReader reader = new DumpFileReader(provider, true, size);
        ProgramBasedDataTypeManager dtm = program.getDataTypeManager();
        DumpFile df = null;
        int signature = reader.readInt(0L);
        switch (signature) {
            case 1162297680: {
                df = new Pagedump(reader, dtm, options, monitor);
                break;
            }
            case 1380275029: {
                df = new Userdump(reader, dtm, options, monitor);
                break;
            }
            case 1347241037: {
                df = new Minidump(reader, dtm, options, monitor);
                break;
            }
            case 1651470928: {
                df = new Apport(reader, dtm, options, monitor, loadSpec, this.log);
            }
        }
        if (df != null) {
            this.groupRanges(program, df, monitor);
            this.loadRanges(program, df, monitor);
            this.applyStructures(program, df, monitor);
            df.analyze(monitor);
        }
    }

    public void loadRanges(Program program, DumpFile df, TaskMonitor monitor) {
        block13: {
            Map<Address, DumpAddressObject> daos = df.getInteriorAddressRanges();
            if (daos.isEmpty()) {
                return;
            }
            try {
                DumpAddressObject d;
                FileBytes fileBytes = df.getFileBytes(monitor);
                if (fileBytes == null) {
                    Msg.error((Object)((Object)this), (Object)("File bytes not provided by DumpFile: " + df.getClass().getSimpleName()));
                    return;
                }
                int count = 0;
                monitor.setMessage("Tagging blocks");
                monitor.initialize((long)daos.size());
                for (Address address : daos.keySet()) {
                    d = daos.get(address);
                    String name = (String)this.rangeMap.getObject(address);
                    if (name == null) {
                        name = d.getProviderId();
                    }
                    d.setRangeName(name);
                    monitor.setProgress((long)count++);
                    monitor.checkCancelled();
                }
                count = 0;
                monitor.setMessage("Processing blocks");
                monitor.initialize((long)daos.size());
                for (Address address : daos.keySet()) {
                    d = daos.get(address);
                    try {
                        MemoryBlockUtils.createInitializedBlock((Program)program, (boolean)false, (String)d.getRangeName(), (Address)address, (FileBytes)fileBytes, (long)d.getRVA(), (long)d.getLength(), (String)d.getComment(), null, (boolean)d.isRead(), (boolean)d.isWrite(), (boolean)d.isExec(), (MessageLog)this.log);
                        monitor.setProgress((long)count++);
                        monitor.checkCancelled();
                    }
                    catch (AddressOutOfBoundsException | AddressOverflowException | IllegalArgumentException e) {
                        Msg.warn((Object)((Object)this), (Object)e.getMessage());
                    }
                }
                if (!df.joinBlocksEnabled()) break block13;
                HashSet<Address> deleted = new HashSet<Address>();
                count = 0;
                monitor.setMessage("Joining blocks");
                monitor.initialize((long)daos.size());
                MemoryMapDB memory = (MemoryMapDB)program.getMemory();
                for (Address address : daos.keySet()) {
                    MemoryBlock next;
                    if (deleted.contains(address)) continue;
                    MemoryBlock m = memory.getBlock(address);
                    while ((next = memory.getBlock(address.addWrap(m.getSize()))) != null && next.getStart().equals((Object)m.getStart().addWrap(m.getSize()))) {
                        try {
                            m = memory.join(m, next);
                        }
                        catch (LockException | MemoryBlockException | NotFoundException e) {
                            break;
                        }
                        deleted.add(next.getStart());
                        monitor.setProgress((long)count++);
                        monitor.checkCancelled();
                    }
                    monitor.setProgress((long)count++);
                    monitor.checkCancelled();
                }
            }
            catch (CancelledException | IOException e1) {
                Msg.error((Object)((Object)this), (Object)e1.getMessage());
            }
        }
    }

    public void groupRanges(Program program, DumpFile df, TaskMonitor monitor) throws CancelledException {
        Map<Address, DumpAddressObject> daos = df.getExteriorAddressRanges();
        if (daos.isEmpty()) {
            return;
        }
        monitor.setMessage("Assigning ranges");
        monitor.initialize((long)daos.size());
        int count = 0;
        for (Map.Entry<Address, DumpAddressObject> entry : daos.entrySet()) {
            monitor.checkCancelled();
            monitor.setProgress((long)count++);
            DumpAddressObject d = entry.getValue();
            Address address = entry.getKey();
            if (d.getBase() == 0L) continue;
            try {
                this.rangeMap.setObject(address, address.addNoWrap(d.getLength() - 1L), (Object)d.getProviderId());
            }
            catch (AddressOutOfBoundsException | AddressOverflowException | IllegalArgumentException e) {
                Msg.warn((Object)((Object)this), (Object)e.getMessage());
            }
        }
    }

    private void applyStructures(Program program, DumpFile df, TaskMonitor monitor) throws CancelledException {
        SymbolTable symbolTable = program.getSymbolTable();
        monitor.setMessage("Applying data structures");
        List<DumpData> data = df.getData();
        if (data.isEmpty()) {
            return;
        }
        monitor.initialize((long)data.size());
        int count = 0;
        for (DumpData dd : data) {
            monitor.checkCancelled();
            monitor.setProgress((long)count++);
            Address address = program.getImageBase().addWrap(dd.getOffset());
            try {
                if (dd.getDataType() == null) {
                    try {
                        symbolTable.createLabel(address, dd.getName(), SourceType.IMPORTED);
                    }
                    catch (InvalidInputException e) {
                        Msg.error((Object)((Object)this), (Object)("Error creating label " + dd.getName() + " at address " + String.valueOf(address) + ": " + e.getMessage()));
                    }
                    continue;
                }
                DataUtilities.createData((Program)program, (Address)address, (DataType)dd.getDataType(), (int)-1, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
            }
            catch (CodeUnitInsertionException e) {
                Msg.error((Object)((Object)this), (Object)("Could not create " + dd.getDataType().getName() + " at " + String.valueOf(address)));
            }
        }
    }

    public List<Option> getDefaultOptions(ByteProvider provider, LoadSpec loadSpec, DomainObject domainObject, boolean isLoadIntoProgram) {
        ArrayList<Option> options = new ArrayList<Option>();
        try {
            int size = loadSpec.getLanguageCompilerSpec().getLanguage().getDefaultSpace().getSize();
            DumpFileReader reader = new DumpFileReader(provider, true, size);
            int signature = reader.readInt(0L);
            switch (signature) {
                case 1162297680: {
                    options.addAll(Pagedump.getDefaultOptions(reader));
                    break;
                }
                case 1380275029: {
                    options.addAll(Userdump.getDefaultOptions(reader));
                    break;
                }
                case 1347241037: {
                    options.addAll(Minidump.getDefaultOptions(reader));
                    break;
                }
                case 1651470928: {
                    options.addAll(Apport.getDefaultOptions(reader));
                }
            }
        }
        catch (IOException e) {
            Msg.error((Object)((Object)this), (Object)"Unexpected error", (Throwable)e);
        }
        return options;
    }

    public String validateOptions(ByteProvider provider, LoadSpec loadSpec, List<Option> options, Program program) {
        return super.validateOptions(provider, loadSpec, options, program);
    }
}

