/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.dump.mdmp;

import ghidra.app.util.bin.StructConverter;
import ghidra.file.formats.dump.DumpFileReader;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class MiscInfoStream
implements StructConverter {
    public static final String NAME = "MINIDUMP_MISC_INFO";
    private int sizeOfInfo;
    private int flags1;
    private int processId;
    private int processCreateTime;
    private int processUserTime;
    private int processKernelTime;
    private int processorMaxMhz;
    private int processorCurrentMhz;
    private int processorMhzLimit;
    private int processorMaxIdleState;
    private int processorCurrentIdleState;
    private int processIntegrityLevel;
    private int processExecuteFlags;
    private int protectedProcess;
    private int timeZoneId;
    private int bias;
    private String standardName;
    private int standardBias;
    private String daylightName;
    private int daylightBias;
    private String buildString;
    private String dbgBuildStr;
    private DumpFileReader reader;
    private long index;
    private boolean format2;
    private boolean format3;
    private boolean format4;

    MiscInfoStream(DumpFileReader reader, long index) throws IOException {
        this.reader = reader;
        this.index = index;
        this.parse();
    }

    private void parse() throws IOException {
        this.reader.setPointerIndex(this.index);
        this.setSizeOfInfo(this.reader.readNextInt());
        this.setFlags1(this.reader.readNextInt());
        this.setProcessId(this.reader.readNextInt());
        this.setProcessCreateTime(this.reader.readNextInt());
        this.setProcessUserTime(this.reader.readNextInt());
        this.setProcessKernelTime(this.reader.readNextInt());
        boolean bl = this.format2 = (long)this.sizeOfInfo > this.reader.getPointerIndex() - this.index;
        if (this.format2) {
            this.setProcessorMaxMhz(this.reader.readNextInt());
            this.setProcessorCurrentMhz(this.reader.readNextInt());
            this.setProcessorMhzLimit(this.reader.readNextInt());
            this.setProcessorMaxIdleState(this.reader.readNextInt());
            this.setProcessorCurrentIdleState(this.reader.readNextInt());
        }
        boolean bl2 = this.format3 = (long)this.sizeOfInfo > this.reader.getPointerIndex() - this.index;
        if (this.format3) {
            this.setProcessIntegrityLevel(this.reader.readNextInt());
            this.setProcessExecuteFlags(this.reader.readNextInt());
            this.setProcessorMhzLimit(this.reader.readNextInt());
            this.setProtectedProcess(this.reader.readNextInt());
            this.setTimeZoneId(this.reader.readNextInt());
            this.setBias(this.reader.readNextInt());
            this.setStandardName(this.reader.readNextUnicodeString());
            this.reader.readNextLong();
            this.reader.readNextLong();
            this.setStandardBias(this.reader.readNextInt());
            this.setDaylightName(this.reader.readNextUnicodeString());
            this.reader.readNextLong();
            this.reader.readNextLong();
            this.setTimeZoneId(this.reader.readNextInt());
            this.setDaylightBias(this.reader.readNextInt());
        }
        boolean bl3 = this.format4 = (long)this.sizeOfInfo > this.reader.getPointerIndex() - this.index;
        if (this.format4) {
            this.setProtectedProcess(this.reader.readNextInt());
            this.setTimeZoneId(this.reader.readNextInt());
        }
    }

    public DataType toDataType() throws DuplicateNameException {
        StructureDataType struct = new StructureDataType(NAME, 0);
        struct.add(DWORD, 4, "SizeOfInfo", null);
        struct.add(DWORD, 4, "Flags1", null);
        struct.add(DWORD, 4, "ProcessId", null);
        struct.add(DWORD, 4, "ProcessCreateTime", null);
        struct.add(DWORD, 4, "ProcessUserTime", null);
        struct.add(DWORD, 4, "ProcessKernelTime", null);
        if (this.format2) {
            struct.add(DWORD, 4, "ProcessorMaxMhz", null);
            struct.add(DWORD, 4, "ProcessorCurrentMhz", null);
            struct.add(DWORD, 4, "ProcessorMhzLimit", null);
            struct.add(DWORD, 4, "ProcessorMaxIdleState", null);
            struct.add(DWORD, 4, "ProcessorCurrentIdleState", null);
        }
        if (this.format3) {
            struct.add(DWORD, 4, "ProcessIntegrityLevel", null);
            struct.add(DWORD, 4, "ProcessExecuteFlags", null);
            struct.add(DWORD, 4, "ProtectedProcess", null);
            struct.add(DWORD, 4, "TimeZoneId", null);
            StructureDataType s00 = new StructureDataType("SYSTEM_TIME", 0);
            s00.add(WORD, 2, "Year", null);
            s00.add(WORD, 2, "Month", null);
            s00.add(WORD, 2, "DayOfWeek", null);
            s00.add(WORD, 2, "Day", null);
            s00.add(WORD, 2, "Hour", null);
            s00.add(WORD, 2, "Minute", null);
            s00.add(WORD, 2, "Second", null);
            s00.add(WORD, 2, "Milliseconds", null);
            StructureDataType s0 = new StructureDataType("TIME_ZONE_INFORMATION", 0);
            s0.add(DWORD, 4, "Bias", null);
            s0.add(UTF16, 64, "StandardName", null);
            s0.add((DataType)s00, s00.getLength(), "StandardDate", null);
            s0.add(DWORD, 4, "StandardBias", null);
            s0.add(UTF16, 64, "DaylightName", null);
            s0.add((DataType)s00, s00.getLength(), "DaylightDate", null);
            s0.add(DWORD, 4, "DaylightBias", null);
            struct.add((DataType)s0, s0.getLength(), "TimeZone", null);
        }
        if (this.format4) {
            struct.add(UTF16, 256, "BuildString", null);
            struct.add(UTF16, 40, "DbgBldStr", null);
        }
        struct.setCategoryPath(new CategoryPath("/MDMP"));
        return struct;
    }

    public int getSizeOfInfo() {
        return this.sizeOfInfo;
    }

    public void setSizeOfInfo(int sizeOfInfo) {
        this.sizeOfInfo = sizeOfInfo;
    }

    public int getFlags1() {
        return this.flags1;
    }

    public void setFlags1(int flags1) {
        this.flags1 = flags1;
    }

    public int getProcessId() {
        return this.processId;
    }

    public void setProcessId(int processId) {
        this.processId = processId;
    }

    public int getProcessCreateTime() {
        return this.processCreateTime;
    }

    public void setProcessCreateTime(int processCreateTime) {
        this.processCreateTime = processCreateTime;
    }

    public int getProcessUserTime() {
        return this.processUserTime;
    }

    public void setProcessUserTime(int processUserTime) {
        this.processUserTime = processUserTime;
    }

    public int getProcessKernelTime() {
        return this.processKernelTime;
    }

    public void setProcessKernelTime(int processKernelTime) {
        this.processKernelTime = processKernelTime;
    }

    public int getProcessorMaxMhz() {
        return this.processorMaxMhz;
    }

    public void setProcessorMaxMhz(int processorMaxMhz) {
        this.processorMaxMhz = processorMaxMhz;
    }

    public int getProcessorCurrentMhz() {
        return this.processorCurrentMhz;
    }

    public void setProcessorCurrentMhz(int processorCurrentMhz) {
        this.processorCurrentMhz = processorCurrentMhz;
    }

    public int getProcessorMhzLimit() {
        return this.processorMhzLimit;
    }

    public void setProcessorMhzLimit(int processorMhzLimit) {
        this.processorMhzLimit = processorMhzLimit;
    }

    public int getProcessorMaxIdleState() {
        return this.processorMaxIdleState;
    }

    public void setProcessorMaxIdleState(int processorMaxIdleState) {
        this.processorMaxIdleState = processorMaxIdleState;
    }

    public int getProcessorCurrentIdleState() {
        return this.processorCurrentIdleState;
    }

    public void setProcessorCurrentIdleState(int processorCurrentIdleState) {
        this.processorCurrentIdleState = processorCurrentIdleState;
    }

    public int getProcessIntegrityLevel() {
        return this.processIntegrityLevel;
    }

    public void setProcessIntegrityLevel(int processIntegrityLevel) {
        this.processIntegrityLevel = processIntegrityLevel;
    }

    public int getProcessExecuteFlags() {
        return this.processExecuteFlags;
    }

    public void setProcessExecuteFlags(int processExecuteFlags) {
        this.processExecuteFlags = processExecuteFlags;
    }

    public int getProtectedProcess() {
        return this.protectedProcess;
    }

    public void setProtectedProcess(int protectedProcess) {
        this.protectedProcess = protectedProcess;
    }

    public int getTimeZoneId() {
        return this.timeZoneId;
    }

    public void setTimeZoneId(int timeZoneId) {
        this.timeZoneId = timeZoneId;
    }

    public int getBias() {
        return this.bias;
    }

    public void setBias(int bias) {
        this.bias = bias;
    }

    public String getStandardName() {
        return this.standardName;
    }

    public void setStandardName(String standardName) {
        this.standardName = standardName;
    }

    public int getStandardBias() {
        return this.standardBias;
    }

    public void setStandardBias(int standardBias) {
        this.standardBias = standardBias;
    }

    public String getDaylightName() {
        return this.daylightName;
    }

    public void setDaylightName(String daylightName) {
        this.daylightName = daylightName;
    }

    public int getDaylightBias() {
        return this.daylightBias;
    }

    public void setDaylightBias(int daylightBias) {
        this.daylightBias = daylightBias;
    }

    public String getBuildString() {
        return this.buildString;
    }

    public void setBuildString(String buildString) {
        this.buildString = buildString;
    }

    public String getDbgBuildStr() {
        return this.dbgBuildStr;
    }

    public void setDbgBuildStr(String dbgBuildStr) {
        this.dbgBuildStr = dbgBuildStr;
    }
}

