/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.dump.pagedump;

import ghidra.app.util.bin.StructConverter;
import ghidra.file.formats.dump.DumpFileReader;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import java.io.IOException;

public class LoadedDriver
implements StructConverter {
    public static final String NAME = "_KLDR_DATA_TABLE_ENTRY";
    private int nameOffset;
    private long dllBase;
    private long entryPoint;
    private long sizeOfImage;
    private long fullDllName;
    private long baseDllName;
    private int flags;
    private short loadCount;
    private int checkSum;
    private long buildFileHash;
    private DumpFileReader reader;
    private long index;
    private int psz;
    private boolean is32Bit;

    LoadedDriver(DumpFileReader reader, long index) throws IOException {
        this.reader = reader;
        this.index = index;
        this.psz = reader.getPointerSize();
        this.is32Bit = this.psz == 4;
        this.parse();
    }

    private void parse() throws IOException {
        this.reader.setPointerIndex(this.index);
        this.setNameOffset(this.reader.readNextInt());
        int res0len = this.is32Bit ? 24 : 52;
        this.reader.readNextAsciiString(res0len);
        this.setDllBase(this.reader.readNextPointer());
        this.setEntryPoint(this.reader.readNextPointer());
        this.setSizeOfImage(this.reader.readNextPointer());
        this.reader.readNextPointer();
        this.setFullDllName(this.reader.readNextPointer());
        this.reader.readNextPointer();
        this.setBaseDllName(this.reader.readNextPointer());
        this.setFlags(this.reader.readNextInt());
        this.setLoadCount(this.reader.readNextShort());
        this.reader.readNextShort();
        this.reader.readNextPointer();
        this.setCheckSum(this.reader.readNextInt());
        this.reader.readNextInt();
        this.setBuildFileHash(this.reader.readNextInt());
        this.reader.readNextInt();
    }

    public DataType toDataType() {
        StructureDataType struct = new StructureDataType(NAME, 0);
        struct.add(DWORD, 4, "NameOffset", null);
        struct.add(DWORD, 4, "", null);
        struct.add(POINTER, this.psz, "InLoadOrderLinks.Flink", null);
        struct.add(POINTER, this.psz, "InLoadOrderLinks.Blink", null);
        struct.add(POINTER, this.psz, "ExceptionTable", null);
        struct.add(POINTER, this.psz, "ExceptionTableSize", null);
        struct.add(POINTER, this.psz, "GpValue", null);
        struct.add(POINTER, this.psz, "NonPagedDebugInfo", null);
        struct.add(POINTER, this.psz, "DllBase", null);
        struct.add(POINTER, this.psz, "EntryPoint", null);
        struct.add(this.is32Bit ? DWORD : QWORD, this.psz, "SizeOfImage", null);
        struct.add(this.is32Bit ? DWORD : QWORD, this.psz, "", null);
        struct.add(POINTER, this.psz, "FullDllName", null);
        struct.add(this.is32Bit ? DWORD : QWORD, this.psz, "", null);
        struct.add(POINTER, this.psz, "BaseDllName", null);
        struct.add(DWORD, 4, "Flags", null);
        struct.add(WORD, 2, "LoadCount", null);
        struct.add(WORD, 2, "", null);
        struct.add(POINTER, this.psz, "SectionPointer", null);
        struct.add(this.is32Bit ? DWORD : QWORD, this.psz, "CheckSum", null);
        struct.add(this.is32Bit ? DWORD : QWORD, this.psz, "BuildFileHash", null);
        struct.setCategoryPath(new CategoryPath("/PDMP"));
        return struct;
    }

    public int getNameOffset() {
        return this.nameOffset;
    }

    public void setNameOffset(int nameOffset) {
        this.nameOffset = nameOffset;
    }

    public long getDllBase() {
        return this.dllBase;
    }

    public void setDllBase(long dllBase) {
        this.dllBase = dllBase;
    }

    public long getEntryPoint() {
        return this.entryPoint;
    }

    public void setEntryPoint(long entryPoint) {
        this.entryPoint = entryPoint;
    }

    public long getSizeOfImage() {
        return this.sizeOfImage;
    }

    public void setSizeOfImage(long sizeOfImage) {
        this.sizeOfImage = sizeOfImage;
    }

    public long getBuildFileHash() {
        return this.buildFileHash;
    }

    public void setBuildFileHash(long buildFileHash) {
        this.buildFileHash = buildFileHash;
    }

    public long getFullDllName() {
        return this.fullDllName;
    }

    public void setFullDllName(long fullDllName) {
        this.fullDllName = fullDllName;
    }

    public long getBaseDllName() {
        return this.baseDllName;
    }

    public void setBaseDllName(long baseDllName) {
        this.baseDllName = baseDllName;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public short getLoadCount() {
        return this.loadCount;
    }

    public void setLoadCount(short loadCount) {
        this.loadCount = loadCount;
    }

    public int getCheckSum() {
        return this.checkSum;
    }

    public void setCheckSum(int checkSum) {
        this.checkSum = checkSum;
    }
}

