/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.ext4;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.StructConverter;
import ghidra.file.formats.ext4.Ext4FileSystem;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class Ext4SuperBlock
implements StructConverter {
    private int s_inodes_count;
    private int s_blocks_count_lo;
    private int s_r_blocks_count_lo;
    private int s_free_blocks_count_lo;
    private int s_free_inodes_count;
    private int s_first_data_block;
    private int s_log_block_size;
    private int s_log_cluster_size;
    private int s_blocks_per_group;
    private int s_clusters_per_group;
    private int s_inodes_per_group;
    private int s_mtime;
    private int s_wtime;
    private short s_mnt_count;
    private short s_max_mnt_count;
    private short s_magic;
    private short s_state;
    private short s_errors;
    private short s_minor_rev_level;
    private int s_lastcheck;
    private int s_checkinterval;
    private int s_creator_os;
    private int s_rev_level;
    private short s_def_resuid;
    private short s_def_resgid;
    private int s_first_ino;
    private short s_inode_size;
    private short s_block_group_nr;
    private int s_feature_compat;
    private int s_feature_incompat;
    private int s_feature_ro_compat;
    private byte[] s_uuid;
    private byte[] s_volume_name;
    private byte[] s_last_mounted;
    private int s_algorithm_usage_bitmap;
    private byte s_prealloc_blocks;
    private byte s_prealloc_dir_blocks;
    private short s_reserved_gdt_blocks;
    private byte[] s_journal_uuid;
    private int s_journal_inum;
    private int s_journal_dev;
    private int s_last_orphan;
    private int[] s_hash_seed;
    private byte s_def_hash_version;
    private byte s_jnl_backup_type;
    private short s_desc_size;
    private int s_default_mount_opts;
    private int s_first_meta_bg;
    private int s_mkfs_time;
    private int[] s_jnl_blocks;
    private int s_blocks_count_hi;
    private int s_r_blocks_count_hi;
    private int s_free_blocks_count_hi;
    private short s_min_extra_isize;
    private short s_want_extra_isize;
    private int s_flags;
    private short s_raid_stride;
    private short s_mmp_interval;
    private long s_mmp_block;
    private int s_raid_stripe_width;
    private byte s_log_groups_per_flex;
    private byte s_checksum_type;
    private short s_reserved_pad;
    private long s_kbytes_written;
    private int s_snapshot_inum;
    private int s_snapshot_id;
    private long s_snapshot_r_blocks_count;
    private int s_snapshot_list;
    private int s_error_count;
    private int s_first_error_time;
    private int s_first_error_ino;
    private long s_first_error_block;
    private byte[] s_first_error_func;
    private int s_first_error_line;
    private int s_last_error_time;
    private int s_last_error_ino;
    private int s_last_error_line;
    private long s_last_error_block;
    private byte[] s_last_error_func;
    private byte[] s_mount_opts;
    private int s_usr_quora_inum;
    private int s_grp_quota_inum;
    private int s_overhead_blocks;
    private int[] s_backup_blocks;
    private byte[] s_encrypt_algos;
    private byte[] s_encrypt_pw_salt;
    private int s_lpf_ino;
    private int s_prj_quota_inum;
    private int s_checksum_seed;
    private int[] s_reserved;
    private int s_checksum;

    public Ext4SuperBlock(ByteProvider provider) throws IOException {
        this(new BinaryReader(provider, true));
    }

    public Ext4SuperBlock(BinaryReader reader) throws IOException {
        this.s_inodes_count = reader.readNextInt();
        this.s_blocks_count_lo = reader.readNextInt();
        this.s_r_blocks_count_lo = reader.readNextInt();
        this.s_free_blocks_count_lo = reader.readNextInt();
        this.s_free_inodes_count = reader.readNextInt();
        this.s_first_data_block = reader.readNextInt();
        this.s_log_block_size = reader.readNextInt();
        this.s_log_cluster_size = reader.readNextInt();
        this.s_blocks_per_group = reader.readNextInt();
        this.s_clusters_per_group = reader.readNextInt();
        this.s_inodes_per_group = reader.readNextInt();
        this.s_mtime = reader.readNextInt();
        this.s_wtime = reader.readNextInt();
        this.s_mnt_count = reader.readNextShort();
        this.s_max_mnt_count = reader.readNextShort();
        this.s_magic = reader.readNextShort();
        this.s_state = reader.readNextShort();
        this.s_errors = reader.readNextShort();
        this.s_minor_rev_level = reader.readNextShort();
        this.s_lastcheck = reader.readNextInt();
        this.s_checkinterval = reader.readNextInt();
        this.s_creator_os = reader.readNextInt();
        this.s_rev_level = reader.readNextInt();
        this.s_def_resuid = reader.readNextShort();
        this.s_def_resgid = reader.readNextShort();
        this.s_first_ino = reader.readNextInt();
        this.s_inode_size = reader.readNextShort();
        this.s_block_group_nr = reader.readNextShort();
        this.s_feature_compat = reader.readNextInt();
        this.s_feature_incompat = reader.readNextInt();
        this.s_feature_ro_compat = reader.readNextInt();
        this.s_uuid = reader.readNextByteArray(16);
        this.s_volume_name = reader.readNextByteArray(16);
        this.s_last_mounted = reader.readNextByteArray(64);
        this.s_algorithm_usage_bitmap = reader.readNextInt();
        this.s_prealloc_blocks = reader.readNextByte();
        this.s_prealloc_dir_blocks = reader.readNextByte();
        this.s_reserved_gdt_blocks = reader.readNextShort();
        this.s_journal_uuid = reader.readNextByteArray(16);
        this.s_journal_inum = reader.readNextInt();
        this.s_journal_dev = reader.readNextInt();
        this.s_last_orphan = reader.readNextInt();
        this.s_hash_seed = reader.readNextIntArray(4);
        this.s_def_hash_version = reader.readNextByte();
        this.s_jnl_backup_type = reader.readNextByte();
        this.s_desc_size = reader.readNextShort();
        this.s_default_mount_opts = reader.readNextInt();
        this.s_first_meta_bg = reader.readNextInt();
        this.s_mkfs_time = reader.readNextInt();
        this.s_jnl_blocks = reader.readNextIntArray(17);
        this.s_blocks_count_hi = reader.readNextInt();
        this.s_r_blocks_count_hi = reader.readNextInt();
        this.s_free_blocks_count_hi = reader.readNextInt();
        this.s_min_extra_isize = reader.readNextShort();
        this.s_want_extra_isize = reader.readNextShort();
        this.s_flags = reader.readNextInt();
        this.s_raid_stride = reader.readNextShort();
        this.s_mmp_interval = reader.readNextShort();
        this.s_mmp_block = reader.readNextLong();
        this.s_raid_stripe_width = reader.readNextInt();
        this.s_log_groups_per_flex = reader.readNextByte();
        this.s_checksum_type = reader.readNextByte();
        this.s_reserved_pad = reader.readNextShort();
        this.s_kbytes_written = reader.readNextLong();
        this.s_snapshot_inum = reader.readNextInt();
        this.s_snapshot_id = reader.readNextInt();
        this.s_snapshot_r_blocks_count = reader.readNextLong();
        this.s_snapshot_list = reader.readNextInt();
        this.s_error_count = reader.readNextInt();
        this.s_first_error_time = reader.readNextInt();
        this.s_first_error_ino = reader.readNextInt();
        this.s_first_error_block = reader.readNextLong();
        this.s_first_error_func = reader.readNextByteArray(32);
        this.s_first_error_line = reader.readNextInt();
        this.s_last_error_time = reader.readNextInt();
        this.s_last_error_ino = reader.readNextInt();
        this.s_last_error_line = reader.readNextInt();
        this.s_last_error_block = reader.readNextLong();
        this.s_last_error_func = reader.readNextByteArray(32);
        this.s_mount_opts = reader.readNextByteArray(64);
        this.s_usr_quora_inum = reader.readNextInt();
        this.s_grp_quota_inum = reader.readNextInt();
        this.s_overhead_blocks = reader.readNextInt();
        this.s_backup_blocks = reader.readNextIntArray(2);
        this.s_encrypt_algos = reader.readNextByteArray(4);
        this.s_encrypt_pw_salt = reader.readNextByteArray(16);
        this.s_lpf_ino = reader.readNextInt();
        this.s_prj_quota_inum = reader.readNextInt();
        this.s_checksum_seed = reader.readNextInt();
        this.s_reserved = reader.readNextIntArray(98);
        this.s_checksum = reader.readNextInt();
    }

    public int getS_inodes_count() {
        return this.s_inodes_count;
    }

    public int getS_blocks_count_lo() {
        return this.s_blocks_count_lo;
    }

    public long getS_blocks_count() {
        return (long)this.s_blocks_count_hi << 32 | Integer.toUnsignedLong(this.s_blocks_count_lo);
    }

    public int getS_r_blocks_count_lo() {
        return this.s_r_blocks_count_lo;
    }

    public int getS_free_blocks_count_lo() {
        return this.s_free_blocks_count_lo;
    }

    public int getS_free_inodes_count() {
        return this.s_free_inodes_count;
    }

    public int getS_first_data_block() {
        return this.s_first_data_block;
    }

    public int getS_log_block_size() {
        return this.s_log_block_size;
    }

    public int getS_log_cluster_size() {
        return this.s_log_cluster_size;
    }

    public int getS_blocks_per_group() {
        return this.s_blocks_per_group;
    }

    public int getS_clusters_per_group() {
        return this.s_clusters_per_group;
    }

    public int getS_inodes_per_group() {
        return this.s_inodes_per_group;
    }

    public int getS_mtime() {
        return this.s_mtime;
    }

    public int getS_wtime() {
        return this.s_wtime;
    }

    public short getS_mnt_count() {
        return this.s_mnt_count;
    }

    public short getS_max_mnt_count() {
        return this.s_max_mnt_count;
    }

    public short getS_magic() {
        return this.s_magic;
    }

    public short getS_state() {
        return this.s_state;
    }

    public short getS_errors() {
        return this.s_errors;
    }

    public short getS_minor_rev_level() {
        return this.s_minor_rev_level;
    }

    public int getS_lastcheck() {
        return this.s_lastcheck;
    }

    public int getS_checkinterval() {
        return this.s_checkinterval;
    }

    public int getS_creator_os() {
        return this.s_creator_os;
    }

    public int getS_rev_level() {
        return this.s_rev_level;
    }

    public short getS_def_resuid() {
        return this.s_def_resuid;
    }

    public short getS_def_resgid() {
        return this.s_def_resgid;
    }

    public int getS_first_ino() {
        return this.s_first_ino;
    }

    public short getS_inode_size() {
        return this.s_inode_size;
    }

    public short getS_block_group_nr() {
        return this.s_block_group_nr;
    }

    public int getS_feature_compat() {
        return this.s_feature_compat;
    }

    public int getS_feature_incompat() {
        return this.s_feature_incompat;
    }

    public int getS_feature_ro_compat() {
        return this.s_feature_ro_compat;
    }

    public byte[] getS_uuid() {
        return this.s_uuid;
    }

    public byte[] getS_volume_name() {
        return this.s_volume_name;
    }

    public String getVolumeName() {
        int i;
        for (i = 0; i < this.s_volume_name.length && this.s_volume_name[i] != 0; ++i) {
        }
        return new String(this.s_volume_name, 0, i, Ext4FileSystem.EXT4_DEFAULT_CHARSET);
    }

    public byte[] getS_last_mounted() {
        return this.s_last_mounted;
    }

    public int getS_algorithm_usage_bitmap() {
        return this.s_algorithm_usage_bitmap;
    }

    public byte getS_prealloc_blocks() {
        return this.s_prealloc_blocks;
    }

    public byte getS_prealloc_dir_blocks() {
        return this.s_prealloc_dir_blocks;
    }

    public short getS_reserved_gdt_blocks() {
        return this.s_reserved_gdt_blocks;
    }

    public byte[] getS_journal_uuid() {
        return this.s_journal_uuid;
    }

    public int getS_journal_inum() {
        return this.s_journal_inum;
    }

    public int getS_journal_dev() {
        return this.s_journal_dev;
    }

    public int getS_last_orphan() {
        return this.s_last_orphan;
    }

    public int[] getS_hash_seed() {
        return this.s_hash_seed;
    }

    public byte getS_def_hash_version() {
        return this.s_def_hash_version;
    }

    public byte getS_jnl_backup_type() {
        return this.s_jnl_backup_type;
    }

    public short getS_desc_size() {
        return this.s_desc_size;
    }

    public int getS_default_mount_opts() {
        return this.s_default_mount_opts;
    }

    public int getS_first_meta_bg() {
        return this.s_first_meta_bg;
    }

    public int getS_mkfs_time() {
        return this.s_mkfs_time;
    }

    public int[] getS_jnl_blocks() {
        return this.s_jnl_blocks;
    }

    public int getS_blocks_count_hi() {
        return this.s_blocks_count_hi;
    }

    public int getS_r_blocks_count_hi() {
        return this.s_r_blocks_count_hi;
    }

    public int getS_free_blocks_count_hi() {
        return this.s_free_blocks_count_hi;
    }

    public short getS_min_extra_isize() {
        return this.s_min_extra_isize;
    }

    public short getS_want_extra_isize() {
        return this.s_want_extra_isize;
    }

    public int getS_flags() {
        return this.s_flags;
    }

    public short getS_raid_stride() {
        return this.s_raid_stride;
    }

    public short getS_mmp_interval() {
        return this.s_mmp_interval;
    }

    public long getS_mmp_block() {
        return this.s_mmp_block;
    }

    public int getS_raid_stripe_width() {
        return this.s_raid_stripe_width;
    }

    public byte getS_log_groups_per_flex() {
        return this.s_log_groups_per_flex;
    }

    public byte getS_checksum_type() {
        return this.s_checksum_type;
    }

    public short getS_reserved_pad() {
        return this.s_reserved_pad;
    }

    public long getS_kbytes_written() {
        return this.s_kbytes_written;
    }

    public int getS_snapshot_inum() {
        return this.s_snapshot_inum;
    }

    public int getS_snapshot_id() {
        return this.s_snapshot_id;
    }

    public long getS_snapshot_r_blocks_count() {
        return this.s_snapshot_r_blocks_count;
    }

    public int getS_snapshot_list() {
        return this.s_snapshot_list;
    }

    public int getS_error_count() {
        return this.s_error_count;
    }

    public int getS_first_error_time() {
        return this.s_first_error_time;
    }

    public int getS_first_error_ino() {
        return this.s_first_error_ino;
    }

    public long getS_first_error_block() {
        return this.s_first_error_block;
    }

    public byte[] getS_first_error_func() {
        return this.s_first_error_func;
    }

    public int getS_first_error_line() {
        return this.s_first_error_line;
    }

    public int getS_last_error_time() {
        return this.s_last_error_time;
    }

    public int getS_Last_error_ino() {
        return this.s_last_error_ino;
    }

    public int getS_last_error_line() {
        return this.s_last_error_line;
    }

    public long getS_last_error_block() {
        return this.s_last_error_block;
    }

    public byte[] getS_last_error_func() {
        return this.s_last_error_func;
    }

    public byte[] getS_mount_opts() {
        return this.s_mount_opts;
    }

    public int getS_usr_quora_inum() {
        return this.s_usr_quora_inum;
    }

    public int getS_grp_quota_inum() {
        return this.s_grp_quota_inum;
    }

    public int getS_overhead_blocks() {
        return this.s_overhead_blocks;
    }

    public int[] getS_backup_blocks() {
        return this.s_backup_blocks;
    }

    public byte[] getS_encrypt_algos() {
        return this.s_encrypt_algos;
    }

    public byte[] getS_encrypt_pw_salt() {
        return this.s_encrypt_pw_salt;
    }

    public int getS_lpf_ino() {
        return this.s_lpf_ino;
    }

    public int getS_prj_quota_inum() {
        return this.s_prj_quota_inum;
    }

    public int getS_checksum_seed() {
        return this.s_checksum_seed;
    }

    public int[] getS_reserved() {
        return this.s_reserved;
    }

    public int getS_checksum() {
        return this.s_checksum;
    }

    public boolean isValid() {
        return Short.toUnsignedInt(this.s_magic) == 61267;
    }

    public boolean is64Bit() {
        return this.s_desc_size > 32 && (this.s_feature_incompat & 0x80) != 0;
    }

    public boolean isInlineData() {
        return (this.s_feature_incompat & 0x8000) != 0;
    }

    public boolean isDirEntry2() {
        return (this.s_feature_incompat & 2) != 0;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType structure = new StructureDataType("ext4_super_block", 0);
        structure.add(DWORD, "s_inodes_count", null);
        structure.add(DWORD, "s_blocks_count_lo", null);
        structure.add(DWORD, "s_r_blocks_count_lo", null);
        structure.add(DWORD, "s_free_blocks_count_lo", null);
        structure.add(DWORD, "s_free_inodes_count", null);
        structure.add(DWORD, "s_first_data_block", null);
        structure.add(DWORD, "s_log_block_size", null);
        structure.add(DWORD, "s_log_cluster_size", null);
        structure.add(DWORD, "s_blocks_per_group", null);
        structure.add(DWORD, "s_clusters_per_group", null);
        structure.add(DWORD, "s_inodes_per_group", null);
        structure.add(DWORD, "s_mtime", null);
        structure.add(DWORD, "s_wtime", null);
        structure.add(WORD, "s_mnt_count", null);
        structure.add(WORD, "s_max_mnt_count", null);
        structure.add(WORD, "s_magic", null);
        structure.add(WORD, "s_state", null);
        structure.add(WORD, "s_errors", null);
        structure.add(WORD, "s_minor_rev_level", null);
        structure.add(DWORD, "s_lastcheck", null);
        structure.add(DWORD, "s_checkinterval", null);
        structure.add(DWORD, "s_creator_os", null);
        structure.add(DWORD, "s_rev_level", null);
        structure.add(WORD, "s_def_resuid", null);
        structure.add(WORD, "s_def_resgid", null);
        structure.add(DWORD, "s_first_ino", null);
        structure.add(WORD, "s_inode_size", null);
        structure.add(WORD, "s_block_group_nr", null);
        structure.add(DWORD, "s_feature_compat", null);
        structure.add(DWORD, "s_feature_incompat", null);
        structure.add(DWORD, "s_feature_ro_compat", null);
        structure.add((DataType)new ArrayDataType(BYTE, 16, BYTE.getLength()), "s_uuid", null);
        structure.add((DataType)new ArrayDataType(BYTE, 16, BYTE.getLength()), "s_volume_name", null);
        structure.add((DataType)new ArrayDataType(BYTE, 64, BYTE.getLength()), "s_last_mounted", null);
        structure.add(DWORD, "s_algorithm_usage_bitmap", null);
        structure.add(BYTE, "s_prealloc_blocks", null);
        structure.add(BYTE, "s_prealloc_dir_blocks", null);
        structure.add(WORD, "s_reserved_gdt_blocks", null);
        structure.add((DataType)new ArrayDataType(BYTE, 16, BYTE.getLength()), "s_journal_uuid", null);
        structure.add(DWORD, "s_journal_inum", null);
        structure.add(DWORD, "s_journal_dev", null);
        structure.add(DWORD, "s_last_orphan", null);
        structure.add((DataType)new ArrayDataType(DWORD, 4, DWORD.getLength()), "s_hash_seed", null);
        structure.add(BYTE, "s_def_hash_version", null);
        structure.add(BYTE, "s_jnl_backup_type", null);
        structure.add(WORD, "s_desc_size", null);
        structure.add(DWORD, "s_default_mount_opts", null);
        structure.add(DWORD, "s_first_meta_bg", null);
        structure.add(DWORD, "s_mkfs_time", null);
        structure.add((DataType)new ArrayDataType(DWORD, 17, DWORD.getLength()), "s_jnl_blocks", null);
        structure.add(DWORD, "s_blocks_count_hi", null);
        structure.add(DWORD, "s_r_blocks_count_hi", null);
        structure.add(DWORD, "s_free_blocks_count_hi", null);
        structure.add(WORD, "s_min_extra_isize", null);
        structure.add(WORD, "s_want_extra_isize", null);
        structure.add(DWORD, "s_flags", null);
        structure.add(WORD, "s_raid_stride", null);
        structure.add(WORD, "s_mmp_interval", null);
        structure.add(QWORD, "s_mmp_block", null);
        structure.add(DWORD, "s_raid_stripe_width", null);
        structure.add(BYTE, "s_log_groups_per_flex", null);
        structure.add(BYTE, "s_checksum_type", null);
        structure.add(WORD, "s_reserved_pad", null);
        structure.add(QWORD, "s_kbytes_written", null);
        structure.add(DWORD, "s_snapshot_inum", null);
        structure.add(DWORD, "s_snapshot_id", null);
        structure.add(QWORD, "s_snapshot_r_blocks_count", null);
        structure.add(DWORD, "s_snapshot_list", null);
        structure.add(DWORD, "s_error_count", null);
        structure.add(DWORD, "s_first_error_time", null);
        structure.add(DWORD, "s_first_error_ino", null);
        structure.add(QWORD, "s_first_error_block", null);
        structure.add((DataType)new ArrayDataType(BYTE, 32, BYTE.getLength()), "s_first_error_func", null);
        structure.add(DWORD, "s_first_error_line", null);
        structure.add(DWORD, "s_last_error_time", null);
        structure.add(DWORD, "s_last_error_ino", null);
        structure.add(DWORD, "s_last_error_line", null);
        structure.add(QWORD, "s_last_error_block", null);
        structure.add((DataType)new ArrayDataType(BYTE, 32, BYTE.getLength()), "s_last_error_func", null);
        structure.add((DataType)new ArrayDataType(BYTE, 64, BYTE.getLength()), "s_mount_opts", null);
        structure.add(DWORD, "s_usr_quora_inum", null);
        structure.add(DWORD, "s_grp_quota_inum", null);
        structure.add(DWORD, "s_overhead_blocks", null);
        structure.add((DataType)new ArrayDataType(DWORD, 2, DWORD.getLength()), "s_backup_blocks", null);
        structure.add((DataType)new ArrayDataType(BYTE, 4, BYTE.getLength()), "s_encrypt_algos", null);
        structure.add((DataType)new ArrayDataType(BYTE, 16, BYTE.getLength()), "s_encrypt_pw_salt", null);
        structure.add(DWORD, "s_lpf_ino", null);
        structure.add(DWORD, "s_prj_quota_inum", null);
        structure.add(DWORD, "s_checksum_seed", null);
        structure.add((DataType)new ArrayDataType(DWORD, 98, DWORD.getLength()), "s_reserved", null);
        structure.add(DWORD, "s_checksum", null);
        return structure;
    }
}

