/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.layout.algorithms.eiglsperger;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jgrapht.Graph;
import org.jungrapht.visualization.layout.algorithms.eiglsperger.PVertex;
import org.jungrapht.visualization.layout.algorithms.eiglsperger.QVertex;
import org.jungrapht.visualization.layout.algorithms.eiglsperger.Segment;
import org.jungrapht.visualization.layout.algorithms.eiglsperger.SegmentEdge;
import org.jungrapht.visualization.layout.algorithms.eiglsperger.SyntheticLV;
import org.jungrapht.visualization.layout.algorithms.sugiyama.ArticulatedEdge;
import org.jungrapht.visualization.layout.algorithms.sugiyama.LE;
import org.jungrapht.visualization.layout.algorithms.sugiyama.LV;
import org.jungrapht.visualization.layout.algorithms.sugiyama.SyntheticLE;
import org.jungrapht.visualization.layout.model.Point;
import org.jungrapht.visualization.layout.util.synthetics.Synthetic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Synthetics<V, E> {
    private static final Logger log = LoggerFactory.getLogger(Synthetics.class);
    protected final Graph<LV<V>, LE<V, E>> dag;

    public Synthetics(Graph<LV<V>, LE<V, E>> dag) {
        this.dag = dag;
    }

    public LV<V>[][] createVirtualVerticesAndEdges(List<LE<V, E>> edges, List<List<LV<V>>> layers) {
        for (int i = 0; i < layers.size() - 1; ++i) {
            List<LV<V>> currentLayer = layers.get(i);
            for (LV v : currentLayer) {
                if (v instanceof PVertex) continue;
                ArrayList outgoingMulti = new ArrayList();
                edges.stream().filter(e -> !(e instanceof SegmentEdge)).filter(e -> e.getSource().equals(v)).filter(e -> Math.abs(e.getTarget().getRank() - v.getRank()) > 1).forEach(outgoingMulti::add);
                for (LE edge : outgoingMulti) {
                    if (edge.getTarget().getRank() - edge.getSource().getRank() == 2) {
                        int syntheticVertexRank = edge.getSource().getRank() + 1;
                        SyntheticLV syntheticLV = SyntheticLV.of(edge.getSource(), edge.getTarget());
                        syntheticLV.setRank(syntheticVertexRank);
                        this.replaceEdgeWithSyntheticVertex(edges, edge, syntheticLV);
                        layers.get(syntheticVertexRank).add(syntheticLV);
                        this.updateIndices(layers.get(syntheticVertexRank));
                    } else {
                        PVertex pVertex = PVertex.of();
                        QVertex qVertex = QVertex.of();
                        int pVertexRank = edge.getSource().getRank() + 1;
                        int qVertexRank = edge.getTarget().getRank() - 1;
                        pVertex.setRank(pVertexRank);
                        qVertex.setRank(qVertexRank);
                        pVertex.setIndex(layers.get(pVertexRank).size());
                        qVertex.setIndex(layers.get(qVertexRank).size());
                        this.replaceEdgeWithSegment(edges, edge, pVertex, qVertex);
                        layers.get(pVertexRank).add(pVertex);
                        layers.get(qVertexRank).add(qVertex);
                        this.updateIndices(layers.get(pVertexRank));
                        this.updateIndices(layers.get(qVertexRank));
                    }
                    edges.removeIf(edge::equals);
                }
            }
        }
        return this.convertToArrays(layers);
    }

    private LV<V>[][] convertToArrays(List<List<LV<V>>> layers) {
        LV[][] ranks = new LV[layers.size()][];
        for (int i = 0; i < layers.size(); ++i) {
            List<LV<V>> list = layers.get(i);
            ranks[i] = new LV[list.size()];
            for (int j = 0; j < list.size(); ++j) {
                ranks[i][j] = list.get(j);
            }
        }
        return ranks;
    }

    private void updateIndices(List<LV<V>> layer) {
        for (int i = 0; i < layer.size(); ++i) {
            LV<V> sugiyamaVertex = layer.get(i);
            sugiyamaVertex.setIndex(i);
        }
    }

    private void replaceEdgeWithSyntheticVertex(List<LE<V, E>> edges, LE<V, E> loser, SyntheticLV<V> syntheticLV) {
        SyntheticLE edgeToSyntheticVertex = SyntheticLE.of(loser, loser.getSource(), syntheticLV);
        SyntheticLE edgeFromSyntheticVertex = SyntheticLE.of(loser, syntheticLV, loser.getTarget());
        edges.add(edgeToSyntheticVertex);
        edges.add(edgeFromSyntheticVertex);
        this.dag.addVertex(syntheticLV);
        this.dag.addEdge(loser.getSource(), syntheticLV, (Object)edgeToSyntheticVertex);
        this.dag.addEdge(syntheticLV, loser.getTarget(), (Object)edgeFromSyntheticVertex);
        this.dag.removeEdge(loser);
        edges.remove(loser);
    }

    private Segment<V> replaceEdgeWithSegment(List<LE<V, E>> edges, LE<V, E> loser, PVertex<V> pVertex, QVertex<V> qVertex) {
        SyntheticLE edgeToPVertex = SyntheticLE.of(loser, loser.getSource(), pVertex);
        SegmentEdge segmentEdge = SegmentEdge.of(loser, pVertex, qVertex);
        Segment segment = Segment.of(pVertex, qVertex);
        pVertex.setSegment(segment);
        qVertex.setSegment(segment);
        SyntheticLE edgeFromQVertex = SyntheticLE.of(loser, qVertex, loser.getTarget());
        edges.add(edgeToPVertex);
        edges.add(segmentEdge);
        edges.add(edgeFromQVertex);
        this.dag.addVertex(pVertex);
        this.dag.addVertex(qVertex);
        this.dag.addEdge(loser.getSource(), pVertex, (Object)edgeToPVertex);
        this.dag.addEdge(pVertex, qVertex, (Object)segmentEdge);
        this.dag.addEdge(qVertex, loser.getTarget(), (Object)edgeFromQVertex);
        this.dag.removeEdge(loser);
        edges.remove(loser);
        return segment;
    }

    public List<ArticulatedEdge<V, E>> makeArticulatedEdges() {
        ArrayList<ArticulatedEdge<V, ArticulatedEdge>> articulatedEdges = new ArrayList<ArticulatedEdge<V, ArticulatedEdge>>();
        ArrayList<SyntheticLV> syntheticVerticesToRemove = new ArrayList<SyntheticLV>();
        ArrayList<SyntheticLE> syntheticEdgesToRemove = new ArrayList<SyntheticLE>();
        for (LE edge : this.dag.edgeSet()) {
            if (!(edge instanceof Synthetic)) continue;
            SyntheticLE syntheticEdge = (SyntheticLE)edge;
            ArrayList<SyntheticLV> syntheticVertices = new ArrayList<SyntheticLV>();
            LV source = (LV)this.dag.getEdgeSource((Object)edge);
            if (source instanceof Synthetic) continue;
            syntheticEdgesToRemove.add(syntheticEdge);
            LV target = (LV)this.dag.getEdgeTarget((Object)syntheticEdge);
            while (target instanceof Synthetic) {
                SyntheticLV syntheticTarget = (SyntheticLV)target;
                syntheticVerticesToRemove.add(syntheticTarget);
                syntheticVertices.add(syntheticTarget);
                LE outgoingEdge = (LE)this.dag.outgoingEdgesOf((Object)target).stream().findFirst().get();
                syntheticEdgesToRemove.add((SyntheticLE)outgoingEdge);
                target = (LV)this.dag.getEdgeTarget((Object)outgoingEdge);
            }
            ArticulatedEdge articulatedEdge = ArticulatedEdge.of(edge, source, target);
            syntheticVertices.forEach(articulatedEdge::addIntermediateVertex);
            syntheticVertices.forEach(v -> articulatedEdge.addIntermediatePoint(v.getPoint()));
            articulatedEdges.add(articulatedEdge);
        }
        syntheticEdgesToRemove.forEach(arg_0 -> this.dag.removeEdge(arg_0));
        syntheticVerticesToRemove.forEach(arg_0 -> this.dag.removeVertex(arg_0));
        articulatedEdges.forEach(e -> this.dag.addEdge(e.getSource(), e.getTarget(), e));
        return articulatedEdges;
    }

    public void alignArticulatedEdges() {
        HashSet<Point> allInnerPoints = new HashSet<Point>();
        for (LE edge : this.dag.edgeSet()) {
            if (!(edge instanceof SyntheticLE)) continue;
            SyntheticLE syntheticEdge = (SyntheticLE)edge;
            LV source = (LV)this.dag.getEdgeSource((Object)edge);
            if (source instanceof SyntheticLV) continue;
            LV target = (LV)this.dag.getEdgeTarget((Object)syntheticEdge);
            LinkedHashMap<SyntheticLV, Point> innerPoints = new LinkedHashMap<SyntheticLV, Point>();
            while (target instanceof SyntheticLV) {
                SyntheticLV syntheticTarget = (SyntheticLV)target;
                innerPoints.put(syntheticTarget, syntheticTarget.getPoint());
                LE outgoingEdge = (LE)this.dag.outgoingEdgesOf((Object)target).stream().findFirst().get();
                target = (LV)this.dag.getEdgeTarget((Object)outgoingEdge);
            }
            double avgx = innerPoints.values().stream().mapToDouble(p -> p.x).average().getAsDouble();
            if (log.isTraceEnabled()) {
                log.trace("points: {}, avgx: {}", innerPoints.values(), (Object)avgx);
            }
            boolean overlap = false;
            for (SyntheticLV v2 : innerPoints.keySet()) {
                Point newPoint = Point.of(avgx, v2.getPoint().y);
                overlap |= this.overlap(allInnerPoints, newPoint);
                allInnerPoints.add(newPoint);
                v2.setPoint(newPoint);
            }
            if (!overlap) continue;
            innerPoints.keySet().forEach(v -> v.setPoint(Point.of(v.getPoint().x + 20.0, v.getPoint().y)));
        }
    }

    private boolean overlap(Set<Point> allInnerPoints, Point newPoint) {
        Set xMatch = allInnerPoints.stream().filter(p -> p.x == newPoint.x).collect(Collectors.toSet());
        double yMin = 2.147483647E9;
        double yMax = 0.0;
        for (Point mp : xMatch) {
            yMin = Math.min(yMin, mp.y);
            yMax = Math.max(yMax, mp.y);
        }
        return yMin < newPoint.y && newPoint.y < yMax;
    }
}

