/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.layout.algorithms.sugiyama;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.jungrapht.visualization.layout.algorithms.sugiyama.AccumulatorTree;
import org.jungrapht.visualization.layout.algorithms.sugiyama.Comparators;
import org.jungrapht.visualization.layout.algorithms.sugiyama.LE;
import org.jungrapht.visualization.layout.algorithms.sugiyama.LV;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccumulatorTreeUtil {
    private static final Logger log = LoggerFactory.getLogger(AccumulatorTreeUtil.class);

    public static <V, E> int crossingCount(List<LE<V, E>> edges) {
        edges.sort(Comparators.biLevelEdgeComparator());
        return AccumulatorTreeUtil.accumulatorTreeCount(edges);
    }

    protected static <V> void swap(LV<V>[] array, int i, int j) {
        LV<V> temp = array[i];
        array[i] = array[j];
        array[j] = temp;
        array[i].setIndex(i);
        array[j].setIndex(j);
    }

    protected static <V> void swap(List<LV<V>> layer, int i, int j) {
        Collections.swap(layer, i, j);
        layer.get(i).setIndex(i);
        layer.get(j).setIndex(j);
    }

    protected static <V, E> int[] getTargetIndices(List<LE<V, E>> edges) {
        int[] targetIndices = new int[edges.size()];
        for (int i = 0; i < edges.size(); ++i) {
            LE<V, E> edge = edges.get(i);
            targetIndices[i] = edge.getTarget().getIndex();
        }
        return targetIndices;
    }

    protected static <V, E> LE<V, E>[] getEdgeArray(List<LE<V, E>> edges) {
        LE[] edgeArray = new LE[edges.size()];
        for (int i = 0; i < edges.size(); ++i) {
            LE<V, E> edge;
            edgeArray[i] = edge = edges.get(i);
        }
        return edgeArray;
    }

    protected static <V, E> int accumulatorTreeCount(List<LE<V, E>> edges) {
        int[] targetIndices = AccumulatorTreeUtil.getTargetIndices(edges);
        if (targetIndices.length == 0) {
            return 0;
        }
        int maxIndex = Arrays.stream(targetIndices).max().getAsInt();
        AccumulatorTree accumulatorTree = new AccumulatorTree(maxIndex + 1);
        int atcount = accumulatorTree.crossCount(targetIndices);
        return atcount;
    }

    public static <V, E> int crossingWeight(List<LE<V, E>> edges, Function<Integer, Integer> weightFunction) {
        edges.sort(Comparators.biLevelEdgeComparator());
        return AccumulatorTreeUtil.accumulatorTreeWeight(edges, weightFunction);
    }

    protected static <V, E> int accumulatorTreeWeight(List<LE<V, E>> edges, Function<Integer, Integer> weightFunction) {
        int[] targetIndices = AccumulatorTreeUtil.getTargetIndices(edges);
        LE<V, E>[] edgeArray = AccumulatorTreeUtil.getEdgeArray(edges);
        if (targetIndices.length == 0) {
            return 0;
        }
        int maxIndex = Arrays.stream(targetIndices).max().getAsInt();
        AccumulatorTree<V, E> accumulatorTree = new AccumulatorTree<V, E>(maxIndex + 1);
        int atcount = accumulatorTree.crossWeight(edgeArray, weightFunction);
        return atcount;
    }
}

