/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.layout.model;

import org.jungrapht.visualization.layout.model.Point;
import org.jungrapht.visualization.layout.model.Rectangle;

public class Circle {
    public final Point center;
    public final double radius;
    public static final Circle UNIT = new Circle(Point.ORIGIN, 1.0);

    public static Circle of(Point center, double radius) {
        return new Circle(center, radius);
    }

    public Circle(Point center, double radius) {
        this.center = center;
        this.radius = radius;
    }

    public boolean contains(Point p) {
        return p.inside(this.center.x - this.radius, this.center.y - this.radius, this.center.x + this.radius, this.center.y + this.radius) && this.center.distance(p) <= this.radius;
    }

    public boolean intersects(Rectangle r) {
        if (r.x > this.center.x + this.radius) {
            return false;
        }
        if (r.y > this.center.y + this.radius) {
            return false;
        }
        if (r.maxX < this.center.x - this.radius) {
            return false;
        }
        if (r.maxY < this.center.y - this.radius) {
            return false;
        }
        return Circle.squaredDistance(this.center, r) < this.radius * this.radius;
    }

    private static double squaredDistance(Point p, Rectangle r) {
        double cy;
        double distSq = 0.0;
        double cx = p.x;
        if (cx < r.x) {
            distSq += (r.x - cx) * (r.x - cx);
        }
        if (cx > r.maxX) {
            distSq += (cx - r.maxX) * (cx - r.maxX);
        }
        if ((cy = p.y) < r.y) {
            distSq += (r.y - cy) * (r.y - cy);
        }
        if (cy > r.maxY) {
            distSq += (cy - r.maxY) * (cy - r.maxY);
        }
        return distSq;
    }
}

