/*
 * Decompiled with CFR 0.152.
 */
package org.prevayler.implementation;

import java.io.Serializable;
import java.util.Date;
import org.prevayler.foundation.Chunk;
import org.prevayler.implementation.Capsule;

public class TransactionTimestamp
implements Serializable {
    static final long serialVersionUID = 1L;
    private final Capsule _capsule;
    private final long _systemVersion;
    private final long _executionTime;

    public TransactionTimestamp(Capsule capsule, long systemVersion, Date executionTime) {
        this(capsule, systemVersion, executionTime.getTime());
    }

    private TransactionTimestamp(Capsule capsule, long systemVersion, long executionTime) {
        this._capsule = capsule;
        this._systemVersion = systemVersion;
        this._executionTime = executionTime;
    }

    public Capsule capsule() {
        return this._capsule;
    }

    public long systemVersion() {
        return this._systemVersion;
    }

    public Date executionTime() {
        return new Date(this._executionTime);
    }

    public TransactionTimestamp cleanCopy() {
        return new TransactionTimestamp(this._capsule.cleanCopy(), this._systemVersion, this._executionTime);
    }

    public Chunk toChunk() {
        Chunk chunk = this._capsule.toChunk();
        chunk.setParameter("systemVersion", String.valueOf(this._systemVersion));
        chunk.setParameter("executionTime", String.valueOf(this._executionTime));
        return chunk;
    }

    public static TransactionTimestamp fromChunk(Chunk chunk) {
        Capsule capsule = Capsule.fromChunk(chunk);
        long systemVersion = Long.parseLong(chunk.getParameter("systemVersion"));
        long executionTime = Long.parseLong(chunk.getParameter("executionTime"));
        return new TransactionTimestamp(capsule, systemVersion, executionTime);
    }
}

