/*
 * Decompiled with CFR 0.152.
 */
package org.prevayler.implementation.snapshot;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Map;
import org.prevayler.foundation.serialization.JavaSerializer;
import org.prevayler.foundation.serialization.Serializer;
import org.prevayler.implementation.PrevalentSystemGuard;
import org.prevayler.implementation.PrevaylerDirectory;

public class GenericSnapshotManager<P> {
    private Map _strategies;
    private String _primarySuffix;
    private PrevaylerDirectory _directory;
    private PrevalentSystemGuard<P> _recoveredPrevalentSystem;

    public GenericSnapshotManager(Map snapshotSerializers, String primarySnapshotSuffix, P newPrevalentSystem, PrevaylerDirectory directory, Serializer journalSerializer) throws Exception {
        for (String suffix : snapshotSerializers.keySet()) {
            PrevaylerDirectory.checkValidSnapshotSuffix(suffix);
        }
        if (!snapshotSerializers.containsKey(primarySnapshotSuffix)) {
            throw new IllegalArgumentException("Primary suffix '" + primarySnapshotSuffix + "' does not appear in strategies map");
        }
        this._strategies = snapshotSerializers;
        this._primarySuffix = primarySnapshotSuffix;
        this._directory = directory;
        this._directory.produceDirectory();
        File latestSnapshot = this._directory.latestSnapshot();
        long recoveredVersion = latestSnapshot == null ? 0L : PrevaylerDirectory.snapshotVersion(latestSnapshot);
        P recoveredPrevalentSystem = latestSnapshot == null ? newPrevalentSystem : this.readSnapshot(latestSnapshot);
        this._recoveredPrevalentSystem = new PrevalentSystemGuard<P>(recoveredPrevalentSystem, recoveredVersion, journalSerializer);
    }

    GenericSnapshotManager(P newPrevalentSystem) {
        this._strategies = Collections.singletonMap("snapshot", new JavaSerializer());
        this._primarySuffix = "snapshot";
        this._directory = null;
        this._recoveredPrevalentSystem = new PrevalentSystemGuard<P>(newPrevalentSystem, 0L, new JavaSerializer());
    }

    public Serializer primarySerializer() {
        return (Serializer)this._strategies.get(this._primarySuffix);
    }

    public PrevalentSystemGuard<P> recoveredPrevalentSystem() {
        return this._recoveredPrevalentSystem;
    }

    public File writeSnapshot(P prevalentSystem, long version) throws Exception {
        File tempFile = this._directory.createTempFile("snapshot" + version + "temp", "generatingSnapshot");
        this.writeSnapshot(prevalentSystem, tempFile);
        File permanent = this.snapshotFile(version);
        permanent.delete();
        if (!tempFile.renameTo(permanent)) {
            throw new IOException("Temporary snapshot file generated: " + tempFile + "\nUnable to rename it permanently to: " + permanent);
        }
        return permanent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeSnapshot(P prevalentSystem, File snapshotFile) throws Exception {
        FileOutputStream out = new FileOutputStream(snapshotFile);
        try {
            this.primarySerializer().writeObject(out, prevalentSystem);
        }
        finally {
            ((OutputStream)out).close();
        }
    }

    private File snapshotFile(long version) {
        return this._directory.snapshotFile(version, this._primarySuffix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private P readSnapshot(File snapshotFile) throws Exception {
        String suffix = snapshotFile.getName().substring(snapshotFile.getName().indexOf(46) + 1);
        if (!this._strategies.containsKey(suffix)) {
            throw new IOException(snapshotFile.toString() + " cannot be read; only " + this._strategies.keySet().toString() + " supported");
        }
        Serializer serializer = (Serializer)this._strategies.get(suffix);
        FileInputStream in = new FileInputStream(snapshotFile);
        try {
            Object object = serializer.readObject(in);
            return (P)object;
        }
        finally {
            in.close();
        }
    }
}

