/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.fid.db;

import db.ByteField;
import db.DBFieldIterator;
import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.LongField;
import db.RecordIterator;
import db.Schema;
import db.ShortField;
import db.Table;
import ghidra.feature.fid.db.FidDB;
import ghidra.feature.fid.db.FunctionRecord;
import ghidra.feature.fid.db.LibraryRecord;
import ghidra.feature.fid.db.StringRecord;
import ghidra.feature.fid.db.StringsTable;
import ghidra.feature.fid.hash.FidHashQuad;
import ghidra.program.database.DBObjectCache;
import ghidra.util.UniversalIdGenerator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FunctionsTable {
    static final String FUNCTIONS_TABLE = "Functions Table";
    static final int CODE_UNIT_SIZE_COL = 0;
    static final int FULL_HASH_COL = 1;
    static final int SPECIFIC_HASH_ADDITIONAL_SIZE_COL = 2;
    static final int SPECIFIC_HASH_COL = 3;
    static final int LIBRARY_ID_COL = 4;
    static final int NAME_ID_COL = 5;
    static final int ENTRY_POINT_COL = 6;
    static final int DOMAIN_PATH_ID_COL = 7;
    static final int FLAGS_COL = 8;
    static final int CACHE_SIZE = 10000;
    static final Schema SCHEMA = new Schema(6, "Function ID", new Field[]{ShortField.INSTANCE, LongField.INSTANCE, ByteField.INSTANCE, LongField.INSTANCE, LongField.INSTANCE, LongField.INSTANCE, LongField.INSTANCE, LongField.INSTANCE, ByteField.INSTANCE}, new String[]{"Code Unit Size", "Full Hash", "Specific Hash Additional Size", "Specific Hash", "Library ID", "Name ID", "Entry Point", "Domain Path ID", "Flags"});
    static int[] INDEXED_COLUMNS = new int[]{1, 5};
    Table table;
    FidDB fidDb;
    StringsTable stringsTable;
    DBObjectCache<FunctionRecord> functionCache;

    public FunctionsTable(FidDB fid, DBHandle handle) throws IOException {
        this.table = handle.getTable(FUNCTIONS_TABLE);
        this.fidDb = fid;
        this.stringsTable = fid.getStringsTable();
        this.functionCache = new DBObjectCache(10000);
    }

    public static void createTable(DBHandle handle) throws IOException {
        handle.createTable(FUNCTIONS_TABLE, SCHEMA, INDEXED_COLUMNS);
    }

    public Long getFullHashValueAtOrAfter(long value) throws IOException {
        LongField hashField = new LongField(value);
        DBFieldIterator indexFieldIterator = this.table.indexFieldIterator((Field)hashField, null, true, 1);
        if (indexFieldIterator.hasNext()) {
            Field next = indexFieldIterator.next();
            return next.getLongValue();
        }
        return null;
    }

    public List<FunctionRecord> getFunctionRecordsBySpecificHash(long hash) throws IOException {
        RecordIterator iterator = this.table.iterator();
        ArrayList<FunctionRecord> list = new ArrayList<FunctionRecord>();
        while (iterator.hasNext()) {
            DBRecord record = iterator.next();
            if (record.getLongValue(3) != hash) continue;
            FunctionRecord functionRecord = (FunctionRecord)this.functionCache.get(record);
            if (functionRecord == null) {
                functionRecord = new FunctionRecord(this.fidDb, this.functionCache, record);
            }
            list.add(functionRecord);
        }
        return list;
    }

    public List<FunctionRecord> getFunctionRecordsByFullHash(long hash) throws IOException {
        LongField hashField = new LongField(hash);
        DBFieldIterator iterator = this.table.indexKeyIterator(1, (Field)hashField, (Field)hashField, true);
        if (!iterator.hasNext()) {
            return Collections.emptyList();
        }
        ArrayList<FunctionRecord> list = new ArrayList<FunctionRecord>();
        while (iterator.hasNext()) {
            Field key = iterator.next();
            FunctionRecord functionRecord = (FunctionRecord)this.functionCache.get(key.getLongValue());
            if (functionRecord == null) {
                DBRecord record = this.table.getRecord(key);
                functionRecord = new FunctionRecord(this.fidDb, this.functionCache, record);
            }
            list.add(functionRecord);
        }
        return list;
    }

    public FunctionRecord createFunctionRecord(long libraryID, FidHashQuad hashQuad, String name, long entryPoint, String domainPath, boolean hasTerminator) throws IOException {
        DBRecord record = SCHEMA.createRecord(UniversalIdGenerator.nextID().getValue());
        record.setShortValue(0, hashQuad.getCodeUnitSize());
        record.setLongValue(1, hashQuad.getFullHash());
        record.setByteValue(2, hashQuad.getSpecificHashAdditionalSize());
        record.setLongValue(3, hashQuad.getSpecificHash());
        record.setLongValue(4, libraryID);
        long stringID = this.stringsTable.obtainStringID(name);
        record.setLongValue(5, stringID);
        record.setLongValue(6, entryPoint);
        stringID = this.stringsTable.obtainStringID(domainPath);
        record.setLongValue(7, stringID);
        byte flags = (byte)(hasTerminator ? 1 : 0);
        record.setByteValue(8, flags);
        this.table.putRecord(record);
        FunctionRecord functionRecord = new FunctionRecord(this.fidDb, this.functionCache, record);
        return functionRecord;
    }

    void modifyFlags(long functionID, int flagMask, boolean value) throws IOException {
        DBRecord record = this.table.getRecord(functionID);
        if (record == null) {
            throw new IOException("Function record does not exist");
        }
        byte flags = record.getByteValue(8);
        flags = value ? (byte)(flags | flagMask) : (byte)(flags & ~flagMask);
        record.setByteValue(8, flags);
        this.table.putRecord(record);
        this.functionCache.delete(functionID);
    }

    public List<FunctionRecord> getFunctionRecordsByNameSubstring(String nameSearch) throws IOException {
        DBFieldIterator iterator = this.table.indexKeyIterator(5);
        if (!iterator.hasNext()) {
            return Collections.emptyList();
        }
        ArrayList<FunctionRecord> list = new ArrayList<FunctionRecord>();
        while (iterator.hasNext()) {
            Field key = iterator.next();
            FunctionRecord functionRecord = (FunctionRecord)this.functionCache.get(key.getLongValue());
            if (functionRecord == null) {
                DBRecord record = this.table.getRecord(key);
                long nameID = record.getLongValue(5);
                StringRecord nameRecord = this.stringsTable.lookupString(nameID);
                String name = nameRecord.getValue();
                if (name.contains(nameSearch)) {
                    functionRecord = new FunctionRecord(this.fidDb, this.functionCache, record);
                }
            } else if (!functionRecord.getName().contains(nameSearch)) {
                functionRecord = null;
            }
            if (functionRecord == null) continue;
            list.add(functionRecord);
        }
        return list;
    }

    public List<FunctionRecord> getFunctionRecordsByNameRegex(String regex) throws IOException {
        Matcher matcher = Pattern.compile(regex).matcher("");
        DBFieldIterator iterator = this.table.indexKeyIterator(5);
        if (!iterator.hasNext()) {
            return Collections.emptyList();
        }
        ArrayList<FunctionRecord> list = new ArrayList<FunctionRecord>();
        while (iterator.hasNext()) {
            Field key = iterator.next();
            FunctionRecord functionRecord = (FunctionRecord)this.functionCache.get(key.getLongValue());
            if (functionRecord == null) {
                DBRecord record = this.table.getRecord(key);
                long nameID = record.getLongValue(5);
                StringRecord nameRecord = this.stringsTable.lookupString(nameID);
                String name = nameRecord.getValue();
                matcher.reset(name);
                if (matcher.matches()) {
                    functionRecord = new FunctionRecord(this.fidDb, this.functionCache, record);
                }
            } else {
                matcher.reset(functionRecord.getName());
                if (!matcher.matches()) {
                    functionRecord = null;
                }
            }
            if (functionRecord == null) continue;
            list.add(functionRecord);
        }
        return list;
    }

    public FunctionRecord getFunctionByID(long functionID) throws IOException {
        DBRecord record;
        FunctionRecord functionRecord = (FunctionRecord)this.functionCache.get(functionID);
        if (functionRecord == null && (record = this.table.getRecord(functionID)) != null) {
            functionRecord = new FunctionRecord(this.fidDb, this.functionCache, record);
        }
        return functionRecord;
    }

    public List<FunctionRecord> getFunctionRecordsByDomainPathSubstring(String domainPathSearch) throws IOException {
        RecordIterator iterator = this.table.iterator();
        ArrayList<FunctionRecord> list = new ArrayList<FunctionRecord>();
        while (iterator.hasNext()) {
            DBRecord record = iterator.next();
            long domainPathID = record.getLongValue(7);
            StringRecord domainPathRecord = this.stringsTable.lookupString(domainPathID);
            String domainPath = domainPathRecord.getValue();
            if (!domainPath.contains(domainPathSearch)) continue;
            FunctionRecord functionRecord = (FunctionRecord)this.functionCache.get(record);
            if (functionRecord == null) {
                functionRecord = new FunctionRecord(this.fidDb, this.functionCache, record);
            }
            list.add(functionRecord);
        }
        return list;
    }

    public List<FunctionRecord> getFunctionRecordsByLibraryAndName(LibraryRecord library, String name) throws IOException {
        Long stringID = this.stringsTable.lookupStringID(name);
        if (stringID == null) {
            return Collections.emptyList();
        }
        LongField field = new LongField(stringID.longValue());
        DBFieldIterator iterator = this.table.indexKeyIterator(5, (Field)field, (Field)field, true);
        if (!iterator.hasNext()) {
            return Collections.emptyList();
        }
        long libraryKey = library.getLibraryID();
        ArrayList<FunctionRecord> list = new ArrayList<FunctionRecord>();
        while (iterator.hasNext()) {
            Field key = iterator.next();
            FunctionRecord functionRecord = (FunctionRecord)this.functionCache.get(key.getLongValue());
            if (functionRecord == null) {
                DBRecord record = this.table.getRecord(key);
                if (record.getLongValue(4) != libraryKey) continue;
                functionRecord = new FunctionRecord(this.fidDb, this.functionCache, record);
                list.add(functionRecord);
                continue;
            }
            if (functionRecord.getLibraryID() != libraryKey) continue;
            list.add(functionRecord);
        }
        return list;
    }
}

