/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.d2j.dex;

import com.googlecode.d2j.Field;
import com.googlecode.d2j.Method;
import com.googlecode.d2j.node.DexClassNode;
import com.googlecode.d2j.node.DexFieldNode;
import com.googlecode.d2j.node.DexFileNode;
import com.googlecode.d2j.node.DexMethodNode;
import com.googlecode.d2j.node.insn.ConstStmtNode;
import com.googlecode.d2j.node.insn.MethodStmtNode;
import com.googlecode.d2j.node.insn.Stmt1RNode;
import com.googlecode.d2j.node.insn.TypeStmtNode;
import com.googlecode.d2j.reader.Op;
import com.googlecode.d2j.visitors.DexCodeVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;

public final class DexFix {
    private static final int ACC_STATIC_FINAL = 24;

    private DexFix() {
        throw new UnsupportedOperationException();
    }

    public static void fixStaticFinalFieldValue(DexFileNode dex) {
        if (dex.clzs != null) {
            for (DexClassNode classNode : dex.clzs) {
                DexFix.fixStaticFinalFieldValue(classNode);
            }
        }
    }

    public static void fixStaticFinalFieldValue(final DexClassNode classNode) {
        if (classNode.fields == null) {
            return;
        }
        final HashMap<String, DexFieldNode> fs = new HashMap<String, DexFieldNode>();
        final HashMap<String, DexFieldNode> shouldNotBeAssigned = new HashMap<String, DexFieldNode>();
        for (DexFieldNode fn : classNode.fields) {
            if ((fn.access & 0x18) != 24) continue;
            if (fn.cst == null) {
                char t = fn.field.getType().charAt(0);
                if (t == 'L' || t == '[') continue;
                fs.put(fn.field.getName() + ":" + fn.field.getType(), fn);
                continue;
            }
            if (!DexFix.isPrimitiveZero(fn.field.getType(), fn.cst)) continue;
            shouldNotBeAssigned.put(fn.field.getName() + ":" + fn.field.getType(), fn);
        }
        if (fs.isEmpty() && shouldNotBeAssigned.isEmpty()) {
            return;
        }
        DexMethodNode node = null;
        if (classNode.methods != null) {
            for (DexMethodNode mn : classNode.methods) {
                if (!mn.method.getName().equals("<clinit>")) continue;
                node = mn;
                break;
            }
        }
        if (node != null) {
            if (node.codeNode != null) {
                node.codeNode.accept(new DexCodeVisitor(){

                    public void visitFieldStmt(Op op, int a, int b, Field field) {
                        switch (op) {
                            case SPUT: 
                            case SPUT_BOOLEAN: 
                            case SPUT_BYTE: 
                            case SPUT_CHAR: 
                            case SPUT_OBJECT: 
                            case SPUT_SHORT: 
                            case SPUT_WIDE: {
                                if (!field.getOwner().equals(classNode.className)) break;
                                String key = field.getName() + ":" + field.getType();
                                fs.remove(key);
                                DexFieldNode dn = (DexFieldNode)shouldNotBeAssigned.get(key);
                                if (dn == null) break;
                                dn.cst = null;
                                break;
                            }
                        }
                    }
                });
            } else {
                return;
            }
        }
        for (DexFieldNode fn : fs.values()) {
            fn.cst = DexFix.getDefaultValueOfType(fn.field.getType().charAt(0));
        }
    }

    public static void fixTooLongStringConstant(DexMethodNode methodNode) {
        if ((methodNode.access & 0x100) != 0 || (methodNode.access & 0x400) != 0) {
            return;
        }
        if (methodNode.codeNode != null) {
            HashMap toBeReplaced = new HashMap();
            AtomicInteger maxRegister = new AtomicInteger(methodNode.codeNode.totalRegister);
            methodNode.codeNode.stmts.forEach(insn -> {
                if (insn instanceof ConstStmtNode && (insn.op == Op.CONST_STRING || insn.op == Op.CONST_STRING_JUMBO) && ((ConstStmtNode)insn).value instanceof String) {
                    String s = (String)((ConstStmtNode)insn).value;
                    int register = ((ConstStmtNode)insn).a;
                    if (s.length() < Short.MAX_VALUE) {
                        return;
                    }
                    ArrayList<String> parts = new ArrayList<String>();
                    int length = s.length();
                    for (int i = 0; i < length; i += Short.MAX_VALUE) {
                        parts.add(s.substring(i, Math.min(length, i + Short.MAX_VALUE)));
                    }
                    ArrayList<Object> generatedStringConcat = new ArrayList<Object>();
                    generatedStringConcat.add(new TypeStmtNode(Op.NEW_INSTANCE, register, 0, "Ljava/lang/StringBuilder;"));
                    generatedStringConcat.add(new ConstStmtNode(Op.CONST, register + 1, (Object)s.length()));
                    generatedStringConcat.add(new MethodStmtNode(Op.INVOKE_DIRECT, new int[]{register, register + 1}, new Method("Ljava/lang/StringBuilder;", "<init>", new String[]{"I"}, "V")));
                    for (String part : parts) {
                        generatedStringConcat.add(new ConstStmtNode(Op.CONST_STRING, register + 1, (Object)part));
                        generatedStringConcat.add(new MethodStmtNode(Op.INVOKE_VIRTUAL, new int[]{register, register + 1}, new Method("Ljava/lang/StringBuilder;", "append", new String[]{"Ljava/lang/String;"}, "Ljava/lang/StringBuilder;")));
                    }
                    generatedStringConcat.add(new MethodStmtNode(Op.INVOKE_VIRTUAL, new int[]{register}, new Method("Ljava/lang/StringBuilder;", "toString", new String[0], "Ljava/lang/String;")));
                    generatedStringConcat.add(new Stmt1RNode(Op.MOVE_RESULT_OBJECT, register));
                    toBeReplaced.put(insn, generatedStringConcat);
                    maxRegister.set(Math.max(register + 1, maxRegister.get()));
                }
            });
            methodNode.codeNode.totalRegister = maxRegister.get();
            toBeReplaced.keySet().forEach(i -> {
                int index = methodNode.codeNode.stmts.indexOf(i);
                methodNode.codeNode.stmts.addAll(index, (Collection)toBeReplaced.get(i));
                methodNode.codeNode.stmts.remove(i);
            });
        }
    }

    private static Object getDefaultValueOfType(char t) {
        switch (t) {
            case 'B': {
                return (byte)0;
            }
            case 'Z': {
                return Boolean.FALSE;
            }
            case 'S': {
                return (short)0;
            }
            case 'C': {
                return Character.valueOf('\u0000');
            }
            case 'I': {
                return 0;
            }
            case 'F': {
                return Float.valueOf(0.0f);
            }
            case 'J': {
                return 0L;
            }
            case 'D': {
                return 0.0;
            }
        }
        return null;
    }

    static boolean isPrimitiveZero(String desc, Object value) {
        if (value != null && desc != null && !desc.isEmpty()) {
            switch (desc.charAt(0)) {
                case 'Z': {
                    return (Boolean)value == false;
                }
                case 'C': {
                    return ((Character)value).charValue() == '\u0000';
                }
                case 'B': {
                    return (Byte)value == 0;
                }
                case 'S': {
                    return (Short)value == 0;
                }
                case 'I': {
                    return (Integer)value == 0;
                }
                case 'F': {
                    return ((Float)value).floatValue() == 0.0f;
                }
                case 'J': {
                    return (Long)value == 0L;
                }
                case 'D': {
                    return (Double)value == 0.0;
                }
            }
        }
        return false;
    }
}

