/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit;

import ghidra.lifecycle.Internal;
import ghidra.pcode.emu.BytesPcodeThread;
import ghidra.pcode.emu.InstructionDecoder;
import ghidra.pcode.emu.ThreadPcodeExecutorState;
import ghidra.pcode.emu.jit.JitDefaultBytesPcodeExecutorState;
import ghidra.pcode.emu.jit.JitPassage;
import ghidra.pcode.emu.jit.JitPcodeEmulator;
import ghidra.pcode.emu.jit.JitThreadBytesPcodeExecutorState;
import ghidra.pcode.emu.jit.decode.JitPassageDecoder;
import ghidra.pcode.emu.jit.gen.tgt.JitCompiledPassage;
import ghidra.pcode.exec.PcodeExecutorState;
import ghidra.pcode.exec.PcodeProgram;
import ghidra.pcode.exec.SuspendedPcodeExecutionException;
import ghidra.program.model.address.Address;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.ProgramContext;
import java.util.HashMap;
import java.util.Map;

public class JitPcodeThread
extends BytesPcodeThread {
    protected final JitPassageDecoder passageDecoder;
    protected final Map<JitPassage.AddrCtx, JitCompiledPassage.EntryPoint> codeCache = new HashMap<JitPassage.AddrCtx, JitCompiledPassage.EntryPoint>();

    public JitPcodeThread(String name, JitPcodeEmulator machine) {
        super(name, machine);
        this.passageDecoder = this.createPassageDecoder();
    }

    @Override
    protected ThreadPcodeExecutorState<byte[]> createThreadState(PcodeExecutorState<byte[]> sharedState, PcodeExecutorState<byte[]> localState) {
        return new JitThreadBytesPcodeExecutorState((JitDefaultBytesPcodeExecutorState)sharedState, (JitDefaultBytesPcodeExecutorState)localState);
    }

    protected JitPassageDecoder createPassageDecoder() {
        return new JitPassageDecoder(this);
    }

    @Override
    public JitPcodeEmulator getMachine() {
        return (JitPcodeEmulator)super.getMachine();
    }

    public JitThreadBytesPcodeExecutorState getState() {
        return (JitThreadBytesPcodeExecutorState)super.getState();
    }

    @Override
    @Internal
    public PcodeProgram getInject(Address address) {
        return super.getInject(address);
    }

    @Internal
    public InstructionDecoder getDecoder() {
        return this.decoder;
    }

    @Internal
    public ProgramContext getDefaultContext() {
        return this.defaultContext;
    }

    @Override
    public void inject(Address address, String source) {
        super.inject(address, source);
    }

    public boolean hasEntry(JitPassage.AddrCtx pcCtx) {
        return this.getMachine().hasEntryPrototype(pcCtx);
    }

    public JitCompiledPassage.EntryPoint getEntry(JitPassage.AddrCtx pcCtx) {
        return this.codeCache.computeIfAbsent(pcCtx, k -> this.getMachine().getEntryPrototype((JitPassage.AddrCtx)k, this.passageDecoder).createInstance(this));
    }

    @Override
    public void run() {
        this.setSuspended(false);
        if (this.frame != null) {
            this.finishInstruction();
        }
        JitCompiledPassage.EntryPoint next = null;
        while (!this.isSuspended()) {
            if (next == null) {
                next = this.getEntry(new JitPassage.AddrCtx(this.getContext(), this.getCounter()));
            }
            try {
                next = next.run();
            }
            catch (SuspendedPcodeExecutionException suspendedPcodeExecutionException) {}
        }
    }

    public void count(int instructions, int trailingOps) {
        if (this.isSuspended()) {
            throw new SuspendedPcodeExecutionException(null, null);
        }
    }

    public void writeCounterAndContext(Address counter, RegisterValue context) {
        this.writeCounter(counter);
        if (context != null) {
            this.writeContext(context);
        }
    }

    public void setCounterAndContext(Address counter, RegisterValue context) {
        this.setCounter(counter);
        if (context != null) {
            this.writeContext(context);
        }
    }
}

