/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.analysis;

import ghidra.pcode.emu.jit.analysis.JitAnalysisContext;
import ghidra.pcode.emu.jit.analysis.JitControlFlowModel;
import ghidra.pcode.emu.jit.analysis.JitDataFlowArithmetic;
import ghidra.pcode.emu.jit.analysis.JitDataFlowExecutor;
import ghidra.pcode.emu.jit.analysis.JitDataFlowModel;
import ghidra.pcode.emu.jit.analysis.JitDataFlowState;
import ghidra.pcode.emu.jit.analysis.JitDataFlowUseropLibrary;
import ghidra.pcode.emu.jit.op.JitPhiOp;
import ghidra.pcode.emu.jit.var.JitMissingVar;
import ghidra.pcode.emu.jit.var.JitVal;
import ghidra.pcode.exec.PcodeExecutorStatePiece;
import ghidra.program.model.lang.Register;
import ghidra.program.model.pcode.Varnode;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class JitDataFlowBlockAnalyzer {
    private final JitAnalysisContext context;
    private final JitDataFlowModel dfm;
    private final JitControlFlowModel.JitBlock block;
    private final JitDataFlowArithmetic arithmetic;
    private final JitDataFlowUseropLibrary library;
    private final JitDataFlowState state;
    private final boolean isEntry;

    JitDataFlowBlockAnalyzer(JitAnalysisContext context, JitDataFlowModel dfm, JitControlFlowModel.JitBlock block) {
        this.context = context;
        this.dfm = dfm;
        this.block = block;
        this.arithmetic = dfm.getArithmetic();
        this.library = dfm.getLibrary();
        this.state = new JitDataFlowState(context, dfm, block);
        this.isEntry = context.getOpEntry(block.first()) != null;
    }

    void doIntrablock() {
        JitDataFlowExecutor exec = new JitDataFlowExecutor(this.context, this.dfm, this.state);
        exec.execute(this.block, this.library);
    }

    void fillPhiFromDeps(JitPhiOp phi) {
        this.fillPhiFromDeps(phi, new HashSet<JitControlFlowModel.JitBlock>());
    }

    private void fillPhiFromDeps(JitPhiOp phi, Set<JitControlFlowModel.JitBlock> visited) {
        if (this.isEntry) {
            phi.addInputOption();
        }
        for (JitControlFlowModel.BlockFlow flow : this.block.flowsTo().values()) {
            JitDataFlowBlockAnalyzer analyzerFrom = this.dfm.getOrCreateAnalyzer(flow.from());
            analyzerFrom.fillPhiFromBlock(phi, flow, visited);
        }
    }

    private void fillPhiFromBlock(JitPhiOp phi, JitControlFlowModel.BlockFlow flow, Set<JitControlFlowModel.JitBlock> visited) {
        if (!visited.add(this.block)) {
            return;
        }
        Varnode phiVn = phi.out().varnode();
        List<JitVal> defs = this.state.getDefinitions(phiVn);
        if (defs.size() != 1) {
            defs = this.state.generatePhis(defs, this.dfm.phiQueue);
            JitVal catOpt = this.arithmetic.catenate(phiVn, defs);
            phi.addOption(flow, catOpt);
            return;
        }
        JitVal val = defs.get(0);
        if (val instanceof JitMissingVar) {
            JitMissingVar missing = (JitMissingVar)val;
            JitPhiOp phi2 = missing.generatePhi(this.dfm, this.block);
            this.dfm.phiQueue.add(phi2);
            this.state.setVar(missing.varnode(), phi2.out());
            phi.addOption(flow, phi2.out());
            return;
        }
        phi.addOption(flow, val);
    }

    public Set<Varnode> getVarnodesRead() {
        return this.state.getVarnodesRead();
    }

    public Set<Varnode> getVarnodesWritten() {
        return this.state.getVarnodesWritten();
    }

    public List<JitVal> getOutput(Varnode varnode) {
        return this.state.getDefinitions(varnode);
    }

    public List<JitVal> getOutput(Register register) {
        return this.state.getDefinitions(register);
    }

    public JitVal getVar(Varnode vn) {
        return (JitVal)this.state.getVar(vn, PcodeExecutorStatePiece.Reason.EXECUTE_READ);
    }
}

