/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.analysis;

import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.lifecycle.Internal;
import ghidra.pcode.emu.jit.JitPassage;
import ghidra.pcode.emu.jit.analysis.JitAnalysisContext;
import ghidra.pcode.emu.jit.analysis.JitControlFlowModel;
import ghidra.pcode.emu.jit.analysis.JitDataFlowArithmetic;
import ghidra.pcode.emu.jit.analysis.JitDataFlowBlockAnalyzer;
import ghidra.pcode.emu.jit.analysis.JitDataFlowUseropLibrary;
import ghidra.pcode.emu.jit.analysis.JitOpUpwardVisitor;
import ghidra.pcode.emu.jit.analysis.JitTypeBehavior;
import ghidra.pcode.emu.jit.op.JitDefOp;
import ghidra.pcode.emu.jit.op.JitOp;
import ghidra.pcode.emu.jit.op.JitPhiOp;
import ghidra.pcode.emu.jit.op.JitSyntheticOp;
import ghidra.pcode.emu.jit.var.JitConstVal;
import ghidra.pcode.emu.jit.var.JitDirectMemoryVar;
import ghidra.pcode.emu.jit.var.JitIndirectMemoryVar;
import ghidra.pcode.emu.jit.var.JitLocalOutVar;
import ghidra.pcode.emu.jit.var.JitMemoryOutVar;
import ghidra.pcode.emu.jit.var.JitOutVar;
import ghidra.pcode.emu.jit.var.JitVal;
import ghidra.pcode.emu.jit.var.JitVar;
import ghidra.pcode.emu.jit.var.JitVarnodeVar;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.Varnode;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SequencedSet;
import java.util.Set;

public class JitDataFlowModel {
    private final JitAnalysisContext context;
    private final JitControlFlowModel cfm;
    private final JitPassage passage;
    private final SleighLanguage language;
    private final JitDataFlowArithmetic arithmetic;
    private final JitDataFlowUseropLibrary library;
    private int nextVarId = 1;
    private final List<JitPhiOp> phiNodes = new ArrayList<JitPhiOp>();
    private final List<JitSyntheticOp> synthNodes = new ArrayList<JitSyntheticOp>();
    private final Map<PcodeOp, JitOp> ops = new HashMap<PcodeOp, JitOp>();
    private final Map<JitControlFlowModel.JitBlock, JitDataFlowBlockAnalyzer> analyzers = new HashMap<JitControlFlowModel.JitBlock, JitDataFlowBlockAnalyzer>();
    final SequencedSet<JitPhiOp> phiQueue = new LinkedHashSet<JitPhiOp>();

    static List<JitTypeBehavior> allAny(List<JitVal> inVals) {
        return inVals.stream().map(v -> JitTypeBehavior.ANY).toList();
    }

    public JitDataFlowModel(JitAnalysisContext context, JitControlFlowModel cfm) {
        this.context = context;
        this.cfm = cfm;
        this.passage = context.getPassage();
        this.language = context.getLanguage();
        this.arithmetic = new JitDataFlowArithmetic(context, this);
        this.library = new JitDataFlowUseropLibrary(context, this);
        this.analyze();
    }

    public JitDataFlowArithmetic getArithmetic() {
        return this.arithmetic;
    }

    public JitDataFlowUseropLibrary getLibrary() {
        return this.library;
    }

    public List<JitPhiOp> phiNodes() {
        return this.phiNodes;
    }

    public List<JitSyntheticOp> synthNodes() {
        return this.synthNodes;
    }

    private int nextVarId() {
        return this.nextVarId++;
    }

    public JitOutVar generateOutVar(Varnode out) {
        if (out.isRegister() || out.isUnique()) {
            return new JitLocalOutVar(this.nextVarId(), out);
        }
        return new JitMemoryOutVar(this.nextVarId(), out);
    }

    public JitDirectMemoryVar generateDirectMemoryVar(Varnode vn) {
        return new JitDirectMemoryVar(this.nextVarId(), vn);
    }

    public JitIndirectMemoryVar generateIndirectMemoryVar(AddressSpace space, JitVal offset, int size, boolean quantize) {
        return JitIndirectMemoryVar.INSTANCE;
    }

    public <T extends JitOp> T notifyOp(T op) {
        op.link();
        if (op instanceof JitPhiOp) {
            JitPhiOp phi = (JitPhiOp)op;
            this.phiNodes.add(phi);
            this.synthNodes.add(phi);
        } else if (op instanceof JitSyntheticOp) {
            JitSyntheticOp synth = (JitSyntheticOp)op;
            this.synthNodes.add(synth);
        } else {
            this.ops.put(Objects.requireNonNull(op.op()), op);
        }
        return op;
    }

    public JitOp getJitOp(PcodeOp op) {
        return this.ops.get(op);
    }

    Collection<JitOp> allOps() {
        LinkedHashSet<JitOp> all = new LinkedHashSet<JitOp>();
        all.addAll(this.ops.values());
        all.addAll(this.synthNodes);
        return all;
    }

    public Set<JitVal> allValues() {
        return new ValCollector();
    }

    int idOfVal(JitVal v) {
        int n;
        if (v instanceof JitVar) {
            JitVar vv = (JitVar)v;
            n = vv.id();
        } else {
            n = -2;
        }
        return n;
    }

    public List<JitVal> allValuesSorted() {
        return this.allValues().stream().sorted(Comparator.comparing(this::idOfVal)).toList();
    }

    protected JitDataFlowBlockAnalyzer getOrCreateAnalyzer(JitControlFlowModel.JitBlock block) {
        return this.analyzers.computeIfAbsent(block, b -> new JitDataFlowBlockAnalyzer(this.context, this, (JitControlFlowModel.JitBlock)b));
    }

    public JitDataFlowBlockAnalyzer getAnalyzer(JitControlFlowModel.JitBlock block) {
        return this.analyzers.get(block);
    }

    protected void analyze() {
        for (JitControlFlowModel.JitBlock block : this.cfm.getBlocks()) {
            this.getOrCreateAnalyzer(block).doIntrablock();
        }
        this.analyzeInterblock(this.phiNodes);
    }

    void analyzeInterblock(Collection<JitPhiOp> phis) {
        this.phiQueue.addAll(phis);
        while (!this.phiQueue.isEmpty()) {
            JitPhiOp phi = (JitPhiOp)this.phiQueue.removeFirst();
            JitDataFlowBlockAnalyzer analyzer = this.getOrCreateAnalyzer(phi.block());
            analyzer.fillPhiFromDeps(phi);
        }
    }

    @Internal
    List<JitVal> getOutput(JitControlFlowModel.JitBlock block, Register register) {
        return this.getAnalyzer(block).getOutput(register);
    }

    public void dumpResult() {
        System.err.println("STAGE: DataFlow");
        for (JitControlFlowModel.JitBlock block : this.cfm.getBlocks()) {
            System.err.println("  Block: " + String.valueOf(block));
            for (PcodeOp op : block.getCode()) {
                System.err.println("    %s: %s".formatted(op.getSeqnum(), this.getJitOp(op)));
            }
        }
    }

    public void dumpSynth() {
        System.err.println("SYNTHETIC OPS");
        for (JitSyntheticOp synthOp : this.synthNodes) {
            System.err.println("  " + String.valueOf(synthOp));
        }
    }

    @Internal
    public void exportGraphviz(File file) {
        new GraphvizExporter(file);
    }

    protected class ValCollector
    extends HashSet<JitVal>
    implements JitOpUpwardVisitor {
        public ValCollector() {
            for (PcodeOp op : JitDataFlowModel.this.passage.getCode()) {
                JitOp jitOp = JitDataFlowModel.this.getJitOp(op);
                this.visitOp(jitOp);
                if (!(jitOp instanceof JitDefOp)) continue;
                JitDefOp defOp = (JitDefOp)jitOp;
                this.visitVal(defOp.out());
            }
        }

        @Override
        public void visitVal(JitVal v) {
            if (!this.add(v)) {
                return;
            }
            JitOpUpwardVisitor.super.visitVal(v);
        }
    }

    protected class GraphvizExporter
    implements JitOpUpwardVisitor {
        final PrintWriter out;
        final Set<JitVar> vars = new HashSet<JitVar>();
        final Set<JitOp> ops = new HashSet<JitOp>();

        public GraphvizExporter(File outFile) {
            try (FileOutputStream outStream = new FileOutputStream(outFile);
                 PrintWriter out = new PrintWriter(outStream);){
                this.out = out;
                out.println("digraph DataFlow {");
                for (PcodeOp op : JitDataFlowModel.this.passage.getCode()) {
                    JitOp jitOp = JitDataFlowModel.this.getJitOp(op);
                    if (jitOp instanceof JitDefOp) {
                        JitDefOp defOp = (JitDefOp)jitOp;
                        this.visitVal(defOp.out());
                        continue;
                    }
                    this.visitOp(jitOp);
                }
                out.println("}");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        String opLabel(JitOp op) {
            JitOp jitOp = op;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{}, (Object)jitOp, n)) {
                case -1 -> "null";
                default -> "%s\n%x".formatted(op.getClass().getSimpleName(), System.identityHashCode(op));
            };
        }

        @Override
        public void visitOp(JitOp op) {
            if (!this.ops.add(op)) {
                return;
            }
            this.out.println("  \"op%x\" [\n    label = \"%s\"\n    shape = \"ellipse\"\n  ];\n".formatted(System.identityHashCode(op), this.opLabel(op)));
            if (op == null) {
                return;
            }
            int i = 0;
            for (JitVal input : op.inputs()) {
                ++i;
                if (input instanceof JitVar) {
                    JitVar iv = (JitVar)input;
                    this.out.println("  \"var%d\" -> \"op%x\" [\n    headlabel = \"[%d]\"\n  ];\n".formatted(iv.id(), System.identityHashCode(op), i));
                    continue;
                }
                this.out.println("  \"val%x\" -> \"op%x\" [\n    headlabel = \"[%d]\"\n  ];\n".formatted(System.identityHashCode(input), System.identityHashCode(op), i));
            }
            if (op instanceof JitDefOp) {
                JitDefOp defOp = (JitDefOp)op;
                this.out.println("  \"op%x\" -> \"var%d\" [\n    taillabel = \"out\"\n  ];\n".formatted(System.identityHashCode(op), defOp.out().id()));
            }
            JitOpUpwardVisitor.super.visitOp(op);
        }

        /*
         * Enabled aggressive block sorting
         */
        String varLabel(JitVar v) {
            JitVar jitVar = v;
            Objects.requireNonNull(jitVar);
            JitVar jitVar2 = jitVar;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JitVarnodeVar.class}, (Object)jitVar2, n)) {
                case 0: {
                    JitVarnodeVar vv = (JitVarnodeVar)jitVar2;
                    return "%s\n%d".formatted(vv.varnode().toString((Language)JitDataFlowModel.this.language), v.id());
                }
            }
            throw new AssertionError();
        }

        @Override
        public void visitVal(JitVal v) {
            String label;
            String name;
            if (v instanceof JitVar) {
                JitVar vv = (JitVar)v;
                if (!this.vars.add(vv)) {
                    return;
                }
                name = "var%d".formatted(vv.id());
                label = this.varLabel(vv);
            } else if (v instanceof JitConstVal) {
                JitConstVal cv = (JitConstVal)v;
                name = "val%x".formatted(System.identityHashCode(cv));
                label = cv.value().toString();
            } else {
                throw new AssertionError();
            }
            this.out.println("  \"%s\" [\n    label = \"%s\"\n    shape = \"box\"\n  ];\n".formatted(name, label));
            for (JitVal.ValUse use : v.uses()) {
                this.out.println("  \"%s\" -> \"op%x\" [\n    dir = \"back\"\n    arrowhead = \"none\"\n    arrowtail = \"crow\"\n    taillabel = \"use\"\n  ];\n".formatted(name, System.identityHashCode(use.op())));
            }
            if (v instanceof JitOutVar) {
                JitOutVar ov = (JitOutVar)v;
                this.out.println("  \"op%x\" -> \"%s\" [\n    dir = \"back\"\n    arrowhead = \"none\"\n    arrowtail = \"crow\"\n    taillabel = \"def\"\n  ];\n".formatted(System.identityHashCode(ov.definition()), name));
            }
            JitOpUpwardVisitor.super.visitVal(v);
        }
    }
}

