/*
 * Decompiled with CFR 0.152.
 */
package generic.stl;

import generic.stl.IteratorSTL;
import generic.stl.ReverseVectorIterator;
import generic.stl.VectorIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class VectorSTL<T>
implements Iterable<T> {
    static Comparator comparableComparator = VectorSTL.createComparator();
    private ArrayList<T> data;

    private static Comparator createComparator() {
        Comparator c = (o1, o2) -> {
            Comparable c1 = (Comparable)o1;
            Comparable c2 = (Comparable)o2;
            return c1.compareTo(c2);
        };
        return c;
    }

    public VectorSTL() {
        this.data = new ArrayList();
    }

    public VectorSTL(int initialCapacity) {
        this.data = new ArrayList(initialCapacity);
    }

    public VectorSTL(int initialCapacity, T value) {
        this.data = new ArrayList(initialCapacity);
        for (int ii = 0; ii < initialCapacity; ++ii) {
            this.data.add(value);
        }
    }

    public VectorSTL(VectorSTL<T> other) {
        this.data = new ArrayList<T>(other.data);
    }

    public String toString() {
        return this.data.toString();
    }

    public void reserve(int capacity) {
        this.data.ensureCapacity(capacity);
    }

    public IteratorSTL<T> begin() {
        return new VectorIterator<T>(this.data, 0);
    }

    public IteratorSTL<T> end() {
        return new VectorIterator<T>(this.data, this.data.size());
    }

    public IteratorSTL<T> rBegin() {
        return new ReverseVectorIterator<T>(this.data, this.data.size() - 1);
    }

    public IteratorSTL<T> rEnd() {
        return new ReverseVectorIterator<T>(this.data, -1);
    }

    public void clear() {
        this.data.clear();
    }

    public int size() {
        return this.data.size();
    }

    public boolean empty() {
        return this.data.isEmpty();
    }

    public T get(int index) {
        return this.data.get(index);
    }

    public T front() {
        return this.data.get(0);
    }

    public T back() {
        return this.data.get(this.size() - 1);
    }

    public void setBack(T value) {
        this.data.set(this.size() - 1, value);
    }

    public void push_back(T value) {
        this.data.add(value);
    }

    public T pop_back() {
        return this.data.remove(this.size() - 1);
    }

    public void insert(int index, T value) {
        this.data.add(index, value);
    }

    public void appendAll(VectorSTL<T> vector) {
        this.data.addAll(vector.data);
    }

    public void insertAll(IteratorSTL<T> pos, VectorSTL<T> vector) {
        VectorIterator iter = (VectorIterator)pos;
        this.data.addAll(iter.getIndex(), vector.data);
    }

    public void insert(IteratorSTL<T> iterator, T value) {
        VectorIterator vectorIterator = (VectorIterator)iterator;
        vectorIterator.insert(value);
    }

    public void set(int index, T value) {
        this.data.set(index, value);
    }

    public void set(IteratorSTL<T> iter, T value) {
        VectorIterator listIter = (VectorIterator)iter;
        listIter.set(value);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof VectorSTL)) {
            return false;
        }
        VectorSTL other = (VectorSTL)obj;
        int size = this.data.size();
        if (size != other.data.size()) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            if (this.data.get(i).equals(other.data.get(i))) continue;
            return false;
        }
        return true;
    }

    public T erase(int index) {
        return this.data.remove(index);
    }

    public IteratorSTL<T> erase(IteratorSTL<T> it) {
        VectorIterator iter = (VectorIterator)it;
        int index = iter.index;
        if (index < 0 || index >= this.data.size()) {
            throw new IndexOutOfBoundsException();
        }
        this.data.remove(index);
        return it;
    }

    public void erase(IteratorSTL<T> start, IteratorSTL<T> end) {
        VectorIterator vstart = (VectorIterator)start;
        VectorIterator vend = (VectorIterator)end;
        int count = vend.index - vstart.index;
        if (count < 0) {
            throw new IllegalArgumentException("end is befor start");
        }
        List<T> subList = this.data.subList(vstart.index, vend.index);
        subList.clear();
    }

    public void sort() {
        if (this.data.isEmpty()) {
            return;
        }
        T item = this.data.get(0);
        if (!(item instanceof Comparable)) {
            throw new UnsupportedOperationException("T must be comparable");
        }
        Collections.sort(this.data, comparableComparator);
    }

    public void sort(Comparator<T> comparator) {
        Collections.sort(this.data, comparator);
    }

    public VectorSTL<T> copy() {
        return new VectorSTL<T>(this);
    }

    @Override
    public Iterator<T> iterator() {
        return this.data.iterator();
    }

    public IteratorSTL<T> lower_bound(T key, Comparator<T> comparator) {
        int i;
        for (i = Collections.binarySearch(this.data, key, comparator); i > 0 && this.data.get(i - 1).equals(key); --i) {
        }
        if (i < 0) {
            i = -i - 1;
        }
        return new VectorIterator<T>(this.data, i);
    }

    public IteratorSTL<T> lower_bound(T key) {
        if (!(key instanceof Comparable)) {
            throw new UnsupportedOperationException("T must be comparable");
        }
        return this.lower_bound(key, comparableComparator);
    }

    public IteratorSTL<T> upper_bound(T key) {
        if (!(key instanceof Comparable)) {
            throw new UnsupportedOperationException("T must be comparable");
        }
        return this.upper_bound(key, comparableComparator);
    }

    public IteratorSTL<T> upper_bound(T key, Comparator<T> comparator) {
        int i = Collections.binarySearch(this.data, key, comparator);
        if (i < 0) {
            i = -i - 1;
        }
        while (i < this.data.size() && this.data.get(i).equals(key)) {
            ++i;
        }
        return new VectorIterator<T>(this.data, i);
    }

    public static <K> void merge(VectorSTL<K> v1, VectorSTL<K> v2, VectorSTL<K> destination) {
        K value;
        if (v1.empty() && v2.empty()) {
            destination.clear();
            return;
        }
        K k = value = v1.empty() ? v2.get(0) : v1.get(0);
        if (!(value instanceof Comparable)) {
            throw new UnsupportedOperationException("T must be comparable");
        }
        VectorSTL.merge(v1, v2, destination, comparableComparator);
    }

    public static <K> void merge(VectorSTL<K> v1, VectorSTL<K> v2, VectorSTL<K> destination, Comparator<K> comparator) {
        destination.clear();
        destination.reserve(v1.size() + v2.size());
        IteratorSTL<K> it1 = v1.begin();
        IteratorSTL<K> it2 = v2.begin();
        while (!it1.isEnd() && !it2.isEnd()) {
            if (comparator.compare(it1.get(), it2.get()) <= 0) {
                destination.push_back(it1.get());
                it1.increment();
                continue;
            }
            destination.push_back(it2.get());
            it2.increment();
        }
        while (!it1.isEnd()) {
            destination.push_back(it1.get());
            it1.increment();
        }
        while (!it2.isEnd()) {
            destination.push_back(it2.get());
            it2.increment();
        }
    }

    public void resize(int size, T value) {
        while (this.size() > size) {
            this.pop_back();
        }
        while (this.size() < size) {
            this.push_back(value);
        }
    }

    public void insert(IteratorSTL<T> pos, T[] list) {
        VectorIterator iter = (VectorIterator)pos;
        this.data.addAll(iter.index, Arrays.asList(list));
    }

    public void assign(VectorSTL<T> otherVector) {
        this.data.clear();
        this.data.addAll(otherVector.data);
    }
}

