/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import java.io.IOException;
import java.io.Writer;
import java.util.Objects;

public class ImageSectionHeader {
    private AbstractPdb pdb;
    private String name;
    private long unionPAVS;
    private long virtualAddress;
    private long rawDataSize;
    private long rawDataPointer;
    private long relocationsPointer;
    private long lineNumbersPointer;
    private int numRelocations;
    private int numLineNumbers;
    private long characteristics;

    public ImageSectionHeader(AbstractPdb pdb) {
        Objects.requireNonNull(pdb, "pdb cannot be null");
        this.pdb = pdb;
    }

    public void parse(PdbByteReader reader) throws PdbException {
        if (reader.numRemaining() < 40) {
            throw new PdbException("Not enough data for ImageSectionHeader");
        }
        PdbByteReader nameReader = reader.getSubPdbByteReader(8);
        this.name = nameReader.parseNullTerminatedString(this.pdb.getPdbReaderOptions().getOneByteCharset());
        this.unionPAVS = reader.parseUnsignedIntVal();
        this.virtualAddress = reader.parseUnsignedIntVal();
        this.rawDataSize = reader.parseUnsignedIntVal();
        this.rawDataPointer = reader.parseUnsignedIntVal();
        this.relocationsPointer = reader.parseUnsignedIntVal();
        this.lineNumbersPointer = reader.parseUnsignedIntVal();
        this.numRelocations = reader.parseUnsignedShortVal();
        this.numLineNumbers = reader.parseUnsignedShortVal();
        this.characteristics = reader.parseUnsignedIntVal();
    }

    public String getName() {
        return this.name;
    }

    public long getUnionPAVS() {
        return this.unionPAVS;
    }

    public long getVirtualAddress() {
        return this.virtualAddress;
    }

    public long getRawDataSize() {
        return this.rawDataSize;
    }

    public long getRawDataPointer() {
        return this.rawDataPointer;
    }

    public long getRelocationsPointer() {
        return this.relocationsPointer;
    }

    public long getLineNumbersPointer() {
        return this.lineNumbersPointer;
    }

    public int getNumRelocations() {
        return this.numRelocations;
    }

    public int getNumLineNumbers() {
        return this.numLineNumbers;
    }

    public long getCharacteristics() {
        return this.characteristics;
    }

    void dump(Writer writer, int sectionNum) throws IOException {
        writer.write("ImageSectionHeader------------------------------------------\n");
        writer.write(String.format("Section Number: %04X\n", sectionNum));
        writer.write(String.format("name: %s\n", this.name));
        writer.write(String.format("unionPAVS: 0X%08X\n", this.unionPAVS));
        writer.write(String.format("virtualAddress: 0X%08X\n", this.virtualAddress));
        writer.write(String.format("rawDataSize: 0X%08X\n", this.rawDataSize));
        writer.write(String.format("rawDataPointer: 0X%08X\n", this.rawDataPointer));
        writer.write(String.format("relocationsPointer: 0X%08X\n", this.relocationsPointer));
        writer.write(String.format("lineNumbersPointer: 0X%08X\n", this.lineNumbersPointer));
        writer.write(String.format("numRelocations: 0X%04X\n", this.numRelocations));
        writer.write(String.format("numLineNumbers: 0X%04X\n", this.numLineNumbers));
        writer.write(String.format("characteristics: 0X%08X\n", this.characteristics));
        writer.write("End ImageSectionHeader--------------------------------------\n");
    }
}

