/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader;

import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbReaderUtils;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;

public class SegmentMapDescription {
    private int flags;
    private int ovl;
    private int group;
    private int frame;
    private int segNameIndex;
    private int classNameIndex;
    private long segOffset;
    private long segLength;

    public int getFlags() {
        return this.flags;
    }

    public int getOvl() {
        return this.ovl;
    }

    public int getGroup() {
        return this.group;
    }

    public int getFrame() {
        return this.frame;
    }

    public int getSegNameIndex() {
        return this.segNameIndex;
    }

    public int getClassNameIndex() {
        return this.classNameIndex;
    }

    public long getOffset() {
        return this.segOffset;
    }

    public long getSegmentOffset() {
        return this.segOffset;
    }

    public long getLength() {
        return this.segLength;
    }

    void deserialize(PdbByteReader substreamReader) throws PdbException {
        this.flags = substreamReader.parseUnsignedShortVal();
        this.ovl = substreamReader.parseUnsignedShortVal();
        this.group = substreamReader.parseUnsignedShortVal();
        this.frame = substreamReader.parseUnsignedShortVal();
        this.segNameIndex = substreamReader.parseUnsignedShortVal();
        this.classNameIndex = substreamReader.parseUnsignedShortVal();
        this.segOffset = substreamReader.parseUnsignedIntVal();
        this.segLength = substreamReader.parseUnsignedIntVal();
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        try {
            this.dump(writer);
            return writer.toString();
        }
        catch (IOException e) {
            return "Issue in " + this.getClass().getSimpleName() + " toString(): " + e.getMessage();
        }
    }

    void dump(Writer writer) throws IOException {
        PdbReaderUtils.dumpHead(writer, this);
        writer.write(String.format("\nflags: 0x%04x", this.flags));
        writer.write("\novl: " + this.ovl);
        writer.write("\ngroup: " + this.group);
        writer.write("\nframe: " + this.frame);
        writer.write("\nsegNameIndex: " + this.segNameIndex);
        writer.write("; classNameIndex: " + this.classNameIndex);
        writer.write("; segOffset: " + this.segOffset);
        writer.write("; segLength: " + this.segLength);
        writer.write("\n");
        PdbReaderUtils.dumpTail(writer, this);
    }
}

