/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.symbol;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordCategory;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.RegisterName;
import ghidra.app.util.bin.format.pdb2.pdbreader.StringParseType;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.LocalVariableAttributes;

public abstract class AbstractLocalOrParameterStoredInRegisterMsSymbol
extends AbstractMsSymbol {
    protected RecordNumber typeRecordNumber;
    protected LocalVariableAttributes attributes;
    protected int registerIndex;
    protected RegisterName registerName;
    protected String name;

    public AbstractLocalOrParameterStoredInRegisterMsSymbol(AbstractPdb pdb, PdbByteReader reader, StringParseType strType) throws PdbException {
        super(pdb, reader);
        this.typeRecordNumber = RecordNumber.parse(pdb, reader, RecordCategory.TYPE, 32);
        this.attributes = new LocalVariableAttributes(pdb, reader);
        this.registerIndex = reader.parseUnsignedShortVal();
        this.registerName = new RegisterName(pdb, this.registerIndex);
        this.name = reader.parseString(pdb, strType);
    }

    @Override
    public void emit(StringBuilder builder) {
        StringBuilder myBuilder = new StringBuilder();
        myBuilder.append(this.typeRecordNumber.getNumber());
        this.attributes.emit(myBuilder);
        builder.append(String.format("%s: %s, %s %s", this.getSymbolTypeName(), this.registerName.toString(), myBuilder.toString(), this.name));
    }
}

