/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.symbol;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RegisterName;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractDefinedSingleAddressRangeMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.RangeAttribute;

public class EnregisteredSymbolDARMsSymbol
extends AbstractDefinedSingleAddressRangeMsSymbol {
    public static final int PDB_ID = 4417;
    private int registerHoldingValueOfSymbol;
    private RegisterName registerHoldingValueRegisterName;
    private RangeAttribute rangeAttribute;

    public EnregisteredSymbolDARMsSymbol(AbstractPdb pdb, PdbByteReader reader) throws PdbException {
        super(pdb, reader);
        this.registerHoldingValueOfSymbol = reader.parseUnsignedShortVal();
        this.registerHoldingValueRegisterName = new RegisterName(pdb, this.registerHoldingValueOfSymbol);
        this.rangeAttribute = new RangeAttribute(reader);
        this.parseRangeAndGaps(reader);
    }

    public RegisterName getRegister() {
        return this.registerHoldingValueRegisterName;
    }

    public RangeAttribute getRangeAttribute() {
        return this.rangeAttribute;
    }

    @Override
    public int getPdbId() {
        return 4417;
    }

    @Override
    protected String getSymbolTypeName() {
        return "DEFRANGE_REGISTER";
    }

    @Override
    public void emit(StringBuilder builder) {
        builder.append(this.getSymbolTypeName());
        builder.append(":");
        builder.append(this.rangeAttribute);
        builder.append(" ");
        builder.append(this.registerHoldingValueRegisterName);
        this.emitRangeAndGaps(builder);
    }
}

