/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.type;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordCategory;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.StringParseType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractPointerMsType;

public class Pointer16MsType
extends AbstractPointerMsType {
    public static final int PDB_ID = 2;

    public Pointer16MsType(AbstractPdb pdb, PdbByteReader reader) throws PdbException {
        super(pdb, reader);
        this.parseAttributes(reader);
        this.underlyingRecordNumber = RecordNumber.parse(pdb, reader, RecordCategory.TYPE, 16);
        this.parseExtendedPointerInfo(reader, 16, StringParseType.StringSt);
    }

    @Override
    public int getPdbId() {
        return 2;
    }

    @Override
    protected void parseAttributes(PdbByteReader reader) throws PdbException {
        int attributes1 = reader.parseUnsignedByteVal();
        int attributes2 = reader.parseUnsignedByteVal();
        this.pointerType = AbstractPointerMsType.PointerType.fromValue(attributes1 & 0x1F);
        this.pointerMode = AbstractPointerMsType.MsPointerMode.fromValue((attributes1 >>= 5) & 7);
        this.isFlat = (attributes2 & 1) == 1;
        this.isVolatile = ((attributes2 >>= 1) & 1) == 1;
        this.isConst = ((attributes2 >>= 1) & 1) == 1;
        this.isUnaligned = ((attributes2 >>= 1) & 1) == 1;
    }

    @Override
    protected int getMySize() {
        return 2;
    }
}

