/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.classtype;

import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.pdb.classtype.VBTable;
import ghidra.app.util.pdb.classtype.VBTableEntry;
import ghidra.app.util.pdb.classtype.VirtualBaseTableEntry;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.gclass.ClassID;
import ghidra.program.model.gclass.ClassUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class VirtualBaseTable
implements VBTable {
    protected ClassID owner;
    protected List<ClassID> parentage;
    protected Integer userSpecifiedNumEntries;
    protected Long ptrOffsetInClass;
    protected int maxTableIndexSeen;
    protected Map<Integer, VirtualBaseTableEntry> entryByTableIndex;
    protected Map<Integer, Long> baseOffsetByTableIndex;
    private Structure tableStructure;
    private boolean isBuilt;

    public VirtualBaseTable(ClassID owner, List<ClassID> parentage) {
        this.owner = owner;
        this.parentage = new ArrayList<ClassID>(parentage);
        this.maxTableIndexSeen = -1;
        this.entryByTableIndex = new HashMap<Integer, VirtualBaseTableEntry>();
        this.baseOffsetByTableIndex = new HashMap<Integer, Long>();
    }

    protected abstract VirtualBaseTableEntry getNewEntry(ClassID var1);

    public void addEntry(int tableIndex, ClassID baseId) {
        VirtualBaseTableEntry entry = this.getNewEntry(baseId);
        this.entryByTableIndex.put(tableIndex, entry);
        this.maxTableIndexSeen = Integer.max(this.maxTableIndexSeen, tableIndex);
    }

    int getMaxTableIndex() {
        return this.maxTableIndexSeen;
    }

    public Map<Integer, VirtualBaseTableEntry> getEntriesByTableIndex() {
        return this.entryByTableIndex;
    }

    public VBTableEntry getEntry(int tableIndex) {
        return this.entryByTableIndex.get(tableIndex);
    }

    public abstract Long getBaseOffset(int var1) throws PdbException;

    public void setBaseClassId(int tableIndex, ClassID baseId) {
        VirtualBaseTableEntry entry = this.entryByTableIndex.get(tableIndex);
        if (entry == null) {
            entry = new VirtualBaseTableEntry(baseId);
            this.entryByTableIndex.put(tableIndex, entry);
        } else {
            entry.setClassId(baseId);
        }
        this.maxTableIndexSeen = Integer.max(this.maxTableIndexSeen, tableIndex);
    }

    public ClassID getBaseClassId(int tableIndex) throws PdbException {
        VBTableEntry entry = this.entryByTableIndex.get(tableIndex);
        if (entry == null) {
            return null;
        }
        this.maxTableIndexSeen = Integer.max(this.maxTableIndexSeen, tableIndex);
        return entry.getClassId();
    }

    public ClassID getOwner() {
        return this.owner;
    }

    public List<ClassID> getParentage() {
        return this.parentage;
    }

    public int getNumEntries() {
        return this.entryByTableIndex.size();
    }

    public int getUserSpecifiedNumEntries() {
        return this.userSpecifiedNumEntries;
    }

    public Long getPtrOffsetInClass() {
        return this.ptrOffsetInClass;
    }

    public void setOwner(ClassID ownerArg) {
        this.owner = ownerArg;
    }

    public void setParentage(List<ClassID> parentage) {
        this.parentage = parentage;
    }

    public void setNumEntries(Integer numEntriesArg) {
        this.userSpecifiedNumEntries = numEntriesArg;
    }

    public void setPtrOffsetInClass(Long offset) {
        this.ptrOffsetInClass = offset;
    }

    void emit(StringBuilder builder) {
        builder.append("VBT for the following parentage within: " + String.valueOf(this.owner));
        builder.append("\n");
        for (ClassID id : this.parentage) {
            builder.append("   " + String.valueOf(id));
            builder.append("\n");
        }
    }

    public Structure createDataType(DataTypeManager dtm, CategoryPath categoryPath) {
        if (!this.isBuilt) {
            this.build(dtm, categoryPath);
        }
        return this.tableStructure;
    }

    private void build(DataTypeManager dtm, CategoryPath categoryPath) {
        if (this.ptrOffsetInClass == null || this.maxTableIndexSeen == -1) {
            this.tableStructure = null;
            this.isBuilt = true;
            return;
        }
        String name = ClassUtils.getSpecialVxTableName((long)this.ptrOffsetInClass);
        DataType defaultEntry = ClassUtils.getVbtDefaultEntry((DataTypeManager)dtm);
        int tableNumEntries = this.userSpecifiedNumEntries != null ? this.userSpecifiedNumEntries : this.maxTableIndexSeen;
        StructureDataType dt = new StructureDataType(categoryPath, name, 0, dtm);
        int masterOrdinal = 0;
        for (Map.Entry<Integer, VirtualBaseTableEntry> mapEntry : this.entryByTableIndex.entrySet()) {
            int ordinal = mapEntry.getKey() - 1;
            VBTableEntry entry = mapEntry.getValue();
            while (masterOrdinal < ordinal) {
                dt.add(defaultEntry, "", "");
                ++masterOrdinal;
            }
            String comment = entry.getClassId().getSymbolPath().toString();
            dt.add(defaultEntry, "", comment);
            ++masterOrdinal;
        }
        while (masterOrdinal < tableNumEntries) {
            dt.add(defaultEntry, "", "");
            ++masterOrdinal;
        }
        dt.align(defaultEntry.getAlignedLength());
        dt.setToDefaultPacking();
        this.tableStructure = (Structure)dtm.resolve((DataType)dt, null);
        this.isBuilt = true;
    }
}

