/*
 * Decompiled with CFR 0.152.
 */
package help.validator;

import help.HelpBuildUtils;
import help.validator.location.HelpModuleLocation;
import help.validator.model.IMG;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import util.CollectionUtils;

public class UnusedHelpImageFileFinder {
    private static final String HELP_PATHS_OPTION = "-hp";
    private static final String DEBUG_SWITCH = "-debug";
    private static List<String> moduleHelpPaths = new ArrayList<String>();
    private static boolean debugEnabled = false;
    private SortedSet<Path> unusedFiles;

    public static void main(String[] args) {
        UnusedHelpImageFileFinder.parseArguments(args);
        List<HelpModuleLocation> helpCollections = UnusedHelpImageFileFinder.collectHelp();
        Collection<IMG> referencedIMGs = UnusedHelpImageFileFinder.getReferencedIMGs(helpCollections);
        UnusedHelpImageFileFinder.debug("Found " + referencedIMGs.size() + " image referenes from help files");
        Collection<Path> allImagesOnDisk = UnusedHelpImageFileFinder.getAllImagesOnDisk(helpCollections);
        UnusedHelpImageFileFinder.debug("Found " + allImagesOnDisk.size() + " image files in help directories");
        SortedSet<Path> unusedFiles = UnusedHelpImageFileFinder.getUnusedFiles(referencedIMGs, allImagesOnDisk);
        if (unusedFiles.size() == 0) {
            System.out.println("No unused image files found!");
            System.exit(0);
        }
        System.err.println("Found the following " + unusedFiles.size() + " unused images: ");
        for (Path file : unusedFiles) {
            System.err.println(file.toUri());
        }
    }

    public UnusedHelpImageFileFinder(Collection<HelpModuleLocation> helpCollections) {
        this(helpCollections, debugEnabled);
    }

    public UnusedHelpImageFileFinder(Collection<HelpModuleLocation> helpCollections, boolean debugEnabled) {
        UnusedHelpImageFileFinder.debugEnabled = debugEnabled;
        Collection<IMG> referencedIMGs = UnusedHelpImageFileFinder.getReferencedIMGs(helpCollections);
        UnusedHelpImageFileFinder.debug("Found " + referencedIMGs.size() + " image referenes from help files");
        Collection<Path> allImagesOnDisk = UnusedHelpImageFileFinder.getAllImagesOnDisk(helpCollections);
        UnusedHelpImageFileFinder.debug("Found " + allImagesOnDisk.size() + " image files in help directories");
        this.unusedFiles = UnusedHelpImageFileFinder.getUnusedFiles(referencedIMGs, allImagesOnDisk);
        UnusedHelpImageFileFinder.debug("Found " + this.unusedFiles.size() + " unused images");
    }

    public SortedSet<Path> getUnusedImages() {
        return new TreeSet<Path>(this.unusedFiles);
    }

    private static SortedSet<Path> getUnusedFiles(Collection<IMG> referencedIMGs, Collection<Path> imageFiles) {
        HashMap<Path, IMG> fileToIMGMap = new HashMap<Path, IMG>();
        for (IMG img : referencedIMGs) {
            fileToIMGMap.put(img.getImageFile(), img);
        }
        TreeSet<Path> set = new TreeSet<Path>((f1, f2) -> f1.toUri().toString().toLowerCase().compareTo(f2.toUri().toString().toLowerCase()));
        for (Path file : imageFiles) {
            IMG img = (IMG)fileToIMGMap.get(file);
            if (img != null || UnusedHelpImageFileFinder.isExcludedImageFile(file)) continue;
            set.add(file);
        }
        return set;
    }

    private static boolean isExcludedImageFile(Path file) {
        String absolutePath = file.toUri().toString().toLowerCase();
        return absolutePath.indexOf("help/shared/") != -1;
    }

    private static Collection<IMG> getReferencedIMGs(Collection<HelpModuleLocation> helpCollections) {
        HashSet<IMG> set = new HashSet<IMG>();
        for (HelpModuleLocation help : helpCollections) {
            Collection<IMG> IMGs = help.getAllIMGs();
            set.addAll(IMGs);
        }
        return set;
    }

    private static Collection<Path> getAllImagesOnDisk(Collection<HelpModuleLocation> helpDirectories) {
        ArrayList<Path> files = new ArrayList<Path>();
        for (HelpModuleLocation help : helpDirectories) {
            Path helpDir = help.getHelpLocation();
            UnusedHelpImageFileFinder.gatherImageFiles(helpDir, files);
        }
        return files;
    }

    private static void gatherImageFiles(Path file, final List<Path> files) {
        try {
            Files.walkFileTree(file, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
                    if (UnusedHelpImageFileFinder.isImageFile(path)) {
                        files.add(path);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static boolean isImageFile(Path file) {
        String filename = file.getFileName().toString().toLowerCase();
        return filename.endsWith(".png") || filename.endsWith(".gif") || filename.endsWith(".jpg");
    }

    private static List<HelpModuleLocation> collectHelp() {
        UnusedHelpImageFileFinder.debug("Parsing help dirs...");
        ArrayList<HelpModuleLocation> helpCollections = new ArrayList<HelpModuleLocation>(moduleHelpPaths.size());
        for (String helpDirName : moduleHelpPaths) {
            File helpDirectoryFile = null;
            try {
                helpDirectoryFile = new File(helpDirName).getCanonicalFile();
                UnusedHelpImageFileFinder.debug("\tadding help dir: " + String.valueOf(helpDirectoryFile));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (helpDirectoryFile == null || !helpDirectoryFile.isDirectory()) {
                UnusedHelpImageFileFinder.errorMessage("Help directory not found - skipping: " + helpDirName);
                continue;
            }
            HelpModuleLocation location = HelpBuildUtils.toLocation(helpDirectoryFile);
            if (location == null) continue;
            helpCollections.add(location);
        }
        return helpCollections;
    }

    private static void debug(String string) {
        if (debugEnabled) {
            System.out.println("[" + UnusedHelpImageFileFinder.class.getSimpleName() + "] " + string);
        }
    }

    private static void printUsage() {
        StringBuilder buffy = new StringBuilder();
        UnusedHelpImageFileFinder.errorMessage("Usage:\n");
        buffy.append("-hp path1[-hp path2 -hp path3 ...]> [-debug]");
        UnusedHelpImageFileFinder.errorMessage(buffy.toString());
    }

    private static void parseArguments(String[] args) {
        int i;
        List argList;
        int debugIndex;
        if (args.length == 0) {
            UnusedHelpImageFileFinder.errorMessage("Missing required arguments - must supply at least one module help path");
            UnusedHelpImageFileFinder.printUsage();
            System.exit(1);
        }
        if ((debugIndex = (argList = CollectionUtils.asList((Object[])args)).indexOf(DEBUG_SWITCH)) > -1) {
            debugEnabled = true;
            argList.remove(debugIndex);
        }
        TreeMap<Integer, String> mapped = new TreeMap<Integer, String>();
        for (i = 0; i < argList.size(); ++i) {
            mapped.put(i, (String)argList.get(i));
        }
        for (i = 0; i < argList.size(); ++i) {
            String opt = (String)argList.get(i);
            if (!opt.equals(HELP_PATHS_OPTION)) continue;
            if (i >= argList.size()) {
                UnusedHelpImageFileFinder.errorMessage("-hp requires an argument");
                UnusedHelpImageFileFinder.printUsage();
                System.exit(1);
            }
            mapped.remove(i);
            String paths = (String)mapped.remove(++i);
            if (StringUtils.isBlank((CharSequence)paths)) {
                UnusedHelpImageFileFinder.errorMessage("-hp requires an argument");
                UnusedHelpImageFileFinder.printUsage();
                System.exit(1);
            }
            for (String p : paths.split(File.pathSeparator)) {
                moduleHelpPaths.add(p);
            }
        }
        if (moduleHelpPaths.size() == 0) {
            UnusedHelpImageFileFinder.errorMessage("Missing molule help path(s) arguments - actual arguments:\n\t'" + String.valueOf(argList) + "'");
            UnusedHelpImageFileFinder.printUsage();
            System.exit(1);
        }
        if (!mapped.isEmpty()) {
            UnusedHelpImageFileFinder.errorMessage("Ignoring unknown arguments: " + String.valueOf(mapped.values()));
        }
    }

    private static void errorMessage(String message) {
        UnusedHelpImageFileFinder.errorMessage(message, null);
    }

    private static void errorMessage(String message, Throwable t) {
        System.err.println("[" + UnusedHelpImageFileFinder.class.getSimpleName() + "] " + message);
        if (t != null) {
            t.printStackTrace();
        }
    }
}

