/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yacron4j.persist.prevayler;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import org.prevayler.Prevayler;
import org.prevayler.PrevaylerFactory;
import org.prevayler.Transaction;
import org.rzo.yacron4j.persist.PersistManager;
import org.rzo.yacron4j.persist.prevayler.Root;
import org.rzo.yacron4j.persist.prevayler.ScheduledTransction;
import org.rzo.yacron4j.persist.prevayler.TerminatedTransaction;

public class PrevaylerPersistentManager
implements PersistManager {
    final Prevayler<Root> _prevayler;
    long _counter = 0L;
    final String _folder;
    FileLock _lck;

    public PrevaylerPersistentManager(String folder) throws Exception {
        this._folder = folder;
        this.lockFolder();
        this._prevayler = PrevaylerFactory.createPrevayler((Object)new Root(), (String)folder);
        this.takeSnapshot();
    }

    private void lockFolder() throws IOException {
        File f = new File(new File(this._folder), "prevayler.lck");
        if (!f.getParentFile().exists()) {
            f.getParentFile().mkdirs();
        }
        if (!f.exists()) {
            f.createNewFile();
        }
        f.deleteOnExit();
        RandomAccessFile raf = new RandomAccessFile(f, "rw");
        FileChannel fc = raf.getChannel();
        this._lck = fc.tryLock();
        if (this._lck == null) {
            throw new IOException("prevayler folder '" + this._folder + "' already locked");
        }
    }

    public void scheduled(String id, long schedule) {
        this._prevayler.execute((Transaction)new ScheduledTransction(id, schedule));
        if (this._counter++ > 5000L) {
            this.takeSnapshot();
        }
    }

    private void takeSnapshot() {
        try {
            File f = this._prevayler.takeSnapshot();
            this.cleanup(f);
            this._counter = 0L;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void cleanup(File f) {
        File[] files;
        long currentVersion = this.getVersion(f);
        File[] fileArray = files = new File(this._folder).listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.getName().endsWith(".journal") || file.getName().endsWith(".snapshot") && this.getVersion(file) < currentVersion) {
                file.delete();
            }
            ++n2;
        }
    }

    private long getVersion(File f) {
        String name = f.getName();
        String version = name.substring(0, name.indexOf(46));
        long result = Long.MAX_VALUE;
        try {
            result = Long.parseLong(version);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public void terminated(String id) {
        this._prevayler.execute((Transaction)new TerminatedTransaction(id));
        if (this._counter++ > 5000L) {
            this.takeSnapshot();
        }
    }

    public Long getSchedule(String id) {
        return ((Root)this._prevayler.prevalentSystem()).getSchedules().get(id);
    }
}

