/*
 * Decompiled with CFR 0.152.
 */
package ghidra.asm.wild.sem;

import ghidra.app.plugin.assembler.sleigh.expr.OperandValueSolver;
import ghidra.app.plugin.assembler.sleigh.sem.AbstractAssemblyTreeResolver;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyConstructorSemantic;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyOperandState;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyPatternBlock;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolvedError;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolvedPatterns;
import ghidra.app.plugin.assembler.sleigh.symbol.AssemblyTerminal;
import ghidra.app.plugin.processors.sleigh.expression.PatternExpression;
import ghidra.app.plugin.processors.sleigh.symbol.OperandSymbol;
import ghidra.asm.wild.sem.PatternUtils;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

public class WildAssemblyOperandState
extends AssemblyOperandState {
    protected final String wildcard;
    protected final Object choice;

    protected WildAssemblyOperandState(AbstractAssemblyTreeResolver<?> resolver, List<AssemblyConstructorSemantic> path, int shift, AssemblyTerminal terminal, long value, OperandSymbol opSym, String wildcard, Object choice) {
        super(resolver, path, shift, terminal, value, opSym);
        this.wildcard = Objects.requireNonNull(wildcard);
        this.choice = choice;
    }

    public int computeHash() {
        int result = super.computeHash();
        result *= 31;
        result += this.wildcard.hashCode();
        result *= 31;
        return result += this.choice.hashCode();
    }

    protected boolean wildPartsEqual(WildAssemblyOperandState that) {
        if (!this.partsEqual(that)) {
            return false;
        }
        if (!this.wildcard.equals(that.wildcard)) {
            return false;
        }
        return this.choice.equals(that.choice);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        WildAssemblyOperandState that = (WildAssemblyOperandState)((Object)obj);
        return this.wildPartsEqual(that);
    }

    public String toString() {
        return "WILD:" + super.toString();
    }

    protected Stream<AssemblyResolvedPatterns> resolve(AssemblyResolvedPatterns fromRight, Collection<AssemblyResolvedError> errors) {
        PatternExpression symExp = OperandValueSolver.getDefiningExpression((OperandSymbol)this.opSym);
        AssemblyPatternBlock location = PatternUtils.collectLocation(symExp).shift(this.shift);
        return super.resolve(fromRight, errors).map(PatternUtils::castWild).map(r -> r.withWildInfo(this.wildcard, this.path, location, symExp, this.choice));
    }
}

