/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.jparted.lib.fs.hfscommon;

import java.util.Date;
import org.catacombae.hfsexplorer.Util;
import org.catacombae.hfsexplorer.types.hfscommon.CommonHFSCatalogAttributes;
import org.catacombae.hfsexplorer.types.hfsplus.HFSPlusBSDInfo;
import org.catacombae.jparted.lib.fs.FSAttributes;
import org.catacombae.jparted.lib.fs.FSEntry;
import org.catacombae.jparted.lib.fs.WindowsFileAttributes;

class HFSCommonFSAttributes
extends FSAttributes {
    private final FSEntry parentEntry;
    private final CommonHFSCatalogAttributes attributes;
    private FSAttributes.POSIXFileAttributes posixAttributes = null;

    public HFSCommonFSAttributes(FSEntry parentEntry, CommonHFSCatalogAttributes attributes) {
        this.parentEntry = parentEntry;
        this.attributes = attributes;
    }

    public boolean hasPOSIXFileAttributes() {
        return this.attributes.hasPermissions();
    }

    public FSAttributes.POSIXFileAttributes getPOSIXFileAttributes() {
        if (this.attributes.hasPermissions()) {
            if (this.posixAttributes == null) {
                HFSPlusBSDInfo permissions = this.attributes.getPermissions();
                this.posixAttributes = new FSAttributes.DefaultPOSIXFileAttributes(Util.unsign(permissions.getOwnerID()), Util.unsign(permissions.getGroupID()), permissions.getFileMode());
            }
            return this.posixAttributes;
        }
        throw new UnsupportedOperationException("Not supported.");
    }

    public WindowsFileAttributes getWindowsFileAttributes() {
        throw new UnsupportedOperationException("Not supported.");
    }

    public Date getModifyDate() {
        return this.attributes.getContentModDateAsDate();
    }

    public boolean hasWindowsFileAttributes() {
        return false;
    }

    public boolean hasCreateDate() {
        return this.attributes.hasCreateDate();
    }

    public Date getCreateDate() {
        return this.attributes.getCreateDateAsDate();
    }

    public boolean hasModifyDate() {
        return this.attributes.hasContentModDate();
    }

    public boolean hasAttributeModifyDate() {
        return this.attributes.hasAttributeModDate();
    }

    public boolean hasAccessDate() {
        return this.attributes.hasAccessDate();
    }

    public Date getAccessDate() {
        return this.attributes.getAccessDateAsDate();
    }

    public boolean hasBackupDate() {
        return this.attributes.hasBackupDate();
    }

    public Date getBackupDate() {
        return this.attributes.getBackupDateAsDate();
    }

    public Date getAttributeModifyDate() {
        return this.attributes.getAttributeModDateAsDate();
    }
}

