/*
 * Decompiled with CFR 0.152.
 */
package ghidra;

import ghidra.GhidraApplicationLayout;
import ghidra.GhidraLaunchable;
import ghidra.framework.Application;
import ghidra.framework.ApplicationConfiguration;
import ghidra.framework.GhidraApplicationConfiguration;
import ghidra.framework.HeadlessGhidraApplicationConfiguration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Stream;
import jdk.jshell.tool.JavaShellToolBuilder;
import utility.application.ApplicationLayout;

public class JShellRun
implements GhidraLaunchable {
    public void launch(GhidraApplicationLayout layout, String[] args) throws Exception {
        HeadlessGhidraApplicationConfiguration configuration;
        if (Stream.of(args).anyMatch(a -> a.startsWith("--execution"))) {
            System.err.println("Ignoring --execution option. Overridden to local");
        }
        ArrayList<String> fullArgs = new ArrayList<String>();
        fullArgs.addAll(Arrays.asList(args));
        if (fullArgs.remove("--headless")) {
            configuration = new HeadlessGhidraApplicationConfiguration();
        } else {
            GhidraApplicationConfiguration gac = new GhidraApplicationConfiguration();
            gac.setShowSplashScreen(false);
            configuration = gac;
        }
        Application.initializeApplication((ApplicationLayout)layout, (ApplicationConfiguration)configuration);
        fullArgs.add("--execution=local");
        JavaShellToolBuilder.builder().start((String[])fullArgs.toArray(String[]::new));
    }
}

