/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.formats;

import ghidra.app.plugin.core.analysis.AnalysisWorker;
import ghidra.app.plugin.core.analysis.AutoAnalysisManager;
import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.MemoryByteProvider;
import ghidra.app.util.bin.format.mz.DOSHeader;
import ghidra.app.util.bin.format.pe.DataDirectory;
import ghidra.app.util.bin.format.pe.FileHeader;
import ghidra.app.util.bin.format.pe.NTHeader;
import ghidra.app.util.bin.format.pe.OptionalHeader;
import ghidra.app.util.bin.format.pe.PeUtils;
import ghidra.app.util.bin.format.pe.PortableExecutable;
import ghidra.app.util.bin.format.pe.SectionHeader;
import ghidra.app.util.bin.format.pe.debug.DebugCOFFSymbol;
import ghidra.app.util.importer.MessageLog;
import ghidra.framework.cmd.BinaryAnalysisCommand;
import ghidra.program.flatapi.FlatProgramAPI;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.List;

public class PortableExecutableBinaryAnalysisCommand
extends FlatProgramAPI
implements BinaryAnalysisCommand,
AnalysisWorker {
    private MessageLog messages = new MessageLog();

    @Override
    public boolean canApply(Program program) {
        try {
            MemoryByteProvider provider = MemoryByteProvider.createDefaultAddressSpaceByteProvider(program, false);
            BinaryReader reader = new BinaryReader(provider, !program.getLanguage().isBigEndian());
            DOSHeader dosHeader = new DOSHeader(reader);
            if (dosHeader.isDosSignature()) {
                reader.setPointerIndex(dosHeader.e_lfanew());
                short peMagic = reader.readNextShort();
                return (peMagic & 0xFFFF) == 17744;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @Override
    public boolean analysisWorkerCallback(Program program, Object workerContext, TaskMonitor monitor) throws Exception, CancelledException {
        MemoryByteProvider provider = MemoryByteProvider.createDefaultAddressSpaceByteProvider(program, false);
        PortableExecutable pe = new PortableExecutable(provider, PortableExecutable.SectionLayout.FILE);
        DOSHeader dos = pe.getDOSHeader();
        if (dos == null || dos.e_magic() != 23117) {
            this.messages.appendMsg("Not a binary PE program: DOS header not found.");
            return false;
        }
        NTHeader nt = pe.getNTHeader();
        if (nt == null) {
            this.messages.appendMsg("Not a binary PE program: NT header not found.");
            return false;
        }
        this.createDataTypes(pe);
        return true;
    }

    @Override
    public String getWorkerName() {
        return this.getName();
    }

    @Override
    public boolean applyTo(Program program, TaskMonitor monitor) throws Exception {
        this.set(program, monitor);
        AutoAnalysisManager aam = AutoAnalysisManager.getAnalysisManager(this.currentProgram);
        return aam.scheduleWorker(this, null, false, monitor);
    }

    @Override
    public String getName() {
        return "PE Header Annotation";
    }

    @Override
    public MessageLog getMessages() {
        return this.messages;
    }

    private boolean createDataTypes(PortableExecutable pe) throws Exception {
        DOSHeader dos = pe.getDOSHeader();
        NTHeader nt = pe.getNTHeader();
        if (nt == null) {
            return false;
        }
        this.processDOSHeader(dos);
        this.processNTHeader(dos, nt);
        this.processSections(nt);
        this.processDataDirectories(nt);
        this.processSymbols(nt.getFileHeader());
        return true;
    }

    private void processSymbols(FileHeader fileHeader) throws Exception {
        if (fileHeader.getPointerToSymbolTable() == 0) {
            return;
        }
        Address address = this.toAddr(fileHeader.getPointerToSymbolTable());
        List<DebugCOFFSymbol> symbols = fileHeader.getSymbols();
        for (DebugCOFFSymbol symbol : symbols) {
            if (symbol == null) continue;
            String comment = "Name: " + symbol.getName() + "\nStorage Class: " + symbol.getStorageClassAsString() + "\nType: " + symbol.getTypeAsString();
            this.setPlateComment(address, comment);
            DataType symbolDT = symbol.toDataType();
            Data data = this.createData(address, symbolDT);
            this.createFragment("COFF_Symbols", data.getMinAddress(), data.getLength());
            address = address.add((long)data.getLength());
        }
        this.processStringTable(address);
    }

    private void processStringTable(Address address) throws Exception {
        Data dwordData = this.createDWord(address);
        this.createFragment("StringTable", dwordData.getMinAddress(), dwordData.getLength());
        int usedBytes = dwordData.getLength();
        int totalBytes = this.getInt(address);
        Address stringAddress = address.add(4L);
        while (usedBytes < totalBytes && !this.monitor.isCancelled()) {
            Data stringData = this.createAsciiString(stringAddress);
            this.setEOLComment(stringAddress, "");
            this.createFragment("StringTable", stringData.getMinAddress(), stringData.getLength());
            usedBytes += stringData.getLength();
            stringAddress = stringAddress.add((long)stringData.getLength());
        }
    }

    private void processDOSHeader(DOSHeader dos) throws DuplicateNameException, Exception {
        DataType dosDT = dos.toDataType();
        Address dosStartAddr = this.toAddr(0);
        this.createData(dosStartAddr, dosDT);
        this.createFragment(dosDT.getName(), dosStartAddr, dosDT.getLength());
    }

    private void processNTHeader(DOSHeader dos, NTHeader nt) throws DuplicateNameException, IOException, Exception {
        DataType ntDT = nt.toDataType();
        Address ntStartAddr = this.toAddr(dos.e_lfanew());
        Address ntEndAddr = ntStartAddr.add((long)ntDT.getLength());
        this.clearListing(ntStartAddr, ntEndAddr);
        this.createData(ntStartAddr, ntDT);
        this.createFragment(ntDT.getName(), ntStartAddr, ntDT.getLength());
    }

    private void processDataDirectories(NTHeader nt) throws Exception {
        DataDirectory[] datadirs;
        MessageLog log = new MessageLog();
        OptionalHeader oh = nt.getOptionalHeader();
        for (DataDirectory datadir : datadirs = oh.getDataDirectories()) {
            if (datadir == null || datadir.getSize() == 0 || !datadir.hasParsedCorrectly()) continue;
            datadir.markup(this.currentProgram, true, this.monitor, log, nt);
            Address startAddr = PeUtils.getMarkupAddress(this.currentProgram, true, nt, datadir.getVirtualAddress());
            this.createFragment(datadir.getDirectoryName(), startAddr, datadir.getSize());
        }
        this.messages.appendMsg(log.toString());
    }

    private void processSections(NTHeader nt) throws Exception, DuplicateNameException, InvalidInputException {
        FileHeader fh = nt.getFileHeader();
        SectionHeader[] sections = fh.getSectionHeaders();
        int index = fh.getPointerToSections();
        for (SectionHeader section : sections) {
            DataType sectionDT = section.toDataType();
            Address sectionStartAddr = this.toAddr(index);
            this.createData(sectionStartAddr, sectionDT);
            this.createFragment(sectionDT.getName(), sectionStartAddr, sectionDT.getLength());
            this.setPlateComment(sectionStartAddr, section.toString());
            index += 40;
            if (section.getPointerToRawData() == 0 || section.getSizeOfRawData() == 0) continue;
            Address dataStartAddr = this.toAddr(section.getPointerToRawData());
            this.currentProgram.getSymbolTable().createLabel(dataStartAddr, section.getName(), SourceType.IMPORTED);
            this.createFragment(section.getName() + "_DATA", dataStartAddr, section.getSizeOfRawData());
        }
    }
}

