/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.memory;

import ghidra.framework.cmd.Command;
import ghidra.framework.store.LockException;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramFragment;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.mem.MemoryConflictException;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.RollbackException;

public abstract class AbstractAddMemoryBlockCmd
implements Command<Program> {
    protected String message;
    protected final String name;
    protected final String comment;
    protected final String source;
    protected final Address start;
    protected final long length;
    protected final boolean read;
    protected final boolean write;
    protected final boolean execute;
    protected final boolean isVolatile;
    protected final boolean isOverlay;
    private boolean isArtificial = false;

    AbstractAddMemoryBlockCmd(String name, String comment, String source, Address start, long length, boolean read, boolean write, boolean execute, boolean isVolatile, boolean isOverlay) {
        this.name = name;
        this.comment = comment;
        this.source = source;
        this.start = start;
        this.length = length;
        this.read = read;
        this.write = write;
        this.execute = execute;
        this.isVolatile = isVolatile;
        this.isOverlay = isOverlay;
    }

    public void setArtificial(boolean a) {
        this.isArtificial = a;
    }

    public String getStatusMsg() {
        return this.message;
    }

    public String getName() {
        return "Add Memory Block";
    }

    protected abstract MemoryBlock createMemoryBlock(Memory var1) throws LockException, MemoryConflictException, AddressOverflowException, CancelledException;

    public boolean applyTo(Program program) {
        try {
            Memory memory = program.getMemory();
            MemoryBlock block = this.createMemoryBlock(memory);
            block.setComment(this.comment);
            block.setRead(this.read);
            block.setWrite(this.write);
            block.setExecute(this.execute);
            block.setVolatile(this.isVolatile);
            block.setArtificial(this.isArtificial);
            block.setSourceName(this.source);
            this.renameFragment(program, block.getStart());
            return true;
        }
        catch (IllegalArgumentException e) {
            this.message = e.getMessage();
        }
        catch (AddressOverflowException e) {
            this.message = e.getMessage();
        }
        catch (MemoryConflictException e) {
            this.message = e.getMessage();
        }
        catch (IllegalStateException e) {
            this.message = e.getMessage();
        }
        catch (Throwable t) {
            this.message = "Create block failed";
            Msg.showError((Object)this, null, (String)"Create Block Failed", (Object)t.getMessage(), (Throwable)t);
        }
        throw new RollbackException(this.message);
    }

    private void renameFragment(Program program, Address blockStartAddr) {
        String[] treeNames;
        Listing listing = program.getListing();
        for (String treeName : treeNames = listing.getTreeNames()) {
            ProgramFragment frag = listing.getFragment(treeName, blockStartAddr);
            this.renameFragment(frag, this.name);
        }
    }

    private void renameFragment(ProgramFragment fragment, String fragmentName) {
        Object newName = fragmentName;
        int count = 1;
        while (!this.doRenameFragment(fragment, (String)newName)) {
            newName = fragmentName + "_" + count;
            ++count;
        }
    }

    private boolean doRenameFragment(ProgramFragment fragment, String fragmentName) {
        try {
            fragment.setName(fragmentName);
            return true;
        }
        catch (DuplicateNameException e) {
            return false;
        }
    }
}

