/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.merge.memory;

import docking.widgets.button.GRadioButton;
import ghidra.util.layout.PairLayout;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeListener;

class CommentsConflictPanel
extends JPanel {
    private JRadioButton latestRB;
    private JRadioButton myRB;
    private JRadioButton originalRB;
    private ButtonGroup group;
    private JTextField latestField;
    private JTextField myField;
    private JTextField origField;
    private ChangeListener listener;

    CommentsConflictPanel(ChangeListener listener) {
        this.listener = listener;
        this.create();
    }

    void setComments(String latestComment, String myComment, String origComment) {
        this.group.remove(this.latestRB);
        this.group.remove(this.myRB);
        this.group.remove(this.originalRB);
        this.latestRB.setSelected(false);
        this.myRB.setSelected(false);
        this.originalRB.setSelected(false);
        this.group.add(this.latestRB);
        this.group.add(this.myRB);
        this.group.add(this.originalRB);
        this.latestField.setText(latestComment);
        this.myField.setText(myComment);
        this.origField.setText(origComment);
    }

    int getSelectedOption() {
        if (this.latestRB.isSelected()) {
            return 0;
        }
        if (this.myRB.isSelected()) {
            return 1;
        }
        if (this.originalRB.isSelected()) {
            return 2;
        }
        return -1;
    }

    private void create() {
        this.setLayout((LayoutManager)new PairLayout(20, 5));
        this.group = new ButtonGroup();
        this.latestField = new JTextField(20);
        this.latestField.setEditable(false);
        this.myField = new JTextField(20);
        this.myField.setEditable(false);
        this.origField = new JTextField(20);
        this.origField.setEditable(false);
        this.add(this.createRadioButton(1));
        this.add(this.latestField);
        this.add(this.createRadioButton(2));
        this.add(this.myField);
        this.add(this.createRadioButton(3));
        this.add(this.origField);
    }

    private JRadioButton createRadioButton(int id) {
        String str = null;
        switch (id) {
            case 1: {
                str = "Latest";
                break;
            }
            case 2: {
                str = "Checked Out";
                break;
            }
            case 3: {
                str = "Original";
            }
        }
        GRadioButton rb = new GRadioButton("Use comments from " + str);
        rb.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    CommentsConflictPanel.this.listener.stateChanged(null);
                }
            }
        });
        if (id == 1) {
            this.latestRB = rb;
            this.latestRB.setName("Latest");
        } else if (id == 2) {
            this.myRB = rb;
            this.myRB.setName("Checked Out");
        } else {
            this.originalRB = rb;
            this.originalRB.setName("Original");
        }
        this.group.add((AbstractButton)rb);
        return rb;
    }
}

