/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.codebrowser;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryAccessException;
import java.util.Objects;

public record AddressRangeInfo(Address min, Address max, long size, boolean isSameByte, int numRefsTo, int numRefsFrom) {
    public static boolean isSameByteValue(Address min, Address max, Program program) {
        AddressSet range = new AddressSet(min, max);
        AddressSetView loadedAndInit = program.getMemory().getLoadedAndInitializedAddressSet();
        if (!range.intersects(loadedAndInit)) {
            return true;
        }
        if (!loadedAndInit.contains((AddressSetView)range)) {
            return false;
        }
        try {
            Byte firstByte = program.getMemory().getByte(min);
            Address addr = min.add(1L);
            while (addr.compareTo((Object)max) <= 0) {
                Byte val = program.getMemory().getByte(addr);
                if (!Objects.equals(val, firstByte)) {
                    return false;
                }
                addr = addr.add(1L);
            }
        }
        catch (MemoryAccessException e) {
            return false;
        }
        return true;
    }
}

