/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.codebrowser;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.Tool;
import docking.WindowPosition;
import docking.action.DockingActionIf;
import docking.action.ToggleDockingAction;
import docking.action.ToolBarData;
import docking.actions.PopupActionProvider;
import docking.dnd.DragGestureAdapter;
import docking.dnd.DragSrcAdapter;
import docking.dnd.Draggable;
import docking.dnd.DropTgtAdapter;
import docking.dnd.Droppable;
import docking.widgets.EventTrigger;
import docking.widgets.fieldpanel.FieldPanel;
import docking.widgets.fieldpanel.HoverHandler;
import docking.widgets.fieldpanel.internal.FieldPanelCoordinator;
import docking.widgets.fieldpanel.support.FieldLocation;
import docking.widgets.fieldpanel.support.Highlight;
import docking.widgets.fieldpanel.support.ViewerPosition;
import docking.widgets.tab.GTabPanel;
import generic.theme.GIcon;
import ghidra.app.context.ListingActionContext;
import ghidra.app.context.NavigatableContextAction;
import ghidra.app.nav.ListingPanelContainer;
import ghidra.app.nav.LocationMemento;
import ghidra.app.plugin.core.clipboard.CodeBrowserClipboardProvider;
import ghidra.app.plugin.core.codebrowser.CodeBrowserPluginInterface;
import ghidra.app.plugin.core.codebrowser.CodeViewerActionContext;
import ghidra.app.plugin.core.codebrowser.CodeViewerLocationMemento;
import ghidra.app.plugin.core.codebrowser.ListingMiddleMouseHighlightProvider;
import ghidra.app.plugin.core.codebrowser.OtherPanelContext;
import ghidra.app.plugin.core.codebrowser.actions.CloneCodeViewerAction;
import ghidra.app.plugin.core.codebrowser.actions.CollapseAllDataAction;
import ghidra.app.plugin.core.codebrowser.actions.ExpandAllDataAction;
import ghidra.app.plugin.core.codebrowser.actions.GotoNextFunctionAction;
import ghidra.app.plugin.core.codebrowser.actions.GotoPreviousFunctionAction;
import ghidra.app.plugin.core.codebrowser.actions.ToggleExpandCollapseDataAction;
import ghidra.app.plugin.core.codebrowser.hover.ListingHoverService;
import ghidra.app.plugin.core.progmgr.ProgramTabActionContext;
import ghidra.app.services.ClipboardService;
import ghidra.app.services.CoordinatedListingPanelListener;
import ghidra.app.services.ProgramManager;
import ghidra.app.services.ViewManagerService;
import ghidra.app.util.ListingHighlightProvider;
import ghidra.app.util.ProgramDropProvider;
import ghidra.app.util.SelectionTransferData;
import ghidra.app.util.SelectionTransferable;
import ghidra.app.util.viewer.field.ListingField;
import ghidra.app.util.viewer.format.FieldHeader;
import ghidra.app.util.viewer.format.FieldHeaderComp;
import ghidra.app.util.viewer.format.FieldHeaderLocation;
import ghidra.app.util.viewer.format.FormatManager;
import ghidra.app.util.viewer.listingpanel.AddressSetDisplayListener;
import ghidra.app.util.viewer.listingpanel.ListingModel;
import ghidra.app.util.viewer.listingpanel.ListingPanel;
import ghidra.app.util.viewer.listingpanel.MarginProvider;
import ghidra.app.util.viewer.listingpanel.OverviewProvider;
import ghidra.app.util.viewer.listingpanel.ProgramLocationListener;
import ghidra.app.util.viewer.listingpanel.ProgramSelectionListener;
import ghidra.app.util.viewer.listingpanel.StringSelectionListener;
import ghidra.app.util.viewer.multilisting.MultiListingLayoutModel;
import ghidra.app.util.viewer.util.FieldNavigator;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.NavigatableComponentProviderAdapter;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.util.DiffUtility;
import ghidra.program.util.MarkerLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramMemoryComparator;
import ghidra.program.util.ProgramSelection;
import ghidra.util.HelpLocation;
import ghidra.util.Swing;
import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CodeViewerProvider
extends NavigatableComponentProviderAdapter
implements ProgramLocationListener,
ProgramSelectionListener,
Draggable,
Droppable,
ChangeListener,
StringSelectionListener,
PopupActionProvider {
    private static final String OLD_NAME = "CodeBrowserPlugin";
    private static final String NAME = "Listing";
    private static final String TITLE = "Listing: ";
    private static final Icon LISTING_FORMAT_EXPAND_ICON = new GIcon("icon.plugin.codebrowser.format.expand");
    private static final Icon LISTING_FORMAT_COLLAPSE_ICON = new GIcon("icon.plugin.codebrowser.format.collapse");
    private static final Icon HOVER_ON_ICON = new GIcon("icon.plugin.codebrowser.hover.on");
    private static final Icon HOVER_OFF_ICON = new GIcon("icon.plugin.codebrowser.hover.off");
    private static final String HOVER_MODE = "Hover Mode";
    private static final String DIVIDER_LOCATION = "DividerLocation";
    private Map<Program, ListingHighlightProvider> programHighlighterMap = new HashMap<Program, ListingHighlightProvider>();
    private ProgramHighlighterProvider highlighterAdapter;
    private ListingPanel listingPanel;
    private CodeBrowserPluginInterface plugin;
    private Program program;
    private DragSource dragSource;
    private DragGestureAdapter dragGestureAdapter;
    private DragSrcAdapter dragSourceAdapter;
    private int dragAction = 2;
    private DropTgtAdapter dropTargetAdapter;
    private DataFlavor[] acceptableFlavors = new DataFlavor[0];
    private ProgramDropProvider[] dropProviders = new ProgramDropProvider[0];
    private ProgramDropProvider curDropProvider;
    private ToggleDockingAction toggleHoverAction;
    private ProgramLocation currentLocation;
    private ListingPanel otherPanel;
    private CoordinatedListingPanelListener coordinatedListingPanelListener;
    private FormatManager formatMgr;
    private FieldPanelCoordinator coordinator;
    private ProgramSelectionListener liveProgramSelectionListener = (selection, trigger) -> {
        this.liveSelection = selection;
        this.updateSubTitle();
    };
    private FocusingMouseListener focusingMouseListener;
    private CodeBrowserClipboardProvider codeViewerClipboardProvider;
    private ClipboardService clipboardService;
    private ListingPanelContainer decorationPanel;
    private CloneCodeViewerAction cloneCodeViewerAction;
    private ProgramSelection currentSelection;
    private ProgramSelection liveSelection;
    private ProgramSelection currentHighlight;
    private String currentStringSelection;
    private FieldNavigator fieldNavigator;
    private MultiListingLayoutModel multiModel;

    public CodeViewerProvider(CodeBrowserPluginInterface plugin, FormatManager formatMgr, boolean isConnected) {
        super(plugin.getTool(), NAME, plugin.getName(), CodeViewerActionContext.class);
        this.plugin = plugin;
        this.formatMgr = formatMgr;
        String owner = plugin.getName();
        ComponentProvider.registerProviderNameOwnerChange((String)OLD_NAME, (String)owner, (String)NAME, (String)owner);
        this.registerAdjustableFontId("font.listing.base");
        this.setConnected(isConnected);
        this.setIcon((Icon)new GIcon("icon.plugin.codebrowser.provider"));
        if (!isConnected) {
            this.setTransient();
        } else {
            this.addToToolbar();
        }
        this.setHelpLocation(new HelpLocation(OLD_NAME, "Code_Browser"));
        this.setDefaultWindowPosition(WindowPosition.RIGHT);
        this.listingPanel = new ListingPanel(formatMgr);
        this.listingPanel.enablePropertyBasedColorModel(true);
        this.decorationPanel = new ListingPanelContainer(this.listingPanel, isConnected);
        ListingMiddleMouseHighlightProvider listingHighlighter = this.createListingHighlighter(this.listingPanel, this.tool, this.decorationPanel);
        this.highlighterAdapter = new ProgramHighlighterProvider(listingHighlighter);
        this.listingPanel.addHighlightProvider(this.highlighterAdapter);
        this.setWindowMenuGroup(NAME);
        this.setIntraGroupPosition(WindowPosition.RIGHT);
        this.setTitle(isConnected ? TITLE : "[Listing: ]");
        this.fieldNavigator = new FieldNavigator((ServiceProvider)this.tool, this);
        this.listingPanel.addButtonPressedListener(this.fieldNavigator);
        this.addToTool();
        this.createActions();
        this.listingPanel.setProgramLocationListener(this);
        this.listingPanel.setProgramSelectionListener(this);
        this.listingPanel.setLiveProgramSelectionListener(this.liveProgramSelectionListener);
        this.listingPanel.setStringSelectionListener(this);
        this.listingPanel.addIndexMapChangeListener(this);
        this.codeViewerClipboardProvider = this.newClipboardProvider();
        this.tool.addPopupActionProvider((PopupActionProvider)this);
        this.setDefaultFocusComponent((Component)this.listingPanel.getFieldPanel());
    }

    protected CodeBrowserClipboardProvider newClipboardProvider() {
        return new CodeBrowserClipboardProvider(this.tool, (ComponentProvider)this);
    }

    public boolean isSnapshot() {
        return !this.isConnected();
    }

    public boolean isReadOnly() {
        return false;
    }

    private ListingMiddleMouseHighlightProvider createListingHighlighter(ListingPanel panel, PluginTool pluginTool, Component repaintComponent) {
        ListingMiddleMouseHighlightProvider listingHighlighter = new ListingMiddleMouseHighlightProvider(pluginTool, repaintComponent);
        panel.addButtonPressedListener(listingHighlighter);
        return listingHighlighter;
    }

    public void setClipboardService(ClipboardService service) {
        this.clipboardService = service;
        if (this.clipboardService != null) {
            this.clipboardService.registerClipboardContentProvider(this.codeViewerClipboardProvider);
        }
    }

    public String getWindowGroup() {
        if (this.isConnected()) {
            return "Core";
        }
        return "Core.disconnected";
    }

    public WindowPosition getIntraGroupPosition() {
        if (this.isConnected()) {
            return WindowPosition.TOP;
        }
        return WindowPosition.RIGHT;
    }

    public void closeComponent() {
        if (!this.isConnected()) {
            this.plugin.providerClosed(this);
            return;
        }
        boolean closedListing = false;
        if (this.otherPanel != null && this.coordinatedListingPanelListener != null) {
            closedListing = this.coordinatedListingPanelListener.listingClosed();
        }
        if (!closedListing) {
            this.tool.showComponentProvider((ComponentProvider)this, false);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.tool.removePopupActionProvider((PopupActionProvider)this);
        if (this.clipboardService != null) {
            this.clipboardService.deRegisterClipboardContentProvider(this.codeViewerClipboardProvider);
        }
        this.listingPanel.dispose();
        this.program = null;
        this.currentLocation = null;
        this.currentSelection = null;
        this.currentHighlight = null;
    }

    public JComponent getComponent() {
        return this.decorationPanel;
    }

    protected ListingActionContext newListingActionContext() {
        return new CodeViewerActionContext(this);
    }

    public ActionContext getActionContext(MouseEvent event) {
        GTabPanel tabPanel;
        Program tabValue;
        if (this.program == null) {
            return null;
        }
        if (event == null) {
            return this.newListingActionContext();
        }
        Object source = event.getSource();
        if (source == null || source == this.listingPanel.getFieldPanel()) {
            Point point = event.getPoint();
            ProgramLocation programLocation = this.listingPanel.getProgramLocation(point);
            if (programLocation == null) {
                return null;
            }
            return this.newListingActionContext();
        }
        FieldHeader headerPanel = this.listingPanel.getFieldHeader();
        if (headerPanel != null && source instanceof FieldHeaderComp) {
            FieldHeaderLocation fhLoc = headerPanel.getFieldHeaderLocation(event.getPoint());
            return this.createContext(fhLoc);
        }
        if (this.otherPanel != null && this.otherPanel.isAncestorOf((Component)source)) {
            Object obj = this.getContextForMarginPanels(this.otherPanel, event);
            if (obj != null) {
                return this.createContext(obj);
            }
            return new OtherPanelContext((ComponentProvider)this, this.program);
        }
        JComponent northPanel = this.decorationPanel.getNorthPanel();
        if (northPanel != null && northPanel.isAncestorOf((Component)source) && northPanel instanceof GTabPanel && (tabValue = (Program)(tabPanel = (GTabPanel)northPanel).getValueFor(event)) != null) {
            return new ProgramTabActionContext((ComponentProvider)this, tabValue, (Component)tabPanel);
        }
        return this.createContext(this.getContextForMarginPanels(this.listingPanel, event));
    }

    private Object getContextForMarginPanels(ListingPanel lp, MouseEvent event) {
        Object source = event.getSource();
        List<MarginProvider> marginProviders = lp.getMarginProviders();
        for (MarginProvider marginProvider : marginProviders) {
            MarkerLocation loc;
            JComponent c = marginProvider.getComponent();
            if (c != source || (loc = marginProvider.getMarkerLocation(event.getX(), event.getY())) == null) continue;
            if (lp == this.listingPanel) {
                return loc;
            }
            return source;
        }
        List<OverviewProvider> overviewProviders = lp.getOverviewProviders();
        for (OverviewProvider overviewProvider : overviewProviders) {
            JComponent c = overviewProvider.getComponent();
            if (c != source) continue;
            return source;
        }
        return null;
    }

    public int getDragAction() {
        return this.dragAction;
    }

    public DragSourceListener getDragSourceListener() {
        return this.dragSourceAdapter;
    }

    public Transferable getTransferable(Point p) {
        ProgramSelection ps = this.listingPanel.getProgramSelection();
        return new SelectionTransferable(new SelectionTransferData(ps, this.program.getDomainFile().getPathname()));
    }

    public boolean isStartDragOk(DragGestureEvent e) {
        if (this.program == null) {
            return false;
        }
        return this.listingPanel.isStartDragOk();
    }

    public void add(Object obj, DropTargetDropEvent event, DataFlavor f) {
        Point p = event.getLocation();
        ProgramLocation loc = this.listingPanel.getProgramLocation(p);
        CodeViewerActionContext context = new CodeViewerActionContext(this, loc);
        if (loc != null && this.curDropProvider != null) {
            this.curDropProvider.add(context, obj, f);
        }
    }

    public boolean isDropOk(DropTargetDragEvent e) {
        this.curDropProvider = null;
        Point p = e.getLocation();
        ProgramLocation loc = this.listingPanel.getProgramLocation(p);
        if (loc == null) {
            return false;
        }
        CodeViewerActionContext context = new CodeViewerActionContext(this, loc);
        for (ProgramDropProvider dropProvider : this.dropProviders) {
            if (!dropProvider.isDropOk(context, e)) continue;
            this.curDropProvider = dropProvider;
            return true;
        }
        return false;
    }

    @Override
    public void removeHighlightProvider(ListingHighlightProvider highlightProvider, Program highlightProgram) {
        this.programHighlighterMap.remove(highlightProgram);
        this.updateHighlightProvider();
    }

    @Override
    public void setHighlightProvider(ListingHighlightProvider highlightProvider, Program highlightProgram) {
        this.programHighlighterMap.put(highlightProgram, highlightProvider);
        this.updateHighlightProvider();
    }

    public void updateHighlightProvider() {
        this.listingPanel.getFieldPanel().repaint();
        if (this.otherPanel != null) {
            this.otherPanel.getFieldPanel().repaint();
        }
    }

    protected void doSetProgram(Program newProgram) {
        this.currentLocation = null;
        this.program = newProgram;
        this.updateTitle();
        this.listingPanel.setProgram(this.program);
        this.codeViewerClipboardProvider.setProgram(this.program);
        this.codeViewerClipboardProvider.setListingLayoutModel(this.listingPanel.getListingModel());
        if (this.coordinatedListingPanelListener != null) {
            this.coordinatedListingPanelListener.activeProgramChanged(newProgram);
        }
        this.contextChanged();
    }

    protected void updateTitle() {
        String subTitle = this.program == null ? "" : " " + this.program.getDomainFile().getName();
        String newTitle = TITLE + subTitle;
        if (!this.isConnected()) {
            newTitle = "[" + newTitle + "]";
        }
        this.setTitle(newTitle);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.codeViewerClipboardProvider.setListingLayoutModel(this.listingPanel.getListingModel());
    }

    private void createActions() {
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)new ToggleHeaderAction());
        this.toggleHoverAction = new ToggleHoverAction();
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)this.toggleHoverAction);
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)new ExpandAllDataAction(this));
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)new CollapseAllDataAction(this));
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)new ToggleExpandCollapseDataAction(this));
        this.cloneCodeViewerAction = new CloneCodeViewerAction(this.plugin.getName(), this);
        this.addLocalAction((DockingActionIf)this.cloneCodeViewerAction);
        NavigatableContextAction action = new GotoPreviousFunctionAction(this.tool, this.plugin.getName());
        this.tool.addAction((DockingActionIf)action);
        action = new GotoNextFunctionAction(this.tool, this.plugin.getName());
        this.tool.addAction((DockingActionIf)action);
    }

    void fieldOptionChanged(String fieldName, Object newValue) {
    }

    public ListingPanel getListingPanel() {
        return this.listingPanel;
    }

    protected void addProgramDropProvider(ProgramDropProvider dndProvider) {
        ArrayList<ProgramDropProvider> list = new ArrayList<ProgramDropProvider>(Arrays.asList(this.dropProviders));
        if (list.contains(dndProvider)) {
            return;
        }
        list.add(dndProvider);
        Collections.sort(list, (pdp1, pdp2) -> {
            int p1 = pdp1.getPriority();
            int p2 = pdp2.getPriority();
            return p2 - p1;
        });
        this.dropProviders = list.toArray(new ProgramDropProvider[list.size()]);
        if (this.dropTargetAdapter == null) {
            this.setUpDragDrop();
        } else {
            this.setAcceptableFlavors();
            this.dropTargetAdapter.setAcceptableDropFlavors(this.acceptableFlavors);
        }
    }

    @Override
    public void programLocationChanged(ProgramLocation loc, EventTrigger trigger) {
        if (this.plugin.isDisposed()) {
            return;
        }
        if (!loc.equals((Object)this.currentLocation)) {
            this.codeViewerClipboardProvider.setLocation(loc);
            this.currentLocation = loc;
            this.plugin.locationChanged(this, loc);
            this.contextChanged();
        }
    }

    @Override
    public void programSelectionChanged(ProgramSelection selection, EventTrigger trigger) {
        if (trigger != EventTrigger.GUI_ACTION) {
            return;
        }
        this.doSetSelection(selection);
    }

    @Override
    public void setSelection(ProgramSelection selection) {
        selection = selection == null ? new ProgramSelection() : this.adjustSelection(selection);
        this.doSetSelection(selection);
    }

    private void doSetSelection(ProgramSelection selection) {
        this.liveSelection = null;
        this.currentSelection = selection;
        this.codeViewerClipboardProvider.setSelection(this.currentSelection);
        this.listingPanel.setSelection(this.currentSelection);
        this.plugin.selectionChanged(this, this.currentSelection);
        this.contextChanged();
        this.updateSubTitle();
    }

    private void updateSubTitle() {
        ProgramSelection selection = this.liveSelection != null ? this.liveSelection : this.currentSelection;
        Object selectionInfo = null;
        if (!selection.isEmpty()) {
            long n = selection.getNumAddresses();
            String nString = Long.toString(n);
            selectionInfo = n == 1L ? "(1 address selected)" : "(" + nString + " addresses selected)";
        }
        this.setSubTitle((String)selectionInfo);
    }

    private ProgramSelection adjustSelection(ProgramSelection selection) {
        if (selection.isEmpty()) {
            return selection;
        }
        if (selection.getInteriorSelection() != null) {
            return selection;
        }
        if (this.program == null) {
            return selection;
        }
        AddressSet set = new AddressSet();
        AddressRangeIterator it = selection.getAddressRanges();
        while (it.hasNext()) {
            AddressRange range = (AddressRange)it.next();
            Address min = this.getMinCodeUnitAddress(range.getMinAddress());
            Address max = this.getMaxCodeUnitAddress(range.getMaxAddress());
            if (min == null || max == null || min.compareTo((Object)max) > 0) continue;
            set.addRange(min, max);
        }
        return new ProgramSelection((AddressSetView)set);
    }

    private Address getMinCodeUnitAddress(Address address) {
        Listing listing = this.program.getListing();
        CodeUnit cu = listing.getCodeUnitContaining(address);
        if (cu != null) {
            return cu.getMinAddress();
        }
        cu = listing.getCodeUnitAfter(address);
        if (cu != null) {
            return cu.getMinAddress();
        }
        return null;
    }

    private Address getMaxCodeUnitAddress(Address address) {
        Listing listing = this.program.getListing();
        CodeUnit cu = listing.getCodeUnitContaining(address);
        if (cu != null) {
            return cu.getMaxAddress();
        }
        cu = listing.getCodeUnitBefore(address);
        if (cu != null) {
            return cu.getMaxAddress();
        }
        return null;
    }

    @Override
    public void setHighlight(ProgramSelection highlight) {
        highlight = highlight == null ? new ProgramSelection() : this.adjustSelection(highlight);
        this.doSetHighlight(highlight);
    }

    @Override
    public boolean supportsHighlight() {
        return true;
    }

    private void doSetHighlight(ProgramSelection highlight) {
        this.listingPanel.setHighlight(highlight);
        this.currentHighlight = highlight;
        this.plugin.highlightChanged(this, highlight);
        this.contextChanged();
    }

    @Override
    public void setStringSelection(String string) {
        this.currentStringSelection = string;
        this.codeViewerClipboardProvider.setStringContent(string);
        this.contextChanged();
    }

    public String getStringSelection() {
        return this.codeViewerClipboardProvider.getStringContent();
    }

    private void setUpDragDrop() {
        this.setUpDrop();
        this.dragSource = DragSource.getDefaultDragSource();
        this.dragGestureAdapter = new DragGestureAdapter((Draggable)this);
        this.dragSourceAdapter = new DragSrcAdapter((Draggable)this);
        this.dragSource.createDefaultDragGestureRecognizer((Component)this.listingPanel.getFieldPanel(), this.dragAction, (DragGestureListener)this.dragGestureAdapter);
    }

    private void setUpDrop() {
        this.setAcceptableFlavors();
        this.dropTargetAdapter = new DropTgtAdapter((Droppable)this, 3, this.acceptableFlavors);
        new DropTarget((Component)this.listingPanel.getFieldPanel(), 3, (DropTargetListener)this.dropTargetAdapter, true);
    }

    private void setAcceptableFlavors() {
        HashSet<DataFlavor> flavors = new HashSet<DataFlavor>();
        for (ProgramDropProvider dropProvider : this.dropProviders) {
            DataFlavor[] dfs;
            for (DataFlavor df : dfs = dropProvider.getDataFlavors()) {
                flavors.add(df);
            }
        }
        this.acceptableFlavors = new DataFlavor[flavors.size()];
        flavors.toArray(this.acceptableFlavors);
    }

    boolean setLocation(ProgramLocation location) {
        ViewManagerService viewManager;
        if (!this.listingPanel.goTo(location, true) && (viewManager = this.plugin.getViewManager(this)) != null) {
            AddressSetView newView = viewManager.addToView(location);
            this.listingPanel.setView(newView);
            if (!this.listingPanel.goTo(location, true)) {
                return false;
            }
            if (this.otherPanel != null) {
                this.otherPanel.setView(newView);
                this.otherPanel.goTo(location, true);
            }
        }
        this.currentLocation = this.listingPanel.getProgramLocation();
        this.codeViewerClipboardProvider.setLocation(location);
        return true;
    }

    protected String computePanelTitle(Program panelProgram) {
        return panelProgram.getDomainFile().toString();
    }

    public void setOtherPanel(ListingPanel lp) {
        String myName;
        Program myProgram = this.listingPanel.getListingModel().getProgram();
        Program otherProgram = lp.getListingModel().getProgram();
        String otherName = myName = "<EMPTY>";
        if (myProgram != null) {
            myName = this.computePanelTitle(myProgram);
        }
        if (otherProgram != null) {
            otherName = this.computePanelTitle(otherProgram);
        }
        if (this.otherPanel != null) {
            this.removeHoverServices(this.otherPanel);
        }
        this.otherPanel = lp;
        AddressSet viewAddrs = ProgramMemoryComparator.getCombinedAddresses(myProgram, otherProgram);
        this.decorationPanel.setOtherPanel(lp, myName, otherName);
        this.multiModel = new MultiListingLayoutModel(this.formatMgr, new Program[]{myProgram, otherProgram}, (AddressSetView)viewAddrs);
        ListingModel myAlignedModel = this.multiModel.getAlignedModel(0);
        ListingModel otherAlignedModel = this.multiModel.getAlignedModel(1);
        this.listingPanel.setListingModel(myAlignedModel);
        lp.setListingModel(otherAlignedModel);
        this.coordinator = new FieldPanelCoordinator(new FieldPanel[]{this.listingPanel.getFieldPanel(), lp.getFieldPanel()});
        this.addHoverServices(this.otherPanel);
        HoverHandler hoverHandler = this.listingPanel.getFieldPanel().getHoverHandler();
        this.otherPanel.setHoverMode(hoverHandler != null && hoverHandler.isEnabled());
    }

    public ListingPanel getOtherPanel() {
        return this.otherPanel;
    }

    public void clearPanel() {
        if (this.otherPanel != null) {
            this.removeHoverServices(this.otherPanel);
            this.programSelectionChanged(new ProgramSelection(), EventTrigger.GUI_ACTION);
            FieldPanel fp = this.listingPanel.getFieldPanel();
            FieldLocation loc = fp.getCursorLocation();
            ViewerPosition vp = fp.getViewerPosition();
            this.listingPanel.setProgram(this.listingPanel.getProgram());
            this.coordinator.remove(this.otherPanel.getFieldPanel());
            this.coordinator.remove(this.listingPanel.getFieldPanel());
            this.coordinator = null;
            this.otherPanel = null;
            this.decorationPanel.clearOtherPanel();
            fp.setViewerPosition(vp.getIndex(), vp.getXOffset(), vp.getYOffset());
            fp.setCursorPosition(loc.getIndex(), loc.fieldNum, loc.row, loc.col);
            this.multiModel = null;
        }
    }

    private void addHoverServices(ListingPanel panel) {
        ListingHoverService[] hoverServices;
        for (ListingHoverService hoverService : hoverServices = (ListingHoverService[])this.tool.getServices(ListingHoverService.class)) {
            panel.addHoverService(hoverService);
        }
    }

    private void removeHoverServices(ListingPanel panel) {
        ListingHoverService[] hoverServices;
        for (ListingHoverService hoverService : hoverServices = (ListingHoverService[])this.tool.getServices(ListingHoverService.class)) {
            panel.removeHoverService(hoverService);
        }
    }

    public void setNorthComponent(JComponent comp) {
        this.decorationPanel.setNorthPanel(comp);
    }

    void saveState(SaveState saveState) {
        saveState.putInt(DIVIDER_LOCATION, this.getListingPanel().getDividerLocation());
        saveState.putBoolean(HOVER_MODE, this.toggleHoverAction.isSelected());
    }

    void readState(SaveState saveState) {
        this.getListingPanel().setDividerLocation(saveState.getInt(DIVIDER_LOCATION, 70));
        this.toggleHoverAction.setSelected(saveState.getBoolean(HOVER_MODE, true));
    }

    private void setHoverEnabled(boolean enabled) {
        this.getListingPanel().setHoverMode(enabled);
        if (this.otherPanel != null) {
            this.otherPanel.setHoverMode(enabled);
        }
    }

    public void setCoordinatedListingPanelListener(CoordinatedListingPanelListener listener) {
        this.coordinatedListingPanelListener = listener;
    }

    @Override
    public ProgramLocation getLocation() {
        if (this.otherPanel != null && this.otherPanel.getFieldPanel().isFocused()) {
            return this.otherPanel.getProgramLocation();
        }
        return this.currentLocation;
    }

    @Override
    public ProgramSelection getSelection() {
        if (this.otherPanel != null && this.otherPanel.getFieldPanel().isFocused()) {
            return this.otherPanel.getProgramSelection();
        }
        return this.currentSelection;
    }

    @Override
    public ProgramSelection getHighlight() {
        if (this.otherPanel != null && this.otherPanel.getFieldPanel().isFocused()) {
            return this.otherPanel.getProgramHighlight();
        }
        return this.currentHighlight;
    }

    @Override
    public String getTextSelection() {
        return this.currentStringSelection;
    }

    @Override
    public Icon getNavigatableIcon() {
        return this.getIcon();
    }

    @Override
    public Program getProgram() {
        return this.program;
    }

    @Override
    public LocationMemento getMemento() {
        int cursorOffset = this.listingPanel.getFieldPanel().getCursorOffset();
        return new CodeViewerLocationMemento(this.program, this.currentLocation, cursorOffset);
    }

    @Override
    public void setMemento(LocationMemento memento) {
        CodeViewerLocationMemento cvMemento = (CodeViewerLocationMemento)memento;
        int cursorOffset = cvMemento.getCursorOffset();
        this.listingPanel.getFieldPanel().positionCursor(cursorOffset);
    }

    @Override
    public boolean goTo(Program gotoProgram, ProgramLocation location) {
        if (gotoProgram != this.program) {
            if (!this.isConnected()) {
                this.tool.setStatusInfo("Program location not applicable for this provider!");
                return false;
            }
            ProgramManager programManagerService = (ProgramManager)this.tool.getService(ProgramManager.class);
            if (programManagerService != null) {
                programManagerService.setCurrentProgram(gotoProgram);
            }
        }
        this.setLocation(location);
        return true;
    }

    @Override
    public void writeDataState(SaveState saveState) {
        super.writeDataState(saveState);
        this.writeLocationState(saveState);
    }

    private void writeLocationState(SaveState saveState) {
        if (this.currentLocation != null) {
            this.currentLocation.saveState(saveState);
        }
        ViewerPosition vp = this.listingPanel.getFieldPanel().getViewerPosition();
        saveState.putInt("INDEX", vp.getIndexAsInt());
        saveState.putInt("Y_OFFSET", vp.getYOffset());
    }

    @Override
    public void readDataState(SaveState saveState) {
        super.readDataState(saveState);
        this.readLocationState(saveState);
    }

    private void readLocationState(SaveState saveState) {
        int index = saveState.getInt("INDEX", 0);
        int yOffset = saveState.getInt("Y_OFFSET", 0);
        ViewerPosition vp = new ViewerPosition(index, 0, yOffset);
        this.listingPanel.getFieldPanel().setViewerPosition(vp.getIndex(), vp.getXOffset(), vp.getYOffset());
        if (this.program != null) {
            this.currentLocation = ProgramLocation.getLocation((Program)this.program, (SaveState)saveState);
            if (this.currentLocation != null) {
                this.setLocation(this.currentLocation);
            }
        }
    }

    public void cloneWindow() {
        CodeViewerProvider newProvider = this.plugin.createNewDisconnectedProvider();
        ViewerPosition vp = this.listingPanel.getFieldPanel().getViewerPosition();
        Swing.runLater(() -> {
            newProvider.doSetProgram(this.program);
            newProvider.listingPanel.getFieldPanel().setViewerPosition(vp.getIndex(), vp.getXOffset(), vp.getYOffset());
            newProvider.setLocation(this.currentLocation);
        });
    }

    public void selectAll() {
        this.listingPanel.getFieldPanel().requestFocus();
        ProgramSelection sel = new ProgramSelection(this.listingPanel.getAddressIndexMap().getOriginalAddressSet());
        this.doSetSelection(sel);
    }

    public void selectComplement() {
        AddressSet complement = this.listingPanel.selectComplement();
        ProgramSelection sel = new ProgramSelection((AddressSetView)complement);
        this.doSetSelection(sel);
    }

    protected FieldNavigator getFieldNavigator() {
        return this.fieldNavigator;
    }

    void setView(AddressSetView view) {
        AddressSetView adjustedView = view;
        if (this.multiModel != null) {
            Program otherProgram = this.otherPanel.getProgram();
            Memory memory = this.program.getMemory();
            if (view.contains((AddressSetView)memory)) {
                adjustedView = ProgramMemoryComparator.getCombinedAddresses(this.program, otherProgram);
            }
            this.multiModel.setAddressSet(adjustedView);
            AddressSet diffAddrs = DiffUtility.getCompatibleAddressSet(adjustedView, otherProgram);
            this.otherPanel.setView((AddressSetView)diffAddrs);
        }
        this.listingPanel.setView(adjustedView);
    }

    public List<DockingActionIf> getPopupActions(Tool dt, ActionContext context) {
        if (context.getComponentProvider() == this) {
            return this.listingPanel.getHeaderActions(this.getOwner());
        }
        return null;
    }

    public void addDisplayListener(AddressSetDisplayListener listener) {
        this.listingPanel.addDisplayListener(listener);
    }

    public void removeDisplayListener(AddressSetDisplayListener listener) {
        this.listingPanel.removeDisplayListener(listener);
    }

    private synchronized void createFocusingMouseListener() {
        if (this.focusingMouseListener == null) {
            this.focusingMouseListener = new FocusingMouseListener();
        }
    }

    public void addOverviewProvider(OverviewProvider overviewProvider) {
        this.createFocusingMouseListener();
        JComponent component = overviewProvider.getComponent();
        component.removeMouseListener(this.focusingMouseListener);
        component.addMouseListener(this.focusingMouseListener);
        overviewProvider.setNavigatable(this);
        this.getListingPanel().addOverviewProvider(overviewProvider);
    }

    public void addMarginProvider(MarginProvider marginProvider) {
        this.createFocusingMouseListener();
        JComponent component = marginProvider.getComponent();
        component.removeMouseListener(this.focusingMouseListener);
        component.addMouseListener(this.focusingMouseListener);
        this.getListingPanel().addMarginProvider(marginProvider);
    }

    public void removeOverviewProvider(OverviewProvider overviewProvider) {
        JComponent component = overviewProvider.getComponent();
        component.removeMouseListener(this.focusingMouseListener);
        this.getListingPanel().removeOverviewProvider(overviewProvider);
    }

    public void removeMarginProvider(MarginProvider marginProvider) {
        JComponent component = marginProvider.getComponent();
        component.removeMouseListener(this.focusingMouseListener);
        this.getListingPanel().removeMarginProvider(marginProvider);
    }

    private class ProgramHighlighterProvider
    implements ListingHighlightProvider {
        private final ListingMiddleMouseHighlightProvider listingHighlighter;

        ProgramHighlighterProvider(ListingMiddleMouseHighlightProvider listingHighlighter) {
            this.listingHighlighter = listingHighlighter;
        }

        @Override
        public Highlight[] createHighlights(String text, ListingField field, int cursorTextOffset) {
            Highlight[] highlights;
            ArrayList<Highlight> list = new ArrayList<Highlight>();
            ListingHighlightProvider currentExternalHighligter = CodeViewerProvider.this.programHighlighterMap.get(CodeViewerProvider.this.program);
            if (currentExternalHighligter != null) {
                for (Highlight highlight : highlights = currentExternalHighligter.createHighlights(text, field, cursorTextOffset)) {
                    list.add(highlight);
                }
            }
            for (Highlight highlight : highlights = this.listingHighlighter.createHighlights(text, field, cursorTextOffset)) {
                list.add(highlight);
            }
            return list.toArray(new Highlight[list.size()]);
        }
    }

    private class ToggleHeaderAction
    extends ToggleDockingAction {
        ToggleHeaderAction() {
            super("Toggle Header", CodeViewerProvider.this.plugin.getName());
            this.setEnabled(true);
            this.setToolBarData(new ToolBarData(LISTING_FORMAT_EXPAND_ICON, "zzz"));
            this.setDescription("Edit the Listing fields");
        }

        public void actionPerformed(ActionContext context) {
            boolean show = !CodeViewerProvider.this.listingPanel.isHeaderShowing();
            CodeViewerProvider.this.listingPanel.showHeader(show);
            this.getToolBarData().setIcon(show ? LISTING_FORMAT_COLLAPSE_ICON : LISTING_FORMAT_EXPAND_ICON);
        }
    }

    private class ToggleHoverAction
    extends ToggleDockingAction {
        ToggleHoverAction() {
            super("Toggle Mouse Hover Popups", CodeViewerProvider.this.getOwner());
            this.setEnabled(true);
            this.setToolBarData(new ToolBarData(HOVER_ON_ICON, "yyyz"));
            this.setSelected(true);
            this.setHelpLocation(new HelpLocation(CodeViewerProvider.OLD_NAME, "Hover"));
            this.setHover(true);
        }

        public void actionPerformed(ActionContext context) {
            this.setHover(this.isSelected());
        }

        private void setHover(boolean enabled) {
            this.getToolBarData().setIcon(enabled ? HOVER_ON_ICON : HOVER_OFF_ICON);
            CodeViewerProvider.this.setHoverEnabled(enabled);
        }
    }

    private class FocusingMouseListener
    extends MouseAdapter {
        private FocusingMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            CodeViewerProvider.this.getListingPanel().getFieldPanel().requestFocus();
        }
    }
}

