/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.codebrowser.actions;

import docking.action.KeyBindingData;
import docking.action.MenuData;
import ghidra.app.context.ProgramLocationActionContext;
import ghidra.app.context.ProgramLocationContextAction;
import ghidra.app.plugin.core.codebrowser.CodeViewerProvider;
import ghidra.app.util.viewer.listingpanel.ListingModel;
import ghidra.app.util.viewer.listingpanel.ListingPanel;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.listing.Data;
import ghidra.program.util.ProgramLocation;
import ghidra.util.HelpLocation;

public class ToggleExpandCollapseDataAction
extends ProgramLocationContextAction {
    private CodeViewerProvider provider;

    public ToggleExpandCollapseDataAction(CodeViewerProvider provider) {
        super("Toggle Expand/Collapse Data", provider.getOwner());
        this.provider = provider;
        this.setPopupMenuData(new MenuData(new String[]{"Toggle Expand/Collapse Data"}, null, "Structure"));
        this.setKeyBindingData(new KeyBindingData(' ', 0));
        this.setHelpLocation(new HelpLocation("CodeBrowserPlugin", "ExpandCollapseActions"));
        this.setDescription("Opens or closes the component data for this location or if on a non-component data in another data component, then closes the parent component.");
        this.setEnabled(true);
    }

    @Override
    protected boolean isEnabledForContext(ProgramLocationActionContext context) {
        Data cursorData = DataUtilities.getDataAtLocation((ProgramLocation)context.getLocation());
        return cursorData != null && (cursorData.getNumComponents() > 0 || cursorData.getParent() != null);
    }

    @Override
    protected void actionPerformed(ProgramLocationActionContext context) {
        ProgramLocation location;
        Data cursorData;
        Data actionData;
        ListingPanel listingPanel = this.provider.getListingPanel();
        ListingModel layoutModel = listingPanel.getListingModel();
        boolean collapsing = layoutModel.isOpen(actionData = (cursorData = DataUtilities.getDataAtLocation((ProgramLocation)(location = context.getLocation()))).getNumComponents() > 0 ? cursorData : cursorData.getParent());
        if (collapsing && cursorData != actionData) {
            ProgramLocation newLoc = new ProgramLocation(context.getProgram(), actionData.getAddress(), actionData.getComponentPath(), null, 0, 0, 0);
            listingPanel.goTo(newLoc);
        }
        layoutModel.toggleOpen(actionData);
    }
}

