/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.colorizer;

import docking.options.editor.GhidraColorChooser;
import generic.theme.GColor;
import generic.theme.GThemeDefaults;
import ghidra.app.plugin.core.colorizer.ColorizingService;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.database.IntRangeMap;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.util.ColorUtils;
import ghidra.util.exception.DuplicateNameException;
import java.awt.Color;
import java.util.Collections;
import java.util.List;

class ColorizingServiceProvider
implements ColorizingService {
    private static final Color DEFAULT_COLOR = new GColor("color.bg.plugin.colorizer.default");
    static final String COLOR_CHOOSER_TITLE = "Please Select Background Color";
    private final PluginTool tool;
    private GhidraColorChooser colorChooser;
    private List<Color> savedColorHistory;
    private Program program;

    ColorizingServiceProvider(PluginTool tool) {
        this.tool = tool;
    }

    void setProgram(Program program) {
        this.program = program;
    }

    @Override
    public Color getMostRecentColor() {
        List<Color> recentColors = this.getRecentColors();
        if (recentColors != null && recentColors.size() > 0) {
            return recentColors.get(0);
        }
        return DEFAULT_COLOR;
    }

    @Override
    public List<Color> getRecentColors() {
        List colorHistory;
        if (this.colorChooser != null && (colorHistory = this.colorChooser.getColorHistory()).size() > 0) {
            return colorHistory;
        }
        if (this.savedColorHistory == null) {
            return Collections.emptyList();
        }
        return this.savedColorHistory;
    }

    void setColorHistory(List<Color> colorHistory) {
        this.savedColorHistory = colorHistory;
    }

    List<Color> getColorHistory() {
        if (this.colorChooser == null) {
            return null;
        }
        return this.colorChooser.getColorHistory();
    }

    @Override
    public Color getColorFromUser(Color suggestedColor) {
        if (this.colorChooser == null) {
            this.colorChooser = new GhidraColorChooser((Color)(suggestedColor == null ? GThemeDefaults.Colors.Palette.WHITE : suggestedColor));
            this.colorChooser.setTitle(COLOR_CHOOSER_TITLE);
            if (this.savedColorHistory != null) {
                this.colorChooser.setColorHistory(this.savedColorHistory);
            }
        }
        Color chosenColor = this.colorChooser.showDialog(null);
        this.maybeNotifyConfigChanged(suggestedColor, chosenColor);
        return chosenColor;
    }

    private void maybeNotifyConfigChanged(Color originalColor, Color chosenColor) {
        if (chosenColor == null) {
            return;
        }
        if (originalColor != null && originalColor.equals(chosenColor)) {
            return;
        }
        this.tool.setConfigChanged(true);
    }

    @Override
    public void setBackgroundColor(Address min, Address max, Color c) {
        IntRangeMap map = this.getColorRangeMap(true);
        if (map != null) {
            map.setValue(min, max, c.getRGB());
        }
    }

    @Override
    public void setBackgroundColor(AddressSetView set, Color c) {
        IntRangeMap map = this.getColorRangeMap(true);
        if (map != null) {
            map.setValue(set, c.getRGB());
        }
    }

    @Override
    public Color getBackgroundColor(Address address) {
        Integer rgba;
        IntRangeMap map = this.getColorRangeMap(false);
        if (map != null && (rgba = map.getValue(address)) != null) {
            return ColorUtils.getColor((int)rgba);
        }
        return null;
    }

    @Override
    public AddressSetView getAllBackgroundColorAddresses() {
        IntRangeMap map = this.getColorRangeMap(false);
        if (map != null) {
            return map.getAddressSet();
        }
        return new AddressSet();
    }

    @Override
    public AddressSetView getBackgroundColorAddresses(Color color) {
        IntRangeMap map = this.getColorRangeMap(false);
        if (map != null) {
            return map.getAddressSet(color.getRGB());
        }
        return new AddressSet();
    }

    @Override
    public void clearAllBackgroundColors() {
        IntRangeMap map = this.getColorRangeMap(false);
        if (map != null) {
            map.clearAll();
        }
    }

    @Override
    public void clearBackgroundColor(Address min, Address max) {
        IntRangeMap map = this.getColorRangeMap(false);
        if (map != null) {
            map.clearValue(min, max);
        }
    }

    @Override
    public void clearBackgroundColor(AddressSetView set) {
        IntRangeMap map = this.getColorRangeMap(false);
        if (map != null) {
            map.clearValue(set);
        }
    }

    private IntRangeMap getColorRangeMap(boolean create) {
        if (this.program == null) {
            return null;
        }
        IntRangeMap map = this.program.getIntRangeMap("LISTING_COLOR");
        if (map == null && create) {
            try {
                map = this.program.createIntRangeMap("LISTING_COLOR");
            }
            catch (DuplicateNameException duplicateNameException) {
                // empty catch block
            }
        }
        return map;
    }
}

