/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.actions;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.MenuData;
import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import ghidra.app.plugin.core.datamgr.DataTypeManagerPlugin;
import ghidra.app.plugin.core.datamgr.DataTypesActionContext;
import ghidra.app.plugin.core.datamgr.editor.DataTypeEditorManager;
import ghidra.app.plugin.core.datamgr.tree.BuiltInArchiveNode;
import ghidra.app.plugin.core.datamgr.tree.CategoryNode;
import ghidra.program.model.data.Category;
import javax.swing.tree.TreePath;

public abstract class CreateDataTypeAction
extends DockingAction {
    protected final DataTypeManagerPlugin plugin;

    CreateDataTypeAction(DataTypeManagerPlugin plugin, String name) {
        super(name, plugin.getName());
        this.plugin = plugin;
        this.setPopupMenuData(new MenuData(new String[]{"New", name + "..."}, "Create"));
        this.setEnabled(true);
    }

    public boolean isAddToPopup(ActionContext context) {
        CategoryNode categoryNode = this.getSelectedCategoryNode(context);
        if (categoryNode == null || !categoryNode.isEnabled()) {
            return false;
        }
        return !(categoryNode instanceof BuiltInArchiveNode);
    }

    public boolean isEnabledForContext(ActionContext context) {
        CategoryNode categoryNode = this.getSelectedCategoryNode(context);
        return categoryNode != null && categoryNode.isModifiable();
    }

    private CategoryNode getSelectedCategoryNode(ActionContext context) {
        if (!(context instanceof DataTypesActionContext)) {
            return null;
        }
        Object contextObject = context.getContextObject();
        GTree gtree = (GTree)contextObject;
        TreePath[] selectionPaths = gtree.getSelectionPaths();
        if (selectionPaths == null || selectionPaths.length != 1) {
            return null;
        }
        GTreeNode node = (GTreeNode)selectionPaths[0].getLastPathComponent();
        if (!(node instanceof CategoryNode)) {
            return null;
        }
        return (CategoryNode)node;
    }

    public void actionPerformed(ActionContext context) {
        GTree gTree = (GTree)context.getContextObject();
        TreePath[] paths = gTree.getSelectionPaths();
        CategoryNode node = (CategoryNode)((Object)paths[0].getLastPathComponent());
        Category category = node.getCategory();
        DataTypeEditorManager editorManager = this.plugin.getEditorManager();
        this.createNewDataType(editorManager, category);
    }

    protected abstract void createNewDataType(DataTypeEditorManager var1, Category var2);
}

