/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.actions;

import docking.DialogComponentProvider;
import docking.widgets.label.GLabel;
import ghidra.app.plugin.core.datamgr.DataTypeManagerPlugin;
import ghidra.app.plugin.core.datamgr.tree.ArchiveNode;
import ghidra.app.plugin.core.datamgr.tree.DataTypeTreeNode;
import ghidra.app.util.datatype.DataTypeSelectionEditor;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.data.BuiltInDataTypeManager;
import ghidra.program.model.data.Category;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.data.FunctionDefinition;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.program.model.data.PointerDataType;
import ghidra.util.MessageType;
import ghidra.util.data.DataTypeParser;
import ghidra.util.layout.PairLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Arrays;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.tree.TreePath;

public class CreateTypeDefDialog
extends DialogComponentProvider {
    private final DataTypeManagerPlugin plugin;
    private final Category category;
    private JTextField nameTextField;
    private DataTypeSelectionEditor dataTypeEditor;
    private JTextField categoryField;
    private boolean isCancelled;
    private final TreePath selectedTreePath;

    CreateTypeDefDialog(DataTypeManagerPlugin plugin, Category category, TreePath treePath) {
        super("Create TypeDef", true, true, true, false);
        this.plugin = plugin;
        this.category = category;
        this.selectedTreePath = treePath;
        this.addWorkPanel(this.createWorkPanel());
        this.addOKButton();
        this.addCancelButton();
    }

    private JComponent createWorkPanel() {
        List<DataTypeManager> managers = Arrays.stream(this.plugin.getDataTypeManagers()).filter(dtm -> !(dtm instanceof BuiltInDataTypeManager)).toList();
        DataTypeManager defaultDTM = this.getDefaultDataTypeManager(managers);
        JPanel panel = new JPanel((LayoutManager)new PairLayout());
        panel.add((Component)new GLabel("Category:"));
        panel.add((Component)new GLabel(this.category.getCategoryPath().getPath()));
        this.nameTextField = new JTextField(15);
        panel.add((Component)new GLabel("Name:"));
        panel.add(this.nameTextField);
        this.dataTypeEditor = new DataTypeSelectionEditor(null, (ServiceProvider)this.plugin.getTool(), DataTypeParser.AllowedDataTypes.ALL);
        panel.add((Component)new GLabel("Data type:"));
        panel.add(this.dataTypeEditor.getEditorComponent());
        this.dataTypeEditor.addCellEditorListener(new CellEditorListener(){

            @Override
            public void editingStopped(ChangeEvent e) {
                CreateTypeDefDialog.this.setStatusText("");
            }

            @Override
            public void editingCanceled(ChangeEvent e) {
                CreateTypeDefDialog.this.setStatusText("");
            }
        });
        this.dataTypeEditor.setDefaultSelectedTreePath(this.selectedTreePath);
        this.categoryField = new JTextField(24);
        this.categoryField.setEditable(false);
        this.categoryField.setName("Category");
        String archiveName = this.category.getDataTypeManager().getName();
        this.categoryField.setText(archiveName + this.category.getCategoryPath().getPath());
        panel.add((Component)new GLabel("Category:"));
        panel.add(this.categoryField);
        panel.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        return panel;
    }

    private DataTypeManager getDefaultDataTypeManager(List<DataTypeManager> mgrs) {
        DataTypeTreeNode dataTypeTreeNode;
        ArchiveNode archiveNode;
        DataTypeManager manager;
        Object lastPathComponent = this.selectedTreePath.getLastPathComponent();
        if (lastPathComponent instanceof DataTypeTreeNode && mgrs.contains(manager = (archiveNode = (dataTypeTreeNode = (DataTypeTreeNode)((Object)lastPathComponent)).getArchiveNode()).getArchive().getDataTypeManager())) {
            return manager;
        }
        return null;
    }

    protected void okCallback() {
        String name = this.nameTextField.getText();
        if (name == null || name.isEmpty()) {
            this.setStatusText("Name required", MessageType.ERROR);
            return;
        }
        if (!DataUtilities.isValidDataTypeName((String)name)) {
            this.setStatusText("Invalidate data type name: " + name, MessageType.ERROR);
            return;
        }
        String dtTextValue = this.dataTypeEditor.getCellEditorValueAsText();
        if (dtTextValue == null || dtTextValue.isEmpty()) {
            this.setStatusText("Data type required" + dtTextValue, MessageType.ERROR);
            return;
        }
        try {
            if (!this.dataTypeEditor.validateUserSelection()) {
                this.setStatusText("Invalidate data type: " + dtTextValue, MessageType.ERROR);
                return;
            }
        }
        catch (InvalidDataTypeException e) {
            this.setStatusText("Invalidate data type: " + dtTextValue, MessageType.ERROR);
            return;
        }
        DataType dataType = this.getDataType();
        if (!DataTypeManagerPlugin.isValidTypeDefBaseType(this.getComponent(), dataType)) {
            this.setStatusText("Data type cannot be source of a typedef: " + dataType.getName(), MessageType.ERROR);
            return;
        }
        this.clearStatusText();
        this.close();
    }

    protected void cancelCallback() {
        super.cancelCallback();
        this.isCancelled = true;
    }

    boolean isCancelled() {
        return this.isCancelled;
    }

    String getTypeDefName() {
        if (this.isCancelled) {
            return null;
        }
        return this.nameTextField.getText();
    }

    DataType getDataType() {
        DataType dataType = (DataType)this.dataTypeEditor.getCellEditorValue();
        if (dataType instanceof FunctionDefinition) {
            DataTypeManager dataTypeManager = dataType.getDataTypeManager();
            dataType = PointerDataType.getPointer((DataType)dataType, (DataTypeManager)dataTypeManager);
        }
        return dataType;
    }
}

