/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.actions;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import docking.widgets.OptionDialog;
import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import ghidra.app.plugin.core.datamgr.DataTypeManagerPlugin;
import ghidra.app.plugin.core.datamgr.DataTypesActionContext;
import ghidra.app.plugin.core.datamgr.tree.ArchiveNode;
import ghidra.app.plugin.core.datamgr.tree.DataTypeTreeNode;
import ghidra.app.plugin.core.datamgr.util.DataTypeTreeDeleteTask;
import ghidra.util.task.Task;
import java.util.ArrayList;
import javax.swing.tree.TreePath;

public class DeleteAction
extends DockingAction {
    private final DataTypeManagerPlugin plugin;

    public DeleteAction(DataTypeManagerPlugin plugin) {
        super("Delete", plugin.getName());
        this.plugin = plugin;
        this.setPopupMenuData(new MenuData(new String[]{"Delete"}, null, "Edit"));
        this.setKeyBindingData(new KeyBindingData(127, 0));
        this.setEnabled(true);
    }

    public boolean isAddToPopup(ActionContext context) {
        if (!(context instanceof DataTypesActionContext)) {
            return false;
        }
        TreePath[] selectionPaths = this.getSelectionPaths(context);
        if (selectionPaths == null || selectionPaths.length == 0) {
            return false;
        }
        return !this.containsUndeletableNodes(selectionPaths);
    }

    public boolean isEnabledForContext(ActionContext context) {
        if (!(context instanceof DataTypesActionContext)) {
            return false;
        }
        TreePath[] selectionPaths = this.getSelectionPaths(context);
        return this.canDelete(selectionPaths);
    }

    private TreePath[] getSelectionPaths(ActionContext context) {
        Object contextObject = context.getContextObject();
        GTree gtree = (GTree)contextObject;
        TreePath[] selectionPaths = gtree.getSelectionPaths();
        return selectionPaths;
    }

    private boolean containsUndeletableNodes(TreePath[] selectionPaths) {
        for (TreePath path : selectionPaths) {
            DataTypeTreeNode node = (DataTypeTreeNode)((Object)path.getLastPathComponent());
            if (node.canDelete() && !(node instanceof ArchiveNode)) continue;
            return true;
        }
        return false;
    }

    private boolean canDelete(TreePath[] selectionPaths) {
        for (TreePath path : selectionPaths) {
            DataTypeTreeNode node = (DataTypeTreeNode)((Object)path.getLastPathComponent());
            if (node.canCut()) continue;
            return false;
        }
        return true;
    }

    public void actionPerformed(ActionContext context) {
        int choice = OptionDialog.showYesNoDialogWithNoAsDefaultButton(null, (String)"Confirm Delete Operation", (String)"Are you sure you want to delete selected\ndata types and/or categories?\n\nNote: Changes may trigger the removal of related\ndata types, components and defined data.");
        if (choice != 1) {
            return;
        }
        GTree gtree = (GTree)context.getContextObject();
        TreePath[] selectionPaths = gtree.getSelectionPaths();
        ArrayList<GTreeNode> nodeList = new ArrayList<GTreeNode>(selectionPaths.length);
        for (TreePath path : selectionPaths) {
            nodeList.add((GTreeNode)path.getLastPathComponent());
        }
        this.plugin.getTool().execute((Task)new DataTypeTreeDeleteTask(this.plugin, nodeList), 250);
    }
}

